/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeMetadataFactory;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.procedure.Procedures;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.MethodHandleUtil;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;

public class VacuumProcedure
implements Provider<Procedure> {
    private static final Logger log = Logger.get(VacuumProcedure.class);
    private static final MethodHandle VACUUM = MethodHandleUtil.methodHandle(VacuumProcedure.class, (String)"vacuum", (Class[])new Class[]{ConnectorSession.class, String.class, String.class, String.class});
    private final CatalogName catalogName;
    private final HdfsEnvironment hdfsEnvironment;
    private final DeltaLakeMetadataFactory metadataFactory;
    private final TransactionLogAccess transactionLogAccess;

    @Inject
    public VacuumProcedure(CatalogName catalogName, HdfsEnvironment hdfsEnvironment, DeltaLakeMetadataFactory metadataFactory, TransactionLogAccess transactionLogAccess) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.metadataFactory = Objects.requireNonNull(metadataFactory, "metadataFactory is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
    }

    public Procedure get() {
        return new Procedure("system", "vacuum", (List)ImmutableList.of((Object)new Procedure.Argument("SCHEMA_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("TABLE_NAME", (Type)VarcharType.VARCHAR), (Object)new Procedure.Argument("RETENTION", (Type)VarcharType.VARCHAR)), VACUUM.bindTo(this));
    }

    public void vacuum(ConnectorSession session, String schema, String table, String retention) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doVacuum(session, schema, table, retention);
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Failure when vacuuming %s.%s with retention %s", schema, table, retention), e);
        }
    }

    private void doVacuum(ConnectorSession session, String schema, String table, String retention) throws IOException {
        Procedures.checkProcedureArgument(schema != null, "schema_name cannot be null", new Object[0]);
        Procedures.checkProcedureArgument(!schema.isEmpty(), "schema_name cannot be empty", new Object[0]);
        Procedures.checkProcedureArgument(table != null, "table_name cannot be null", new Object[0]);
        Procedures.checkProcedureArgument(!table.isEmpty(), "table_name cannot be empty", new Object[0]);
        Procedures.checkProcedureArgument(retention != null, "retention cannot be null", new Object[0]);
        Duration retentionDuration = Duration.valueOf((String)retention);
        Duration minRetention = DeltaLakeSessionProperties.getVacuumMinRetention(session);
        Procedures.checkProcedureArgument(retentionDuration.compareTo(minRetention) >= 0, "Retention specified (%s) is shorter than the minimum retention configured in the system (%s). Minimum retention can be changed with %s configuration property or %s.%s session property", retentionDuration, minRetention, "delta.vacuum.min-retention", this.catalogName, "vacuum_min_retention");
        Instant threshold = Instant.now().minusMillis(retentionDuration.toMillis());
        DeltaLakeMetadata metadata = this.metadataFactory.create(session.getIdentity());
        SchemaTableName tableName = new SchemaTableName(schema, table);
        DeltaLakeTableHandle handle = metadata.getTableHandle(session, tableName);
        Procedures.checkProcedureArgument(handle != null, "Table '%s' does not exist", tableName);
        TableSnapshot tableSnapshot = this.transactionLogAccess.loadSnapshot(tableName, new Path(handle.getLocation()), session);
        Path tableLocation = tableSnapshot.getTableLocation();
        Path transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), tableLocation);
        String commonPathPrefix = tableLocation + "/";
        String queryId = session.getQueryId();
        List<Long> recentVersions = this.transactionLogAccess.getPastTableVersions(fileSystem, transactionLogDir, threshold, tableSnapshot.getVersion());
        Set retainedPaths = (Set)Stream.concat(this.transactionLogAccess.getActiveFiles(tableSnapshot, session).stream().map(AddFileEntry::getPath), this.transactionLogAccess.getJsonEntries(fileSystem, transactionLogDir, (List)recentVersions.stream().sorted(Comparator.naturalOrder()).skip(1L).collect(ImmutableList.toImmutableList())).map(DeltaLakeTransactionLogEntry::getRemove).filter(Objects::nonNull).map(RemoveFileEntry::getPath)).peek(path -> Preconditions.checkState((!path.startsWith(tableLocation.toString()) ? 1 : 0) != 0, (String)"Unexpected absolute path in transaction log: %s", (Object)path)).collect(ImmutableSet.toImmutableSet());
        log.debug("[%s] attempting to vacuum table %s [%s] with %s retention (expiry threshold %s). %s data file paths marked for retention", new Object[]{queryId, tableName, tableLocation, retention, threshold, retainedPaths.size()});
        long nonFiles = 0L;
        long allPathsChecked = 0L;
        long transactionLogFiles = 0L;
        long retainedKnownFiles = 0L;
        long retainedUnknownFiles = 0L;
        long removedFiles = 0L;
        RemoteIterator listing = fileSystem.listFiles(tableLocation, true);
        while (listing.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)listing.next();
            Path path2 = fileStatus.getPath();
            Preconditions.checkState((boolean)path2.toString().startsWith(commonPathPrefix), (String)"Unexpected path [%s] returned when listing files under [%s]", (Object)path2, (Object)tableLocation);
            String relativePath = path2.toString().substring(commonPathPrefix.length());
            if (relativePath.isEmpty()) continue;
            ++allPathsChecked;
            if (!fileStatus.isFile()) {
                ++nonFiles;
                continue;
            }
            if (relativePath.equals("_delta_log") || relativePath.startsWith("_delta_log/")) {
                log.debug("[%s] skipping a file inside transaction log dir: %s", new Object[]{queryId, path2});
                ++transactionLogFiles;
                continue;
            }
            if (retainedPaths.contains(relativePath)) {
                log.debug("[%s] retaining a known file: %s", new Object[]{queryId, path2});
                ++retainedKnownFiles;
                continue;
            }
            long modificationTime = fileStatus.getModificationTime();
            Instant modificationInstant = Instant.ofEpochMilli(modificationTime);
            if (!modificationInstant.isBefore(threshold)) {
                log.debug("[%s] retaining an unknown file %s with modification time %s (%s)", new Object[]{queryId, path2, modificationTime, modificationInstant});
                ++retainedUnknownFiles;
                continue;
            }
            log.debug("[%s] deleting file [%s] with modification time %s (%s)", new Object[]{queryId, path2, modificationTime, modificationInstant});
            if (!fileSystem.delete(path2, false)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Failed to delete file: " + path2);
            }
            ++removedFiles;
        }
        log.info("[%s] finished vacuuming table %s [%s]: files checked: %s; non-files: %s; metadata files: %s; retained known files: %s; retained unknown files: %s; removed files: %s", new Object[]{queryId, tableName, tableLocation, allPathsChecked, nonFiles, transactionLogFiles, retainedKnownFiles, retainedUnknownFiles, removedFiles});
    }
}

