/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.stats.cardinality.HyperLogLog;
import java.util.Base64;
import java.util.Objects;

public class DeltaLakeColumnStatistics {
    private final HyperLogLog ndvSummary;

    @JsonCreator
    public static DeltaLakeColumnStatistics create(@JsonProperty(value="ndvSummary") String ndvSummaryBase64) {
        Objects.requireNonNull(ndvSummaryBase64, "ndvSummaryBase64 is null");
        byte[] ndvSummaryBytes = Base64.getDecoder().decode(ndvSummaryBase64);
        return new DeltaLakeColumnStatistics(HyperLogLog.newInstance((Slice)Slices.wrappedBuffer((byte[])ndvSummaryBytes)));
    }

    public static DeltaLakeColumnStatistics create(HyperLogLog ndvSummary) {
        return new DeltaLakeColumnStatistics(ndvSummary);
    }

    private DeltaLakeColumnStatistics(HyperLogLog ndvSummary) {
        this.ndvSummary = Objects.requireNonNull(ndvSummary, "ndvSummary is null");
    }

    @JsonProperty(value="ndvSummary")
    public String getNdvSummaryBase64() {
        return Base64.getEncoder().encodeToString(this.ndvSummary.serialize().getBytes());
    }

    public HyperLogLog getNdvSummary() {
        return this.ndvSummary;
    }

    public DeltaLakeColumnStatistics update(DeltaLakeColumnStatistics newStatistics) {
        HyperLogLog ndvSummary = HyperLogLog.newInstance((Slice)this.ndvSummary.serialize());
        ndvSummary.mergeWith(newStatistics.ndvSummary);
        return new DeltaLakeColumnStatistics(ndvSummary);
    }
}

