/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.plugin.deltalake.statistics.DeltaLakeStatistics;
import io.trino.plugin.deltalake.statistics.DeltaLakeStatisticsAccess;
import io.trino.plugin.hive.HdfsEnvironment;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class MetaDirStatisticsAccess
implements DeltaLakeStatisticsAccess {
    private static final String STATISTICS_META_DIR = "_delta_log/_trino_meta";
    private static final String STATISTICS_FILE = "extended_stats.json";
    private final HdfsEnvironment hdfsEnvironment;
    private final JsonCodec<DeltaLakeStatistics> statisticsCodec;

    @Inject
    public MetaDirStatisticsAccess(HdfsEnvironment hdfsEnvironment, JsonCodec<DeltaLakeStatistics> statisticsCodec) {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.statisticsCodec = Objects.requireNonNull(statisticsCodec, "statisticsCodec is null");
    }

    @Override
    public Optional<DeltaLakeStatistics> readDeltaLakeStatistics(ConnectorSession session, String tableLocation) {
        Optional<DeltaLakeStatistics> optional;
        block9: {
            Path metadataDir = new Path(tableLocation, STATISTICS_META_DIR);
            Path statisticsPath = new Path(metadataDir, STATISTICS_FILE);
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), statisticsPath);
            if (!fileSystem.exists(statisticsPath)) {
                return Optional.empty();
            }
            FSDataInputStream inputStream = fileSystem.open(statisticsPath);
            try {
                optional = Optional.of((DeltaLakeStatistics)this.statisticsCodec.fromJson(inputStream.readAllBytes()));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("failed to read statistics with table location %s", tableLocation), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    @Override
    public void updateDeltaLakeStatistics(ConnectorSession session, String tableLocation, DeltaLakeStatistics statistics) {
        Path metaPath = new Path(tableLocation, STATISTICS_META_DIR);
        this.ensureDirectoryExists(session, metaPath);
        try {
            Path statisticsPath = new Path(metaPath, STATISTICS_FILE);
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), metaPath);
            try (FSDataOutputStream outputStream = fileSystem.create(statisticsPath, true);){
                outputStream.write(this.statisticsCodec.toJsonBytes((Object)statistics));
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("failed to store statistics with table location %s", tableLocation), (Throwable)e);
        }
    }

    @Override
    public void deleteDeltaLakeStatistics(ConnectorSession session, String tableLocation) {
        Path statisticsPath = new Path(new Path(tableLocation, STATISTICS_META_DIR), STATISTICS_FILE);
        try {
            FileSystem hdfs = this.hdfsEnvironment.getFileSystem(new HdfsEnvironment.HdfsContext(session), statisticsPath);
            if (!hdfs.delete(statisticsPath, false) && hdfs.exists(statisticsPath)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Failed to delete statistics file %s", statisticsPath));
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Error deleting statistics file %s", statisticsPath), (Throwable)e);
        }
    }

    private void ensureDirectoryExists(ConnectorSession session, Path directoryPath) {
        HdfsEnvironment.HdfsContext hdfsContext = new HdfsEnvironment.HdfsContext(session);
        if (!HiveWriteUtils.pathExists((HdfsEnvironment.HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)directoryPath)) {
            HiveWriteUtils.createDirectory((HdfsEnvironment.HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)directoryPath);
        }
    }
}

