/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Location;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class DeltaLakeSchemaSupport {
    private static final Map<Type, String> PRIMITIVE_TYPE_MAPPING = ImmutableMap.builder().put((Object)BigintType.BIGINT, (Object)"long").put((Object)IntegerType.INTEGER, (Object)"integer").put((Object)SmallintType.SMALLINT, (Object)"short").put((Object)TinyintType.TINYINT, (Object)"byte").put((Object)RealType.REAL, (Object)"float").put((Object)DoubleType.DOUBLE, (Object)"double").put((Object)BooleanType.BOOLEAN, (Object)"boolean").put((Object)VarbinaryType.VARBINARY, (Object)"binary").put((Object)DateType.DATE, (Object)"date").buildOrThrow();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();

    private DeltaLakeSchemaSupport() {
    }

    public static List<DeltaLakeColumnHandle> extractPartitionColumns(MetadataEntry metadataEntry, TypeManager typeManager) {
        return DeltaLakeSchemaSupport.extractPartitionColumns(DeltaLakeSchemaSupport.extractSchema(metadataEntry, typeManager), metadataEntry.getCanonicalPartitionColumns());
    }

    public static List<DeltaLakeColumnHandle> extractPartitionColumns(List<ColumnMetadata> schema, List<String> canonicalPartitionColumns) {
        if (canonicalPartitionColumns.isEmpty()) {
            return ImmutableList.of();
        }
        return (List)schema.stream().filter(entry -> canonicalPartitionColumns.contains(entry.getName())).map(entry -> new DeltaLakeColumnHandle(entry.getName(), entry.getType(), DeltaLakeColumnType.PARTITION_KEY)).collect(ImmutableList.toImmutableList());
    }

    public static String serializeSchemaAsJson(List<DeltaLakeColumnHandle> columns) {
        try {
            return OBJECT_MAPPER.writeValueAsString(DeltaLakeSchemaSupport.serializeStructType(columns));
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to encode Delta Lake schema", (Throwable)e);
        }
    }

    private static Map<String, Object> serializeStructType(List<DeltaLakeColumnHandle> columns) {
        ImmutableMap.Builder schema = ImmutableMap.builder();
        schema.put((Object)"fields", columns.stream().map(column -> DeltaLakeSchemaSupport.serializeStructField(column.getName(), column.getType())).collect(ImmutableList.toImmutableList()));
        schema.put((Object)"type", (Object)"struct");
        return schema.buildOrThrow();
    }

    private static Map<String, Object> serializeStructField(String name, Type type) {
        ImmutableMap.Builder fieldContents = ImmutableMap.builder();
        fieldContents.put((Object)"metadata", (Object)ImmutableMap.of());
        fieldContents.put((Object)"name", (Object)name);
        fieldContents.put((Object)"nullable", (Object)true);
        fieldContents.put((Object)"type", DeltaLakeSchemaSupport.serializeColumnType(type));
        return fieldContents.buildOrThrow();
    }

    private static Object serializeColumnType(Type columnType) {
        if (columnType instanceof ArrayType) {
            return DeltaLakeSchemaSupport.serializeArrayType((ArrayType)columnType);
        }
        if (columnType instanceof RowType) {
            return DeltaLakeSchemaSupport.serializeStructType((RowType)columnType);
        }
        if (columnType instanceof MapType) {
            return DeltaLakeSchemaSupport.serializeMapType((MapType)columnType);
        }
        return DeltaLakeSchemaSupport.serializePrimitiveType(columnType);
    }

    private static Map<String, Object> serializeArrayType(ArrayType arrayType) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"type", (Object)"array");
        fields.put((Object)"containsNull", (Object)true);
        fields.put((Object)"elementType", DeltaLakeSchemaSupport.serializeColumnType(arrayType.getElementType()));
        return fields.buildOrThrow();
    }

    private static Map<String, Object> serializeMapType(MapType mapType) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"keyType", DeltaLakeSchemaSupport.serializeColumnType(mapType.getKeyType()));
        fields.put((Object)"type", (Object)"map");
        fields.put((Object)"valueContainsNull", (Object)true);
        fields.put((Object)"valueType", DeltaLakeSchemaSupport.serializeColumnType(mapType.getValueType()));
        return fields.buildOrThrow();
    }

    private static Map<String, Object> serializeStructType(RowType rowType) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"type", (Object)"struct");
        fields.put((Object)"fields", rowType.getFields().stream().map(field -> DeltaLakeSchemaSupport.serializeStructField(field.getName().orElse(null), field.getType())).collect(ImmutableList.toImmutableList()));
        return fields.buildOrThrow();
    }

    private static String serializePrimitiveType(Type type) {
        return DeltaLakeSchemaSupport.serializeSupportedPrimitiveType(type).orElseThrow(() -> new TypeNotFoundException(type.getTypeSignature()));
    }

    private static Optional<String> serializeSupportedPrimitiveType(Type type) {
        if (type instanceof TimestampWithTimeZoneType) {
            return Optional.of("timestamp");
        }
        if (type instanceof VarcharType) {
            return Optional.of("string");
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return Optional.of(String.format("decimal(%s,%s)", decimalType.getPrecision(), decimalType.getScale()));
        }
        return Optional.ofNullable(PRIMITIVE_TYPE_MAPPING.get(type));
    }

    public static void validateType(Type type) {
        DeltaLakeSchemaSupport.validateType(Optional.empty(), type);
    }

    private static void validateType(Optional<Type> rootType, Type type) {
        rootType.ifPresent(root -> {
            if (type instanceof TimestampWithTimeZoneType) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Nested TIMESTAMP types are not supported, invalid type: " + root);
            }
        });
        if (HiveUtil.isStructuralType((Type)type)) {
            DeltaLakeSchemaSupport.validateStructuralType(Optional.of(rootType.orElse(type)), type);
        } else {
            DeltaLakeSchemaSupport.validatePrimitiveType(type);
        }
    }

    private static void validateStructuralType(Optional<Type> rootType, Type type) {
        if (type instanceof ArrayType) {
            DeltaLakeSchemaSupport.validateType(rootType, ((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            DeltaLakeSchemaSupport.validateType(rootType, mapType.getKeyType());
            DeltaLakeSchemaSupport.validateType(rootType, mapType.getValueType());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            rowType.getFields().forEach(field -> DeltaLakeSchemaSupport.validateType(rootType, field.getType()));
        }
    }

    private static void validatePrimitiveType(Type type) {
        if (DeltaLakeSchemaSupport.serializeSupportedPrimitiveType(type).isEmpty() || type instanceof TimestampWithTimeZoneType && ((TimestampWithTimeZoneType)type).getPrecision() != 3) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Unsupported type: " + type);
        }
    }

    public static String serializeStatsAsJson(DeltaLakeFileStatistics fileStatistics) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)fileStatistics);
    }

    public static List<ColumnMetadata> extractSchema(MetadataEntry metadataEntry, TypeManager typeManager) {
        return Optional.ofNullable(metadataEntry.getSchemaString()).map(json -> DeltaLakeSchemaSupport.getColumnMetadata(json, typeManager)).orElseThrow(() -> new IllegalStateException("Serialized schema not found in transaction log for " + metadataEntry.getName()));
    }

    @VisibleForTesting
    static List<ColumnMetadata> getColumnMetadata(String json, TypeManager typeManager) {
        try {
            return (List)Streams.stream((Iterator)OBJECT_MAPPER.readTree(json).get("fields").elements()).map(node -> DeltaLakeSchemaSupport.mapColumn(typeManager, node)).collect(ImmutableList.toImmutableList());
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to parse serialized schema: " + json, (Throwable)e);
        }
    }

    private static ColumnMetadata mapColumn(TypeManager typeManager, JsonNode node) {
        String fieldName = node.get("name").asText();
        JsonNode typeNode = node.get("type");
        boolean nullable = node.get("nullable").asBoolean();
        return ColumnMetadata.builder().setName(fieldName).setType(DeltaLakeSchemaSupport.buildType(typeManager, typeNode)).setNullable(nullable).build();
    }

    private static Type buildType(TypeManager typeManager, JsonNode typeNode) {
        if (typeNode.isContainerNode()) {
            return DeltaLakeSchemaSupport.buildContainerType(typeManager, typeNode);
        }
        String primitiveType = typeNode.asText();
        if (primitiveType.startsWith("decimal")) {
            return typeManager.fromSqlType(primitiveType);
        }
        switch (primitiveType) {
            case "string": {
                return VarcharType.VARCHAR;
            }
            case "long": {
                return BigintType.BIGINT;
            }
            case "integer": {
                return IntegerType.INTEGER;
            }
            case "short": {
                return SmallintType.SMALLINT;
            }
            case "byte": {
                return TinyintType.TINYINT;
            }
            case "float": {
                return RealType.REAL;
            }
            case "double": {
                return DoubleType.DOUBLE;
            }
            case "boolean": {
                return BooleanType.BOOLEAN;
            }
            case "binary": {
                return VarbinaryType.VARBINARY;
            }
            case "date": {
                return DateType.DATE;
            }
            case "timestamp": {
                return TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3);
            }
        }
        throw new TypeNotFoundException(new TypeSignature(primitiveType, new TypeSignatureParameter[0]));
    }

    private static Type buildContainerType(TypeManager typeManager, JsonNode typeNode) {
        String containerType;
        switch (containerType = typeNode.get("type").asText()) {
            case "array": {
                return DeltaLakeSchemaSupport.buildArrayType(typeManager, typeNode);
            }
            case "map": {
                return DeltaLakeSchemaSupport.buildMapType(typeManager, typeNode);
            }
            case "struct": {
                return DeltaLakeSchemaSupport.buildRowType(typeManager, typeNode);
            }
        }
        throw new TypeNotFoundException(new TypeSignature(containerType, new TypeSignatureParameter[0]));
    }

    private static RowType buildRowType(TypeManager typeManager, JsonNode typeNode) {
        return (RowType)typeManager.getType(TypeSignature.rowType((List)((List)Streams.stream((Iterator)typeNode.get("fields").elements()).map(element -> TypeSignatureParameter.namedField((String)TransactionLogAccess.canonicalizeColumnName(element.get("name").asText()), (TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, element.get("type")).getTypeSignature())).collect(ImmutableList.toImmutableList()))));
    }

    private static ArrayType buildArrayType(TypeManager typeManager, JsonNode typeNode) {
        return (ArrayType)typeManager.getType(TypeSignature.arrayType((TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("elementType")).getTypeSignature()));
    }

    private static MapType buildMapType(TypeManager typeManager, JsonNode typeNode) {
        return (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("keyType")).getTypeSignature(), (TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("valueType")).getTypeSignature()));
    }

    private static Optional<Location> getLocation(JsonProcessingException e) {
        return Optional.ofNullable(e.getLocation()).map(location -> new Location(location.getLineNr(), location.getColumnNr()));
    }
}

