/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;

public class LastCheckpoint {
    private final long version;
    private final BigInteger size;
    private final Optional<Integer> parts;

    @JsonCreator
    public LastCheckpoint(@JsonProperty(value="version") long version, @JsonProperty(value="size") BigInteger size, @JsonProperty(value="parts") Optional<Integer> parts) {
        this.version = version;
        this.size = Objects.requireNonNull(size, "size is null");
        this.parts = Objects.requireNonNull(parts, "parts is null");
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public BigInteger getSize() {
        return this.size;
    }

    @JsonProperty
    public Optional<Integer> getParts() {
        return this.parts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LastCheckpoint that = (LastCheckpoint)o;
        return this.version == that.version && this.size.equals(that.size) && this.parts.equals(that.parts);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.size, this.parts);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.version).add("size", (Object)this.size).add("parts", this.parts).toString();
    }
}

