/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.transactionlog.writer.NoIsolationSynchronizer;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

public class TransactionLogSynchronizerManager {
    private final Map<String, TransactionLogSynchronizer> synchronizers;
    private final NoIsolationSynchronizer noIsolationSynchronizer;

    @Inject
    public TransactionLogSynchronizerManager(Map<String, TransactionLogSynchronizer> synchronizers, NoIsolationSynchronizer noIsolationSynchronizer) {
        this.synchronizers = ImmutableMap.copyOf(synchronizers);
        this.noIsolationSynchronizer = Objects.requireNonNull(noIsolationSynchronizer, "noIsolationSynchronizer is null");
    }

    public TransactionLogSynchronizer getSynchronizer(Path tableLocation) {
        String uriScheme = tableLocation.toUri().getScheme();
        Preconditions.checkArgument((uriScheme != null ? 1 : 0) != 0, (Object)("URI scheme undefined for " + tableLocation));
        TransactionLogSynchronizer synchronizer = this.synchronizers.get(uriScheme.toLowerCase(Locale.ENGLISH));
        if (synchronizer == null) {
            throw new IllegalArgumentException(String.format("Cannot write to table in %s; %s not supported", tableLocation, uriScheme));
        }
        return synchronizer;
    }

    public TransactionLogSynchronizer getNoIsolationSynchronizer() {
        return this.noIsolationSynchronizer;
    }
}

