/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import io.airlift.slice.Slice;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.parquet.ChunkKey;
import io.trino.parquet.ChunkReader;
import io.trino.parquet.DiskRange;
import io.trino.parquet.Field;
import io.trino.parquet.GroupField;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetValidationUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.predicate.Predicate;
import io.trino.parquet.reader.ColumnChunk;
import io.trino.parquet.reader.ColumnChunkDescriptor;
import io.trino.parquet.reader.FilteredOffsetIndex;
import io.trino.parquet.reader.ListColumnReader;
import io.trino.parquet.reader.PageReader;
import io.trino.parquet.reader.ParquetColumnChunk;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.parquet.reader.StructColumnReader;
import io.trino.spi.block.ArrayBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexFilter;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.joda.time.DateTimeZone;

public class ParquetReader
implements Closeable {
    private static final int MAX_VECTOR_LENGTH = 1024;
    private static final int INITIAL_BATCH_SIZE = 1;
    private static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private final Optional<String> fileCreatedBy;
    private final List<BlockMetaData> blocks;
    private final Optional<List<Long>> firstRowsOfBlocks;
    private final List<PrimitiveColumnIO> columns;
    private final ParquetDataSource dataSource;
    private final DateTimeZone timeZone;
    private final AggregatedMemoryContext memoryContext;
    private final Optional<FilterPredicate> filter;
    private int currentRowGroup = -1;
    private BlockMetaData currentBlockMetadata;
    private long currentGroupRowCount;
    private Optional<Long> firstRowIndexInGroup = Optional.empty();
    private RowRanges currentGroupRowRanges;
    private long nextRowInGroup;
    private int batchSize;
    private int nextBatchSize = 1;
    private final PrimitiveColumnReader[] columnReaders;
    private final long[] maxBytesPerCell;
    private long maxCombinedBytesPerRow;
    private final ParquetReaderOptions options;
    private int maxBatchSize = 1024;
    private AggregatedMemoryContext currentRowGroupMemoryContext;
    private final Multimap<ChunkKey, ChunkReader> chunkReaders;
    private final List<Optional<ColumnIndexStore>> columnIndexStore;
    private final List<RowRanges> blockRowRanges;
    private final Map<ColumnPath, ColumnDescriptor> paths = new HashMap<ColumnPath, ColumnDescriptor>();

    public ParquetReader(Optional<String> fileCreatedBy, MessageColumnIO messageColumnIO, List<BlockMetaData> blocks, Optional<List<Long>> firstRowsOfBlocks, ParquetDataSource dataSource, DateTimeZone timeZone, AggregatedMemoryContext memoryContext, ParquetReaderOptions options) throws IOException {
        this(fileCreatedBy, messageColumnIO, blocks, firstRowsOfBlocks, dataSource, timeZone, memoryContext, options, null, null);
    }

    public ParquetReader(Optional<String> fileCreatedBy, MessageColumnIO messageColumnIO, List<BlockMetaData> blocks, Optional<List<Long>> firstRowsOfBlocks, ParquetDataSource dataSource, DateTimeZone timeZone, AggregatedMemoryContext memoryContext, ParquetReaderOptions options, Predicate parquetPredicate, List<Optional<ColumnIndexStore>> columnIndexStore) throws IOException {
        this.fileCreatedBy = Objects.requireNonNull(fileCreatedBy, "fileCreatedBy is null");
        this.columns = Objects.requireNonNull(messageColumnIO, "messageColumnIO is null").getLeaves();
        this.blocks = Objects.requireNonNull(blocks, "blocks is null");
        this.firstRowsOfBlocks = Objects.requireNonNull(firstRowsOfBlocks, "firstRowsOfBlocks is null");
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.timeZone = Objects.requireNonNull(timeZone, "timeZone is null");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
        this.currentRowGroupMemoryContext = memoryContext.newAggregatedMemoryContext();
        this.options = Objects.requireNonNull(options, "options is null");
        this.columnReaders = new PrimitiveColumnReader[this.columns.size()];
        this.maxBytesPerCell = new long[this.columns.size()];
        firstRowsOfBlocks.ifPresent(firstRows -> Preconditions.checkArgument((blocks.size() == firstRows.size() ? 1 : 0) != 0, (Object)"elements of firstRowsOfBlocks must correspond to blocks"));
        this.columnIndexStore = columnIndexStore;
        this.blockRowRanges = ParquetReader.listWithNulls(this.blocks.size());
        for (PrimitiveColumnIO column : this.columns) {
            ColumnDescriptor columnDescriptor = column.getColumnDescriptor();
            this.paths.put(ColumnPath.get((String[])columnDescriptor.getPath()), columnDescriptor);
        }
        this.filter = parquetPredicate != null && options.isUseColumnIndex() ? parquetPredicate.toParquetFilter(timeZone) : Optional.empty();
        ArrayListMultimap ranges = ArrayListMultimap.create();
        for (int rowGroup = 0; rowGroup < blocks.size(); ++rowGroup) {
            BlockMetaData metadata = blocks.get(rowGroup);
            for (PrimitiveColumnIO column : this.columns) {
                int columnId = column.getId();
                ColumnChunkMetaData chunkMetadata = this.getColumnChunkMetaData(metadata, column.getColumnDescriptor());
                ColumnPath columnPath = chunkMetadata.getPath();
                long rowGroupRowCount = metadata.getRowCount();
                long startingPosition = chunkMetadata.getStartingPos();
                long totalLength = chunkMetadata.getTotalSize();
                FilteredOffsetIndex filteredOffsetIndex = this.getFilteredOffsetIndex(rowGroup, rowGroupRowCount, columnPath);
                if (filteredOffsetIndex == null) {
                    DiskRange range = new DiskRange(startingPosition, Math.toIntExact(totalLength));
                    ranges.put((Object)new ChunkKey(columnId, rowGroup), (Object)range);
                    continue;
                }
                List<FilteredOffsetIndex.OffsetRange> offsetRanges = filteredOffsetIndex.calculateOffsetRanges(startingPosition);
                for (FilteredOffsetIndex.OffsetRange offsetRange : offsetRanges) {
                    DiskRange range = new DiskRange(offsetRange.getOffset(), Math.toIntExact(offsetRange.getLength()));
                    ranges.put((Object)new ChunkKey(columnId, rowGroup), (Object)range);
                }
            }
        }
        this.chunkReaders = dataSource.planRead(ranges);
    }

    @Override
    public void close() throws IOException {
        this.freeCurrentRowGroupBuffers();
        this.currentRowGroupMemoryContext.close();
        this.dataSource.close();
    }

    public long lastBatchStartRow() {
        long baseIndex = this.firstRowIndexInGroup.orElseThrow(() -> new IllegalStateException("row index unavailable"));
        return baseIndex + this.nextRowInGroup - (long)this.batchSize;
    }

    public int nextBatch() {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        this.batchSize = Math.min(this.nextBatchSize, this.maxBatchSize);
        this.nextBatchSize = Math.min(this.batchSize * 2, 1024);
        this.batchSize = Math.toIntExact(Math.min((long)this.batchSize, this.currentGroupRowCount - this.nextRowInGroup));
        this.nextRowInGroup += (long)this.batchSize;
        Arrays.stream(this.columnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        return this.batchSize;
    }

    private boolean advanceToNextRowGroup() {
        this.currentRowGroupMemoryContext.close();
        this.currentRowGroupMemoryContext = this.memoryContext.newAggregatedMemoryContext();
        this.freeCurrentRowGroupBuffers();
        ++this.currentRowGroup;
        if (this.currentRowGroup == this.blocks.size()) {
            return false;
        }
        this.currentBlockMetadata = this.blocks.get(this.currentRowGroup);
        this.firstRowIndexInGroup = this.firstRowsOfBlocks.map(firstRows -> (Long)firstRows.get(this.currentRowGroup));
        this.currentGroupRowCount = this.currentBlockMetadata.getRowCount();
        if (this.filter.isPresent() && this.options.isUseColumnIndex() && this.columnIndexStore.get(this.currentRowGroup).isPresent()) {
            this.currentGroupRowRanges = this.getRowRanges(this.filter.get(), this.currentRowGroup);
            long rowCount = this.currentGroupRowRanges.rowCount();
            if (rowCount == 0L) {
                return false;
            }
            this.currentGroupRowCount = rowCount;
        }
        this.nextRowInGroup = 0L;
        this.initializeColumnReaders();
        return true;
    }

    private void freeCurrentRowGroupBuffers() {
        if (this.currentRowGroup < 0) {
            return;
        }
        for (int column = 0; column < this.columns.size(); ++column) {
            Collection readers = this.chunkReaders.get((Object)new ChunkKey(column, this.currentRowGroup));
            if (readers == null) continue;
            for (ChunkReader reader : readers) {
                reader.free();
            }
        }
    }

    private ColumnChunk readArray(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0, (String)"Arrays must have a single type parameter, found %s", (int)parameters.size());
        Field elementField = field.getChildren().get(0).get();
        ColumnChunk columnChunk = this.readColumnChunk(elementField);
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block arrayBlock = ArrayBlock.fromElementBlock((int)valueIsNull.size(), Optional.of(valueIsNull.toBooleanArray()), (int[])offsets.toIntArray(), (Block)columnChunk.getBlock());
        return new ColumnChunk(arrayBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readMap(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Maps must have two type parameters, found %s", (int)parameters.size());
        Block[] blocks = new Block[parameters.size()];
        ColumnChunk columnChunk = this.readColumnChunk(field.getChildren().get(0).get());
        blocks[0] = columnChunk.getBlock();
        blocks[1] = this.readColumnChunk(field.getChildren().get(1).get()).getBlock();
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block mapBlock = ((MapType)field.getType()).createBlockFromKeyValue(Optional.of(valueIsNull.toBooleanArray()), offsets.toIntArray(), blocks[0], blocks[1]);
        return new ColumnChunk(mapBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readStruct(GroupField field) throws IOException {
        int i;
        List fields = field.getType().getTypeSignature().getParameters();
        Block[] blocks = new Block[fields.size()];
        ColumnChunk columnChunk = null;
        List<Optional<Field>> parameters = field.getChildren();
        for (i = 0; i < fields.size(); ++i) {
            Optional<Field> parameter = parameters.get(i);
            if (!parameter.isPresent()) continue;
            columnChunk = this.readColumnChunk(parameter.get());
            blocks[i] = columnChunk.getBlock();
        }
        for (i = 0; i < fields.size(); ++i) {
            if (blocks[i] != null) continue;
            blocks[i] = RunLengthEncodedBlock.create((Type)((Type)field.getType().getTypeParameters().get(i)), null, (int)columnChunk.getBlock().getPositionCount());
        }
        BooleanList structIsNull = StructColumnReader.calculateStructOffsets(field, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        boolean[] structIsNullVector = structIsNull.toBooleanArray();
        Block rowBlock = RowBlock.fromFieldBlocks((int)structIsNullVector.length, Optional.of(structIsNullVector), (Block[])blocks);
        return new ColumnChunk(rowBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private FilteredOffsetIndex getFilteredOffsetIndex(int rowGroup, long rowGroupRowCount, ColumnPath columnPath) {
        OffsetIndex offsetIndex;
        Optional<ColumnIndexStore> columnIndexStore;
        RowRanges rowRanges;
        if (this.filter.isPresent() && (rowRanges = this.getRowRanges(this.filter.get(), rowGroup)) != null && rowRanges.rowCount() < rowGroupRowCount && (columnIndexStore = this.columnIndexStore.get(rowGroup)).isPresent() && (offsetIndex = columnIndexStore.get().getOffsetIndex(columnPath)) != null) {
            return FilteredOffsetIndex.filterOffsetIndex(offsetIndex, rowRanges, rowGroupRowCount);
        }
        return null;
    }

    private ColumnChunk readPrimitive(PrimitiveField field) throws IOException {
        ColumnChunk columnChunk;
        long bytesPerCell;
        RichColumnDescriptor columnDescriptor = field.getDescriptor();
        int fieldId = field.getId();
        PrimitiveColumnReader columnReader = this.columnReaders[fieldId];
        if (columnReader.getPageReader() == null) {
            ParquetValidationUtils.validateParquet(this.currentBlockMetadata.getRowCount() > 0L, "Row group has 0 rows", new Object[0]);
            ColumnChunkMetaData metadata = this.getColumnChunkMetaData(this.currentBlockMetadata, columnDescriptor);
            FilteredOffsetIndex offsetIndex = this.getFilteredOffsetIndex(this.currentRowGroup, this.currentBlockMetadata.getRowCount(), metadata.getPath());
            List<Slice> slices = this.allocateBlock(fieldId);
            columnReader.setPageReader(this.createPageReader(slices, metadata, columnDescriptor, offsetIndex), this.currentGroupRowRanges);
        }
        if (this.maxBytesPerCell[fieldId] < (bytesPerCell = (columnChunk = columnReader.readPrimitive(field)).getBlock().getSizeInBytes() / (long)this.batchSize)) {
            this.maxCombinedBytesPerRow = this.maxCombinedBytesPerRow - this.maxBytesPerCell[fieldId] + bytesPerCell;
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.options.getMaxReadBlockSize().toBytes() / this.maxCombinedBytesPerRow)));
            this.maxBytesPerCell[fieldId] = bytesPerCell;
        }
        return columnChunk;
    }

    private PageReader createPageReader(List<Slice> slices, ColumnChunkMetaData metadata, ColumnDescriptor columnDescriptor, OffsetIndex offsetIndex) throws IOException {
        ColumnChunkDescriptor descriptor = new ColumnChunkDescriptor(columnDescriptor, metadata);
        ParquetColumnChunk columnChunk = new ParquetColumnChunk(this.fileCreatedBy, descriptor, slices, offsetIndex);
        return columnChunk.readAllPages();
    }

    private List<Slice> allocateBlock(int fieldId) {
        Collection readers = this.chunkReaders.get((Object)new ChunkKey(fieldId, this.currentRowGroup));
        ArrayList slices = Lists.newArrayListWithExpectedSize((int)readers.size());
        for (ChunkReader reader : readers) {
            Slice slice = reader.read();
            this.currentRowGroupMemoryContext.newLocalMemoryContext(ParquetReader.class.getSimpleName()).setBytes((long)slice.length());
            slices.add(slice);
        }
        return slices;
    }

    private ColumnChunkMetaData getColumnChunkMetaData(BlockMetaData blockMetaData, ColumnDescriptor columnDescriptor) throws IOException {
        for (ColumnChunkMetaData metadata : blockMetaData.getColumns()) {
            if (!metadata.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath()))) continue;
            return metadata;
        }
        throw new ParquetCorruptionException("Metadata is missing for column: %s", columnDescriptor);
    }

    private void initializeColumnReaders() {
        for (PrimitiveColumnIO columnIO : this.columns) {
            RichColumnDescriptor column = new RichColumnDescriptor(columnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
            this.columnReaders[columnIO.getId()] = PrimitiveColumnReader.createReader(column, this.timeZone);
        }
    }

    public Block readBlock(Field field) throws IOException {
        return this.readColumnChunk(field).getBlock();
    }

    private ColumnChunk readColumnChunk(Field field) throws IOException {
        ColumnChunk columnChunk = field.getType() instanceof RowType ? this.readStruct((GroupField)field) : (field.getType() instanceof MapType ? this.readMap((GroupField)field) : (field.getType() instanceof ArrayType ? this.readArray((GroupField)field) : this.readPrimitive((PrimitiveField)field)));
        return columnChunk;
    }

    public ParquetDataSource getDataSource() {
        return this.dataSource;
    }

    public AggregatedMemoryContext getMemoryContext() {
        return this.memoryContext;
    }

    private static <T> List<T> listWithNulls(int size) {
        return Stream.generate(() -> null).limit(size).collect(Collectors.toCollection(ArrayList::new));
    }

    private RowRanges getRowRanges(FilterPredicate filter, int blockIndex) {
        Optional<ColumnIndexStore> columnIndexStore;
        Objects.requireNonNull(filter, "filter is null");
        RowRanges rowRanges = this.blockRowRanges.get(blockIndex);
        if (rowRanges == null && (columnIndexStore = this.columnIndexStore.get(blockIndex)).isPresent()) {
            rowRanges = ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)filter), (ColumnIndexStore)columnIndexStore.get(), this.paths.keySet(), (long)this.blocks.get(blockIndex).getRowCount());
            this.blockRowRanges.set(blockIndex, rowRanges);
        }
        return rowRanges;
    }
}

