/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.writer.repdef.DefLevelIterable;
import io.trino.parquet.writer.repdef.RepLevelIterable;
import io.trino.spi.block.Block;
import java.util.List;
import java.util.Objects;

public class ColumnChunk {
    private final Block block;
    private final List<DefLevelIterable> defLevelIterables;
    private final List<RepLevelIterable> repLevelIterables;

    ColumnChunk(Block block) {
        this(block, (List<DefLevelIterable>)ImmutableList.of(), (List<RepLevelIterable>)ImmutableList.of());
    }

    ColumnChunk(Block block, List<DefLevelIterable> defLevelIterables, List<RepLevelIterable> repLevelIterables) {
        this.block = Objects.requireNonNull(block, "block is null");
        this.defLevelIterables = ImmutableList.copyOf(defLevelIterables);
        this.repLevelIterables = ImmutableList.copyOf(repLevelIterables);
    }

    List<DefLevelIterable> getDefLevelIterables() {
        return this.defLevelIterables;
    }

    List<RepLevelIterable> getRepLevelIterables() {
        return this.repLevelIterables;
    }

    public Block getBlock() {
        return this.block;
    }
}

