/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.BaseWritableBufferImpl;
import org.apache.datasketches.memory.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.DirectNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.DirectWritableBufferImpl;
import org.apache.datasketches.memory.DirectWritableMemoryImpl;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.NonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.StepBoolean;

final class DirectNonNativeWritableMemoryImpl
extends NonNativeWritableMemoryImpl {
    private static final int id = 40;
    private final long nativeBaseOffset;
    private final StepBoolean valid;
    private MemoryRequestServer memReqSvr = null;
    private final byte typeId;

    DirectNonNativeWritableMemoryImpl(long nativeBaseOffset, long regionOffset, long capacityBytes, int typeId, StepBoolean valid, MemoryRequestServer memReqSvr) {
        super(null, nativeBaseOffset, regionOffset, capacityBytes);
        this.nativeBaseOffset = nativeBaseOffset;
        this.valid = valid;
        this.memReqSvr = memReqSvr == null ? defaultMemReqSvr : memReqSvr;
        this.typeId = (byte)(0x28 | typeId & 7);
    }

    @Override
    BaseWritableMemoryImpl toWritableRegion(long offsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | 2 | (readOnly ? 1 : 0);
        return DirectNonNativeWritableMemoryImpl.isNativeByteOrder(byteOrder) ? new DirectWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr) : new DirectNonNativeWritableMemoryImpl(this.nativeBaseOffset, this.getRegionOffset(offsetBytes), capacityBytes, type, this.valid, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toWritableBuffer(boolean readOnly, ByteOrder byteOrder) {
        int type = this.typeId | (readOnly ? (byte)1 : 0);
        return DirectNonNativeWritableMemoryImpl.isNativeByteOrder(byteOrder) ? new DirectWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr, this) : new DirectNonNativeWritableBufferImpl(this.nativeBaseOffset, this.getRegionOffset(), this.getCapacity(), type, this.valid, this.memReqSvr, this);
    }

    @Override
    public MemoryRequestServer getMemoryRequestServer() {
        this.assertValid();
        return this.memReqSvr;
    }

    @Override
    long getNativeBaseOffset() {
        return this.nativeBaseOffset;
    }

    @Override
    int getTypeId() {
        return this.typeId & 0xFF;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }
}

