/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.ResultContinuation;
import java.util.ArrayList;

public class ResultSegment<T> {
    private final ResultContinuation continuationToken;
    private final int length;
    private final Integer pageSize;
    private final ArrayList<T> results;

    public ResultSegment(ArrayList<T> results, Integer pageSize, ResultContinuation token) {
        this.results = results;
        this.length = results.size();
        this.pageSize = pageSize;
        this.continuationToken = token;
    }

    public ResultContinuation getContinuationToken() {
        return this.continuationToken;
    }

    public boolean getHasMoreResults() {
        return this.continuationToken != null;
    }

    public boolean getIsPageComplete() {
        return new Integer(this.length).equals(this.pageSize);
    }

    public int getLength() {
        return this.length;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public int getRemainingPageResults() {
        return this.pageSize - this.length;
    }

    public ArrayList<T> getResults() {
        return this.results;
    }
}

