/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.AccessCondition;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.Constants;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RequestOptions;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageCredentials;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageCredentialsSharedAccessSignature;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageLocation;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageUri;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobAttributes;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobInputStream;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobProperties;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobRequest;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobRequestOptions;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobResponse;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.BlobType;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlobClient;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlobContainer;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlobDirectory;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlockBlob;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CloudPageBlob;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.CopyState;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.LeaseAction;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.LeaseStatus;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.blob.ListBlobItem;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Base64;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.ExecutionEngine;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Logger;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.NetworkInputStream;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.PathUtility;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.RequestLocationMode;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.SharedAccessSignatureHelper;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.StorageCredentialsHelper;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.StorageRequest;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.StreamMd5AndLength;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.UriQueryBuilder;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;

public abstract class CloudBlob
implements ListBlobItem {
    HashMap<String, String> metadata;
    BlobProperties properties;
    private StorageUri storageUri;
    String snapshotID;
    private CloudBlobContainer container;
    protected CloudBlobDirectory parent;
    private String name;
    protected int streamWriteSizeInBytes = Constants.DEFAULT_STREAM_WRITE_IN_BYTES;
    protected int streamMinimumReadSizeInBytes = Constants.DEFAULT_MINIMUM_READ_SIZE_IN_BYTES;
    protected CloudBlobClient blobServiceClient;

    protected CloudBlob(BlobType type) {
        this.metadata = new HashMap();
        this.properties = new BlobProperties(type);
    }

    protected CloudBlob(BlobType type, StorageUri uri, CloudBlobClient client) throws StorageException {
        this(type);
        Utility.assertNotNull("blobAbsoluteUri", uri);
        this.blobServiceClient = client;
        this.storageUri = uri;
        this.parseURIQueryStringAndVerify(this.storageUri, client, client == null ? Utility.determinePathStyleFromUri(this.storageUri.getPrimaryUri()) : client.isUsePathStyleUris());
    }

    protected CloudBlob(BlobType type, StorageUri uri, CloudBlobClient client, CloudBlobContainer container) throws StorageException {
        this(type, uri, client);
        this.container = container;
    }

    protected CloudBlob(BlobType type, StorageUri uri, String snapshotID, CloudBlobClient client) throws StorageException {
        this(type, uri, client);
        if (snapshotID != null) {
            if (this.snapshotID != null) {
                throw new IllegalArgumentException("Snapshot query parameter is already defined in the blob URI. Either pass in a snapshotTime parameter or use a full URL with a snapshot query parameter.");
            }
            this.snapshotID = snapshotID;
        }
    }

    protected CloudBlob(CloudBlob otherBlob) {
        this.metadata = new HashMap();
        this.properties = new BlobProperties(otherBlob.properties);
        if (otherBlob.metadata != null) {
            this.metadata = new HashMap();
            for (String key : otherBlob.metadata.keySet()) {
                this.metadata.put(key, otherBlob.metadata.get(key));
            }
        }
        this.snapshotID = otherBlob.snapshotID;
        this.storageUri = otherBlob.storageUri;
        this.container = otherBlob.container;
        this.parent = otherBlob.parent;
        this.blobServiceClient = otherBlob.blobServiceClient;
        this.name = otherBlob.name;
        this.setStreamMinimumReadSizeInBytes(otherBlob.getStreamMinimumReadSizeInBytes());
        this.setStreamWriteSizeInBytes(otherBlob.getStreamWriteSizeInBytes());
    }

    @.DoesServiceRequest
    public final void abortCopy(String copyId) throws StorageException {
        this.abortCopy(copyId, null, null, null);
    }

    @.DoesServiceRequest
    public final void abortCopy(String copyId, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.abortCopyImpl(copyId, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> abortCopyImpl(final String copyId, final AccessCondition accessCondition, final BlobRequestOptions options) {
        Utility.assertNotNull("copyId", copyId);
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.abortCopy(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, copyId);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob parentObject, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        return putRequest;
    }

    @.DoesServiceRequest
    public final String acquireLease(Integer leaseTimeInSeconds, String proposedLeaseId) throws StorageException {
        return this.acquireLease(leaseTimeInSeconds, proposedLeaseId, null, null, null);
    }

    @.DoesServiceRequest
    public final String acquireLease(Integer leaseTimeInSeconds, String proposedLeaseId, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.acquireLeaseImpl(leaseTimeInSeconds, proposedLeaseId, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, String> acquireLeaseImpl(final Integer leaseTimeInSeconds, final String proposedLeaseId, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, String> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, String>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.ACQUIRE, leaseTimeInSeconds, proposedLeaseId, null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public String preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.properties.setLeaseStatus(LeaseStatus.LOCKED);
                return BlobResponse.getLeaseID(this.getConnection());
            }
        };
        return putRequest;
    }

    protected final void assertCorrectBlobType() throws StorageException {
        if (this instanceof CloudBlockBlob && this.properties.getBlobType() != BlobType.BLOCK_BLOB) {
            throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s.", new Object[]{BlobType.BLOCK_BLOB, this.properties.getBlobType()}), 306, null, null);
        }
        if (this instanceof CloudPageBlob && this.properties.getBlobType() != BlobType.PAGE_BLOB) {
            throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s.", new Object[]{BlobType.PAGE_BLOB, this.properties.getBlobType()}), 306, null, null);
        }
    }

    protected void assertNoWriteOperationForSnapshot() {
        if (this.isSnapshot()) {
            throw new IllegalArgumentException("Cannot perform this operation on a blob representing a snapshot.");
        }
    }

    @.DoesServiceRequest
    public final long breakLease(Integer breakPeriodInSeconds) throws StorageException {
        return this.breakLease(breakPeriodInSeconds, null, null, null);
    }

    @.DoesServiceRequest
    public final long breakLease(Integer breakPeriodInSeconds, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (breakPeriodInSeconds != null) {
            Utility.assertGreaterThanOrEqual("breakPeriodInSeconds", breakPeriodInSeconds.intValue(), 0L);
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.breakLeaseImpl(breakPeriodInSeconds, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Long> breakLeaseImpl(final Integer breakPeriodInSeconds, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Long> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Long>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.BREAK, null, null, breakPeriodInSeconds);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Long preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return -1L;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                String leaseTime = BlobResponse.getLeaseTime(this.getConnection());
                blob.properties.setLeaseStatus(LeaseStatus.UNLOCKED);
                return Utility.isNullOrEmpty(leaseTime) ? -1L : Long.parseLong(leaseTime);
            }
        };
        return putRequest;
    }

    @.DoesServiceRequest
    public final String changeLease(String proposedLeaseId, AccessCondition accessCondition) throws StorageException {
        return this.changeLease(proposedLeaseId, accessCondition, null, null);
    }

    @.DoesServiceRequest
    public final String changeLease(String proposedLeaseId, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.changeLeaseImpl(proposedLeaseId, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, String> changeLeaseImpl(final String proposedLeaseId, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, String> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, String>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.CHANGE, null, proposedLeaseId, null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public String preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return BlobResponse.getLeaseID(this.getConnection());
            }
        };
        return putRequest;
    }

    @.DoesServiceRequest
    public final String startCopyFromBlob(CloudBlob sourceBlob) throws StorageException, URISyntaxException {
        return this.startCopyFromBlob(sourceBlob, null, null, null, null);
    }

    @.DoesServiceRequest
    public final String startCopyFromBlob(CloudBlob sourceBlob, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
        Utility.assertNotNull("sourceBlob", sourceBlob);
        return this.startCopyFromBlob(sourceBlob.getServiceClient().getCredentials().transformUri(sourceBlob.getQualifiedUri()), sourceAccessCondition, destinationAccessCondition, options, opContext);
    }

    @.DoesServiceRequest
    public final String startCopyFromBlob(URI source) throws StorageException {
        return this.startCopyFromBlob(source, null, null, null, null);
    }

    @.DoesServiceRequest
    public final String startCopyFromBlob(URI source, AccessCondition sourceAccessCondition, AccessCondition destinationAccessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.startCopyFromBlobImpl(source, sourceAccessCondition, destinationAccessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, String> startCopyFromBlobImpl(final URI source, final AccessCondition sourceAccessCondition, final AccessCondition destinationAccessCondition, final BlobRequestOptions options) {
        if (sourceAccessCondition != null && !Utility.isNullOrEmpty(sourceAccessCondition.getLeaseID())) {
            throw new IllegalArgumentException("A lease condition cannot be specified on the source of a copy.");
        }
        StorageRequest<CloudBlobClient, CloudBlob, String> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, String>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.copyFrom(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, sourceAccessCondition, destinationAccessCondition, source.toString(), blob.snapshotID);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                BlobRequest.addMetadata(connection, blob.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public String preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.properties.setCopyState(BlobResponse.getCopyState(this.getConnection()));
                return blob.properties.getCopyState().getCopyId();
            }
        };
        return putRequest;
    }

    @.DoesServiceRequest
    public final CloudBlob createSnapshot() throws StorageException {
        return this.createSnapshot(null, null, null, null);
    }

    @.DoesServiceRequest
    public final CloudBlob createSnapshot(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.createSnapshot(null, accessCondition, options, opContext);
    }

    @.DoesServiceRequest
    public final CloudBlob createSnapshot(HashMap<String, String> metadata, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.createSnapshotImpl(metadata, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, CloudBlob> createSnapshotImpl(final HashMap<String, String> metadata, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, CloudBlob> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, CloudBlob>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.snapshot(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                if (metadata != null) {
                    BlobRequest.addMetadata(connection, metadata, context);
                }
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public CloudBlob preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob snapshot = null;
                String snapshotTime = BlobResponse.getSnapshotTime(this.getConnection());
                if (blob instanceof CloudBlockBlob) {
                    snapshot = new CloudBlockBlob(blob.getStorageUri(), snapshotTime, client);
                } else if (blob instanceof CloudPageBlob) {
                    snapshot = new CloudPageBlob(blob.getStorageUri(), snapshotTime, client);
                }
                snapshot.setProperties(blob.properties);
                snapshot.setMetadata(metadata != null ? metadata : blob.metadata);
                snapshot.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return snapshot;
            }
        };
        return putRequest;
    }

    @.DoesServiceRequest
    public final void delete() throws StorageException {
        this.delete(DeleteSnapshotsOption.NONE, null, null, null);
    }

    @.DoesServiceRequest
    public final void delete(DeleteSnapshotsOption deleteSnapshotsOption, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("deleteSnapshotsOption", (Object)deleteSnapshotsOption);
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.deleteImpl(deleteSnapshotsOption, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    @.DoesServiceRequest
    public final boolean deleteIfExists() throws StorageException {
        return this.deleteIfExists(DeleteSnapshotsOption.NONE, null, null, null);
    }

    @.DoesServiceRequest
    public final boolean deleteIfExists(DeleteSnapshotsOption deleteSnapshotsOption, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        boolean exists = this.exists(true, accessCondition, options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient), opContext);
        if (exists) {
            try {
                this.delete(deleteSnapshotsOption, accessCondition, options, opContext);
                return true;
            }
            catch (StorageException e) {
                if (e.getHttpStatusCode() == 404 && "BlobNotFound".equals(e.getErrorCode())) {
                    return false;
                }
                throw e;
            }
        }
        return false;
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> deleteImpl(final DeleteSnapshotsOption deleteSnapshotsOption, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> deleteRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.deleteBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID, deleteSnapshotsOption);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob parentObject, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        return deleteRequest;
    }

    @.DoesServiceRequest
    public final void download(OutputStream outStream) throws StorageException {
        this.download(outStream, null, null, null);
    }

    @.DoesServiceRequest
    public final void download(OutputStream outStream, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadToStreamImpl(null, null, outStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    @.DoesServiceRequest
    public final void downloadRange(long offset, Long length, OutputStream outStream) throws StorageException {
        this.downloadRange(offset, length, outStream, null, null, null);
    }

    @.DoesServiceRequest
    public final void downloadRange(long offset, Long length, OutputStream outStream, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (offset < 0L || length != null && length <= 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        if (options.getUseTransactionalContentMD5().booleanValue() && length != null && length > 0x400000L) {
            throw new IllegalArgumentException("Cannot specify x-ms-range-get-content-md5 header on ranges larger than 4 MB. Either use a BlobReadStream via openRead, or disable TransactionalMD5 via the BlobRequestOptions.");
        }
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadToStreamImpl(offset, length, outStream, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    @.DoesServiceRequest
    public final void downloadAttributes() throws StorageException {
        this.downloadAttributes(null, null, null);
    }

    @.DoesServiceRequest
    public final void downloadAttributes(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadAttributesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> downloadAttributesImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.getBlobProperties(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                BlobAttributes retrievedAttributes = BlobResponse.getBlobAttributes(this.getConnection(), blob.getStorageUri(), blob.snapshotID);
                if (retrievedAttributes.getProperties().getBlobType() != blob.properties.getBlobType()) {
                    throw new StorageException("IncorrectBlobType", String.format("Incorrect Blob type, please use the correct Blob type to access a blob on the server. Expected %s, actual %s.", new Object[]{blob.properties.getBlobType(), retrievedAttributes.getProperties().getBlobType()}), 306, null, null);
                }
                blob.properties = retrievedAttributes.getProperties();
                blob.metadata = retrievedAttributes.getMetadata();
                return null;
            }
        };
        return getRequest;
    }

    @.DoesServiceRequest
    private final StorageRequest<CloudBlobClient, CloudBlob, Integer> downloadToStreamImpl(final Long blobOffset, final Long length, final OutputStream outStream, final AccessCondition accessCondition, final BlobRequestOptions options, OperationContext opContext) {
        final long startingOffset = blobOffset == null ? 0L : blobOffset;
        final boolean isRangeGet = blobOffset != null;
        StorageRequest<CloudBlobClient, CloudBlob, Integer> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, Integer>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                if (this.getOffset() == null) {
                    this.setOffset(blobOffset);
                }
                if (this.getLength() == null) {
                    this.setLength(length);
                }
                AccessCondition tempCondition = this.getETagLockCondition() != null ? this.getETagLockCondition() : accessCondition;
                return BlobRequest.getBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, tempCondition, blob.snapshotID, this.getOffset(), this.getLength(), options.getUseTransactionalContentMD5() != false && !this.getArePropertiesPopulated());
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Integer preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                return CloudBlob.this.preProcessDownloadResponse(this, options, client, blob, context, isRangeGet);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer postProcessResponse(HttpURLConnection connection, CloudBlob blob, CloudBlobClient client, OperationContext context, Integer storageObject) throws Exception {
                Boolean validateMD5 = options.getDisableContentMD5Validation() == false && !Utility.isNullOrEmpty(this.getContentMD5());
                String contentLength = connection.getHeaderField("Content-Length");
                long expectedLength = Long.parseLong(contentLength);
                Logger.info(context, String.format("Creating a NetworkInputStream and expecting to read %s bytes.", expectedLength));
                NetworkInputStream streamRef = new NetworkInputStream(connection.getInputStream(), expectedLength);
                try {
                    StreamMd5AndLength descriptor = Utility.writeToOutputStream(streamRef, outStream, -1L, false, validateMD5, context, options, this);
                    if (validateMD5.booleanValue() && !this.getContentMD5().equals(descriptor.getMd5())) {
                        throw new StorageException("InvalidMd5", String.format("Blob hash mismatch (integrity check failed), Expected value is %s, retrieved %s.", this.getContentMD5(), descriptor.getMd5()), 306, null, null);
                    }
                }
                finally {
                    streamRef.close();
                }
                return null;
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                if (this.getETagLockCondition() == null && !Utility.isNullOrEmpty(this.getLockedETag())) {
                    AccessCondition etagLockCondition = new AccessCondition();
                    etagLockCondition.setIfMatch(this.getLockedETag());
                    if (accessCondition != null) {
                        etagLockCondition.setLeaseID(accessCondition.getLeaseID());
                    }
                    this.setETagLockCondition(etagLockCondition);
                }
                if (this.getCurrentRequestByteCount() > 0L) {
                    this.setOffset(startingOffset + this.getCurrentRequestByteCount());
                    if (length != null) {
                        this.setLength(length - this.getCurrentRequestByteCount());
                    }
                }
            }
        };
        return getRequest;
    }

    @.DoesServiceRequest
    protected final int downloadRangeInternal(long blobOffset, Long length, byte[] buffer, int bufferOffset, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (bufferOffset < 0 || blobOffset < 0L || length != null && length <= 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if ((options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient)).getUseTransactionalContentMD5().booleanValue() && length != null && length > 0x400000L) {
            throw new IllegalArgumentException("Cannot specify x-ms-range-get-content-md5 header on ranges larger than 4 MB. Either use a BlobReadStream via openRead, or disable TransactionalMD5 via the BlobRequestOptions.");
        }
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadToByteArrayImpl(blobOffset, length, buffer, bufferOffset, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    @.DoesServiceRequest
    public final int downloadRangeToByteArray(long offset, Long length, byte[] buffer, int bufferOffet) throws StorageException {
        return this.downloadRangeToByteArray(offset, length, buffer, bufferOffet, null, null, null);
    }

    @.DoesServiceRequest
    public final int downloadRangeToByteArray(long offset, Long length, byte[] buffer, int bufferOffset, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("buffer", buffer);
        if (length != null && length + (long)bufferOffset > (long)buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        return this.downloadRangeInternal(offset, length, buffer, bufferOffset, accessCondition, options, opContext);
    }

    @.DoesServiceRequest
    public final int downloadToByteArray(byte[] buffer, int bufferOffet) throws StorageException {
        return this.downloadToByteArray(buffer, bufferOffet, null, null, null);
    }

    @.DoesServiceRequest
    public final int downloadToByteArray(byte[] buffer, int bufferOffset, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("buffer", buffer);
        if (bufferOffset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (bufferOffset >= buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.downloadToByteArrayImpl(null, null, buffer, bufferOffset, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Integer> downloadToByteArrayImpl(final Long blobOffset, final Long length, final byte[] buffer, final int bufferOffset, final AccessCondition accessCondition, final BlobRequestOptions options, OperationContext opContext) {
        final long startingOffset = blobOffset == null ? 0L : blobOffset;
        final boolean isRangeGet = blobOffset != null;
        StorageRequest<CloudBlobClient, CloudBlob, Integer> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, Integer>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                if (this.getOffset() == null) {
                    this.setOffset(blobOffset);
                }
                if (this.getLength() == null) {
                    this.setLength(length);
                }
                AccessCondition tempCondition = this.getETagLockCondition() != null ? this.getETagLockCondition() : accessCondition;
                return BlobRequest.getBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, tempCondition, blob.snapshotID, this.getOffset(), this.getLength(), options.getUseTransactionalContentMD5() != false && !this.getArePropertiesPopulated());
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Integer preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                return CloudBlob.this.preProcessDownloadResponse(this, options, client, blob, context, isRangeGet);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer postProcessResponse(HttpURLConnection connection, CloudBlob blob, CloudBlobClient client, OperationContext context, Integer storageObject) throws Exception {
                String contentLength = connection.getHeaderField("Content-Length");
                long expectedLength = Long.parseLong(contentLength);
                Logger.info(context, String.format("Creating a NetworkInputStream and expecting to read %s bytes.", expectedLength));
                NetworkInputStream sourceStream = new NetworkInputStream(connection.getInputStream(), expectedLength);
                try {
                    int totalRead = 0;
                    int nextRead = buffer.length - bufferOffset;
                    int count = sourceStream.read(buffer, bufferOffset, nextRead);
                    while (count > 0) {
                        if (Utility.validateMaxExecutionTimeout(options.getOperationExpiryTimeInMs())) {
                            TimeoutException timeoutException = new TimeoutException("The client could not finish the operation within specified maximum execution timeout.");
                            throw Utility.initIOException(timeoutException);
                        }
                        this.setCurrentRequestByteCount(this.getCurrentRequestByteCount() + (long)count);
                        nextRead = buffer.length - (bufferOffset + (totalRead += count));
                        if (nextRead == 0 && sourceStream.read(new byte[1], 0, 1) != -1) {
                            throw new StorageException("OutOfRangeInput", "An incorrect number of bytes was read from the connection. The connection may have been closed.", 306, null, null);
                        }
                        count = sourceStream.read(buffer, bufferOffset + totalRead, nextRead);
                    }
                    if ((long)totalRead != expectedLength) {
                        throw new StorageException("OutOfRangeInput", "An incorrect number of bytes was read from the connection. The connection may have been closed.", 306, null, null);
                    }
                }
                finally {
                    sourceStream.close();
                }
                Boolean validateMD5 = options.getDisableContentMD5Validation() == false && !Utility.isNullOrEmpty(this.getContentMD5());
                if (validateMD5.booleanValue()) {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        digest.update(buffer, bufferOffset, (int)this.getCurrentRequestByteCount());
                        String calculatedMD5 = Base64.encode(digest.digest());
                        if (!this.getContentMD5().equals(calculatedMD5)) {
                            throw new StorageException("InvalidMd5", String.format("Blob hash mismatch (integrity check failed), Expected value is %s, retrieved %s.", this.getContentMD5(), calculatedMD5), 306, null, null);
                        }
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw Utility.generateNewUnexpectedStorageException(e);
                    }
                }
                return (int)this.getCurrentRequestByteCount();
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                if (this.getETagLockCondition() == null && !Utility.isNullOrEmpty(this.getLockedETag())) {
                    AccessCondition etagLockCondition = new AccessCondition();
                    etagLockCondition.setIfMatch(this.getLockedETag());
                    if (accessCondition != null) {
                        etagLockCondition.setLeaseID(accessCondition.getLeaseID());
                    }
                    this.setETagLockCondition(etagLockCondition);
                }
                if (this.getCurrentRequestByteCount() > 0L) {
                    this.setOffset(startingOffset + this.getCurrentRequestByteCount());
                    if (length != null) {
                        this.setLength(length - this.getCurrentRequestByteCount());
                    }
                }
            }
        };
        return getRequest;
    }

    public void uploadFromByteArray(byte[] buffer, int offset, int length) throws StorageException, IOException {
        this.uploadFromByteArray(buffer, offset, length, null, null, null);
    }

    public void uploadFromByteArray(byte[] buffer, int offset, int length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer, offset, length);
        this.upload(inputStream, length, accessCondition, options, opContext);
        inputStream.close();
    }

    public void uploadFromFile(String path) throws StorageException, IOException {
        this.uploadFromFile(path, null, null, null);
    }

    public void uploadFromFile(String path, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        File file = new File(path);
        long fileLength = file.length();
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));
        this.upload(inputStream, fileLength, accessCondition, options, opContext);
        ((InputStream)inputStream).close();
    }

    public void downloadToFile(String path) throws StorageException, IOException {
        this.downloadToFile(path, null, null, null);
    }

    public void downloadToFile(String path, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(path));
        try {
            this.download(outputStream, accessCondition, options, opContext);
            ((OutputStream)outputStream).close();
        }
        catch (StorageException e) {
            this.deleteEmptyFileOnException(outputStream, path);
            throw e;
        }
        catch (IOException e) {
            this.deleteEmptyFileOnException(outputStream, path);
            throw e;
        }
    }

    private void deleteEmptyFileOnException(OutputStream outputStream, String path) {
        try {
            outputStream.close();
            File fileToDelete = new File(path);
            fileToDelete.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @.DoesServiceRequest
    public final boolean exists() throws StorageException {
        return this.exists(null, null, null);
    }

    @.DoesServiceRequest
    public final boolean exists(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        return this.exists(false, accessCondition, options, opContext);
    }

    @.DoesServiceRequest
    private final boolean exists(boolean primaryOnly, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.existsImpl(primaryOnly, accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Boolean> existsImpl(final boolean primaryOnly, final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Boolean> getRequest = new StorageRequest<CloudBlobClient, CloudBlob, Boolean>((RequestOptions)options, this.getStorageUri()){

            @Override
            public void setRequestLocationMode() {
                this.setRequestLocationMode(primaryOnly ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.PRIMARY_OR_SECONDARY);
            }

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.getBlobProperties(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.snapshotID);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, -1L, null);
            }

            @Override
            public Boolean preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() == 200) {
                    BlobAttributes retrievedAttributes = BlobResponse.getBlobAttributes(this.getConnection(), blob.getStorageUri(), blob.snapshotID);
                    blob.properties = retrievedAttributes.getProperties();
                    blob.metadata = retrievedAttributes.getMetadata();
                    return true;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return false;
                }
                this.setNonExceptionedRetryableFailure(true);
                return false;
            }
        };
        return getRequest;
    }

    public String generateSharedAccessSignature(.SharedAccessBlobPolicy policy, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        return this.generateSharedAccessSignature(policy, null, groupPolicyIdentifier);
    }

    public String generateSharedAccessSignature(.SharedAccessBlobPolicy policy, .SharedAccessBlobHeaders headers, String groupPolicyIdentifier) throws InvalidKeyException, StorageException {
        if (!StorageCredentialsHelper.canCredentialsSignRequest(this.blobServiceClient.getCredentials())) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature unless the Account Key credentials are used by the ServiceClient.");
        }
        if (this.isSnapshot()) {
            throw new IllegalArgumentException("Cannot create Shared Access Signature via references to blob snapshots. Please perform the given operation on the root blob instead.");
        }
        String resourceName = this.getCanonicalName(true);
        String signature = SharedAccessSignatureHelper.generateSharedAccessSignatureHashForBlob(policy, headers, groupPolicyIdentifier, resourceName, this.blobServiceClient, null);
        UriQueryBuilder builder = SharedAccessSignatureHelper.generateSharedAccessSignatureForBlob(policy, headers, groupPolicyIdentifier, "b", signature);
        return builder.toString();
    }

    String getCanonicalName(boolean ignoreSnapshotTime) {
        String canonicalName = this.blobServiceClient.isUsePathStyleUris() ? this.getUri().getRawPath() : PathUtility.getCanonicalPathFromCredentials(this.blobServiceClient.getCredentials(), this.getUri().getRawPath());
        if (!ignoreSnapshotTime && this.snapshotID != null) {
            canonicalName = canonicalName.concat("?snapshot=");
            canonicalName = canonicalName.concat(this.snapshotID);
        }
        return canonicalName;
    }

    @Override
    public final CloudBlobContainer getContainer() throws StorageException, URISyntaxException {
        if (this.container == null) {
            StorageUri containerURI = PathUtility.getContainerURI(this.getStorageUri(), this.blobServiceClient.isUsePathStyleUris());
            this.container = new CloudBlobContainer(containerURI, this.blobServiceClient);
        }
        return this.container;
    }

    public final HashMap<String, String> getMetadata() {
        return this.metadata;
    }

    public final String getName() throws URISyntaxException {
        if (Utility.isNullOrEmpty(this.name)) {
            this.name = PathUtility.getBlobNameFromURI(this.getUri(), this.blobServiceClient.isUsePathStyleUris());
        }
        return this.name;
    }

    @Override
    public final CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
        String parentName;
        if (this.parent == null && (parentName = CloudBlob.getParentNameFromURI(this.getStorageUri(), this.blobServiceClient.getDirectoryDelimiter(), this.getContainer())) != null) {
            StorageUri parentURI = PathUtility.appendPathToUri(this.container.getStorageUri(), parentName);
            this.parent = new CloudBlobDirectory(parentURI, parentName, this.blobServiceClient, this.getContainer());
        }
        return this.parent;
    }

    public final BlobProperties getProperties() {
        return this.properties;
    }

    public CopyState getCopyState() {
        return this.properties.getCopyState();
    }

    public final StorageUri getQualifiedStorageUri() throws URISyntaxException, StorageException {
        if (this.isSnapshot()) {
            StorageUri snapshotQualifiedUri = PathUtility.addToQuery(this.getStorageUri(), String.format("snapshot=%s", this.snapshotID));
            return this.blobServiceClient.getCredentials().transformUri(snapshotQualifiedUri);
        }
        return this.blobServiceClient.getCredentials().transformUri(this.getStorageUri());
    }

    public final URI getQualifiedUri() throws URISyntaxException, StorageException {
        if (this.isSnapshot()) {
            return PathUtility.addToQuery(this.getUri(), String.format("snapshot=%s", this.snapshotID));
        }
        return this.blobServiceClient.getCredentials().transformUri(this.getUri());
    }

    public final CloudBlobClient getServiceClient() {
        return this.blobServiceClient;
    }

    public final String getSnapshotID() {
        return this.snapshotID;
    }

    @Override
    public final StorageUri getStorageUri() {
        return this.storageUri;
    }

    public final int getStreamWriteSizeInBytes() {
        return this.streamWriteSizeInBytes;
    }

    public final int getStreamMinimumReadSizeInBytes() {
        return this.streamMinimumReadSizeInBytes;
    }

    protected final StorageUri getTransformedAddress(OperationContext opContext) throws URISyntaxException, StorageException {
        return this.blobServiceClient.getCredentials().transformUri(this.getStorageUri(), opContext);
    }

    @Override
    public final URI getUri() {
        return this.storageUri.getPrimaryUri();
    }

    public final boolean isSnapshot() {
        return this.snapshotID != null;
    }

    @.DoesServiceRequest
    public final BlobInputStream openInputStream() throws StorageException {
        return this.openInputStream(null, null, null);
    }

    @.DoesServiceRequest
    public final BlobInputStream openInputStream(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        this.assertNoWriteOperationForSnapshot();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        return new BlobInputStream(this, accessCondition, options, opContext);
    }

    protected void parseURIQueryStringAndVerify(StorageUri completeUri, CloudBlobClient existingClient, boolean usePathStyleUris) throws StorageException {
        Utility.assertNotNull("resourceUri", completeUri);
        if (!completeUri.isAbsolute()) {
            String errorMessage = String.format("Address %s is a relative address. Only absolute addresses are permitted.", completeUri.toString());
            throw new IllegalArgumentException(errorMessage);
        }
        this.storageUri = PathUtility.stripURIQueryAndFragment(completeUri);
        HashMap<String, String[]> queryParameters = PathUtility.parseQueryString(completeUri.getQuery());
        StorageCredentialsSharedAccessSignature sasCreds = SharedAccessSignatureHelper.parseQuery(queryParameters);
        String[] snapshotIDs = queryParameters.get("snapshot");
        if (snapshotIDs != null && snapshotIDs.length > 0) {
            this.snapshotID = snapshotIDs[0];
        }
        if (sasCreds == null && existingClient != null) {
            return;
        }
        Boolean sameCredentials = existingClient == null ? false : Utility.areCredentialsEqual(sasCreds, existingClient.getCredentials());
        if (existingClient == null || !sameCredentials.booleanValue()) {
            try {
                this.blobServiceClient = new CloudBlobClient(PathUtility.getServiceClientBaseAddress(this.getStorageUri(), usePathStyleUris), (StorageCredentials)sasCreds);
            }
            catch (URISyntaxException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        if (existingClient != null && !sameCredentials.booleanValue()) {
            this.blobServiceClient.setDefaultRequestOptions(new BlobRequestOptions(existingClient.getDefaultRequestOptions()));
            this.blobServiceClient.setDirectoryDelimiter(existingClient.getDirectoryDelimiter());
        }
    }

    @.DoesServiceRequest
    public final void releaseLease(AccessCondition accessCondition) throws StorageException {
        this.releaseLease(accessCondition, null, null);
    }

    @.DoesServiceRequest
    public final void releaseLease(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.releaseLeaseImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> releaseLeaseImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.RELEASE, null, null, null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                blob.properties.setLeaseStatus(LeaseStatus.UNLOCKED);
                return null;
            }
        };
        return putRequest;
    }

    @.DoesServiceRequest
    public final void renewLease(AccessCondition accessCondition) throws StorageException {
        this.renewLease(accessCondition, null, null);
    }

    @.DoesServiceRequest
    public final void renewLease(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNull("accessCondition", accessCondition);
        Utility.assertNotNullOrEmpty("leaseID", accessCondition.getLeaseID());
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.renewLeaseImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> renewLeaseImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.leaseBlob(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, LeaseAction.RENEW, null, null, null);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                CloudBlob.this.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    protected final void setContainer(CloudBlobContainer container) {
        this.container = container;
    }

    public final void setMetadata(HashMap<String, String> metadata) {
        this.metadata = metadata;
    }

    protected final void setProperties(BlobProperties properties) {
        this.properties = properties;
    }

    protected final void setSnapshotID(String snapshotID) {
        this.snapshotID = snapshotID;
    }

    protected void setStorageUri(StorageUri storageUri) {
        this.storageUri = storageUri;
    }

    public abstract void setStreamWriteSizeInBytes(int var1);

    public void setStreamMinimumReadSizeInBytes(int minimumReadSize) {
        if (minimumReadSize < 16384) {
            throw new IllegalArgumentException("MinimumReadSize");
        }
        this.streamMinimumReadSizeInBytes = minimumReadSize;
    }

    protected void updateEtagAndLastModifiedFromResponse(HttpURLConnection request) {
        this.getProperties().setEtag(request.getHeaderField("ETag"));
        if (0L != request.getLastModified()) {
            Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
            lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
            lastModifiedCalendar.setTime(new Date(request.getLastModified()));
            this.getProperties().setLastModified(lastModifiedCalendar.getTime());
        }
    }

    protected void updateLengthFromResponse(HttpURLConnection request) {
        String xContentLengthHeader = request.getHeaderField("x-ms-blob-content-length");
        if (!Utility.isNullOrEmpty(xContentLengthHeader)) {
            this.getProperties().setLength(Long.parseLong(xContentLengthHeader));
        }
    }

    @.DoesServiceRequest
    public abstract void upload(InputStream var1, long var2) throws StorageException, IOException;

    @.DoesServiceRequest
    public abstract void upload(InputStream var1, long var2, AccessCondition var4, BlobRequestOptions var5, OperationContext var6) throws StorageException, IOException;

    @.DoesServiceRequest
    protected final void uploadFullBlob(InputStream sourceStream, long length, AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        sourceStream.mark(0x4000000);
        if (length < 0L || length > 0x4000000L) {
            throw new IllegalArgumentException(String.format("Invalid stream length; stream must be between 0 and %s MB in length.", 64));
        }
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.uploadFullBlobImpl(sourceStream, length, accessCondition, options, opContext), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> uploadFullBlobImpl(final InputStream sourceStream, final long length, final AccessCondition accessCondition, final BlobRequestOptions options, final OperationContext opContext) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                this.setSendStream(sourceStream);
                this.setLength(length);
                return BlobRequest.putBlob(blob.getTransformedAddress(opContext).getUri(this.getCurrentLocation()), options, opContext, accessCondition, blob.properties, blob.properties.getBlobType(), this.getLength());
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                BlobRequest.addMetadata(connection, blob.metadata, opContext);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, length, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 201) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return null;
            }

            @Override
            public void recoveryAction(OperationContext context) throws IOException {
                sourceStream.reset();
                sourceStream.mark(0x4000000);
            }

            @Override
            public void validateStreamWrite(StreamMd5AndLength descriptor) throws StorageException {
                if (this.getLength() != null && this.getLength() != -1L && length != descriptor.getLength()) {
                    throw new StorageException("InvalidInput", "An incorrect stream length was specified, resulting in an authentication failure. Please specify correct length, or -1.", 403, null, null);
                }
            }
        };
        return putRequest;
    }

    @.DoesServiceRequest
    public final void uploadMetadata() throws StorageException {
        this.uploadMetadata(null, null, null);
    }

    @.DoesServiceRequest
    public final void uploadMetadata(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.uploadMetadataImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> uploadMetadataImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.setBlobMetadata(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition);
            }

            @Override
            public void setHeaders(HttpURLConnection connection, CloudBlob blob, OperationContext context) {
                BlobRequest.addMetadata(connection, blob.metadata, context);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    @.DoesServiceRequest
    public final void uploadProperties() throws StorageException {
        this.uploadProperties(null, null, null);
    }

    @.DoesServiceRequest
    public final void uploadProperties(AccessCondition accessCondition, BlobRequestOptions options, OperationContext opContext) throws StorageException {
        this.assertNoWriteOperationForSnapshot();
        if (opContext == null) {
            opContext = new OperationContext();
        }
        opContext.initialize();
        options = BlobRequestOptions.applyDefaults(options, this.properties.getBlobType(), this.blobServiceClient);
        ExecutionEngine.executeWithRetry(this.blobServiceClient, this, this.uploadPropertiesImpl(accessCondition, options), options.getRetryPolicyFactory(), opContext);
    }

    private StorageRequest<CloudBlobClient, CloudBlob, Void> uploadPropertiesImpl(final AccessCondition accessCondition, final BlobRequestOptions options) {
        StorageRequest<CloudBlobClient, CloudBlob, Void> putRequest = new StorageRequest<CloudBlobClient, CloudBlob, Void>((RequestOptions)options, this.getStorageUri()){

            @Override
            public HttpURLConnection buildRequest(CloudBlobClient client, CloudBlob blob, OperationContext context) throws Exception {
                return BlobRequest.setBlobProperties(blob.getTransformedAddress(context).getUri(this.getCurrentLocation()), options, context, accessCondition, blob.properties);
            }

            @Override
            public void signRequest(HttpURLConnection connection, CloudBlobClient client, OperationContext context) throws Exception {
                StorageRequest.signBlobQueueAndFileRequest(connection, client, 0L, null);
            }

            @Override
            public Void preProcessResponse(CloudBlob blob, CloudBlobClient client, OperationContext context) throws Exception {
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                blob.updateEtagAndLastModifiedFromResponse(this.getConnection());
                return null;
            }
        };
        return putRequest;
    }

    private Integer preProcessDownloadResponse(StorageRequest<CloudBlobClient, CloudBlob, Integer> request, BlobRequestOptions options, CloudBlobClient client, CloudBlob blob, OperationContext context, boolean isRangeGet) throws StorageException, URISyntaxException, ParseException {
        if (request.getResult().getStatusCode() != 206 && request.getResult().getStatusCode() != 200) {
            request.setNonExceptionedRetryableFailure(true);
            return null;
        }
        if (!request.getArePropertiesPopulated()) {
            String originalContentMD5 = null;
            BlobAttributes retrievedAttributes = BlobResponse.getBlobAttributes(request.getConnection(), blob.getStorageUri(), blob.snapshotID);
            originalContentMD5 = isRangeGet ? blob.properties.getContentMD5() : retrievedAttributes.getProperties().getContentMD5();
            if (!options.getDisableContentMD5Validation().booleanValue() && options.getUseTransactionalContentMD5().booleanValue() && Utility.isNullOrEmpty(retrievedAttributes.getProperties().getContentMD5())) {
                throw new StorageException("MissingContentMD5Header", "ContentMD5 header is missing in the response.", 306, null, null);
            }
            blob.properties = retrievedAttributes.getProperties();
            blob.metadata = retrievedAttributes.getMetadata();
            request.setContentMD5(retrievedAttributes.getProperties().getContentMD5());
            blob.properties.setContentMD5(originalContentMD5);
            request.setLockedETag(blob.properties.getEtag());
            request.setArePropertiesPopulated(true);
        }
        request.setRequestLocationMode(request.getResult().getTargetLocation() == StorageLocation.PRIMARY ? RequestLocationMode.PRIMARY_ONLY : RequestLocationMode.SECONDARY_ONLY);
        return null;
    }

    protected static String getParentNameFromURI(StorageUri resourceAddress, String delimiter, CloudBlobContainer container) throws URISyntaxException {
        String parentName;
        Utility.assertNotNull("resourceAddress", resourceAddress);
        Utility.assertNotNull("container", container);
        Utility.assertNotNullOrEmpty("delimiter", delimiter);
        String containerName = container.getName() + "/";
        String relativeURIString = Utility.safeRelativize(container.getStorageUri().getPrimaryUri(), resourceAddress.getPrimaryUri());
        if (relativeURIString.endsWith(delimiter)) {
            relativeURIString = relativeURIString.substring(0, relativeURIString.length() - delimiter.length());
        }
        if (Utility.isNullOrEmpty(relativeURIString)) {
            parentName = null;
        } else {
            int lastDelimiterDex = relativeURIString.lastIndexOf(delimiter);
            if (lastDelimiterDex < 0) {
                parentName = "";
            } else {
                parentName = relativeURIString.substring(0, lastDelimiterDex + delimiter.length());
                if (parentName != null && parentName.equals(containerName)) {
                    parentName = "";
                }
            }
        }
        return parentName;
    }
}

