/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.ListResponse;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file.CloudFile;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file.CloudFileDirectory;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file.FileDirectoryProperties;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file.FileProperties;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.file.ListFileItem;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class FileListHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final ListResponse<ListFileItem> response = new ListResponse();
    private final CloudFileDirectory directory;
    private FileDirectoryProperties directoryProperties;
    private FileProperties fileProperties;
    private String name;

    private FileListHandler(CloudFileDirectory directory) {
        this.directory = directory;
    }

    public static ListResponse<ListFileItem> getFileAndDirectoryList(InputStream stream, CloudFileDirectory directory) throws ParserConfigurationException, SAXException, IOException {
        SAXParser saxParser = Utility.getSAXParser();
        FileListHandler handler = new FileListHandler(directory);
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.response;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
        if ("File".equals(localName)) {
            this.name = "";
            this.fileProperties = new FileProperties();
        }
        if ("Directory".equals(localName)) {
            this.name = "";
            this.directoryProperties = new FileDirectoryProperties();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("File".equals(currentNode)) {
            CloudFile retFile = null;
            try {
                retFile = this.directory.getFileReference(this.name);
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
            catch (StorageException e) {
                throw new SAXException(e);
            }
            retFile.setProperties(this.fileProperties);
            this.response.getResults().add(retFile);
        } else if ("Directory".equals(currentNode)) {
            CloudFileDirectory retDirectory = null;
            try {
                retDirectory = this.directory.getDirectoryReference(this.name);
            }
            catch (URISyntaxException e) {
                throw new SAXException(e);
            }
            catch (StorageException e) {
                throw new SAXException(e);
            }
            retDirectory.setProperties(this.directoryProperties);
            this.response.getResults().add(retDirectory);
        } else if ("EnumerationResults".equals(parentNode)) {
            if ("Prefix".equals(currentNode)) {
                this.response.setPrefix(value);
            } else if ("Marker".equals(currentNode)) {
                this.response.setMarker(value);
            } else if ("NextMarker".equals(currentNode)) {
                this.response.setNextMarker(value);
            } else if ("MaxResults".equals(currentNode)) {
                this.response.setMaxResults(Integer.parseInt(value));
            }
        } else if ("File".equals(parentNode) || "Directory".equals(parentNode)) {
            if ("Name".equals(currentNode)) {
                this.name = value;
            }
        } else if ("Properties".equals(parentNode)) {
            try {
                this.setProperties(currentNode, value);
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }

    private void setProperties(String currentNode, String value) throws ParseException {
        if ("Last-Modified".equals(currentNode)) {
            this.directoryProperties.setLastModified(Utility.parseRFC1123DateFromStringInGMT(value));
        } else if ("Etag".equals(currentNode)) {
            this.directoryProperties.setEtag(Utility.formatETag(value));
        } else if ("Content-Length".equals(currentNode)) {
            this.fileProperties.setLength(Long.parseLong(value));
        }
    }
}

