/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RequestOptions;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.CloudTableClient;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.EdmType;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table.TablePayloadFormat;

public class TableRequestOptions
extends RequestOptions {
    private PropertyResolver propertyResolver;
    private TablePayloadFormat payloadFormat;
    private boolean dateBackwardCompatibility = false;

    public TableRequestOptions() {
    }

    public TableRequestOptions(TableRequestOptions other) {
        super(other);
        if (other != null) {
            this.setTablePayloadFormat(other.getTablePayloadFormat());
            this.setPropertyResolver(other.getPropertyResolver());
            this.dateBackwardCompatibility = other.dateBackwardCompatibility;
        }
    }

    protected static final TableRequestOptions applyDefaults(TableRequestOptions options, CloudTableClient client) {
        TableRequestOptions modifiedOptions = new TableRequestOptions(options);
        TableRequestOptions.populateRequestOptions(modifiedOptions, client.getDefaultRequestOptions());
        return TableRequestOptions.applyDefaultsInternal(modifiedOptions, client);
    }

    private static final TableRequestOptions applyDefaultsInternal(TableRequestOptions modifiedOptions, CloudTableClient client) {
        Utility.assertNotNull("modifiedOptions", modifiedOptions);
        RequestOptions.applyBaseDefaultsInternal(modifiedOptions);
        if (modifiedOptions.getTablePayloadFormat() == null) {
            modifiedOptions.setTablePayloadFormat(TablePayloadFormat.Json);
        }
        return modifiedOptions;
    }

    private static final RequestOptions populateRequestOptions(TableRequestOptions modifiedOptions, TableRequestOptions clientOptions) {
        RequestOptions.populateRequestOptions(modifiedOptions, clientOptions, false);
        if (modifiedOptions.getTablePayloadFormat() == null) {
            modifiedOptions.setTablePayloadFormat(clientOptions.getTablePayloadFormat());
        }
        if (modifiedOptions.getPropertyResolver() == null) {
            modifiedOptions.setPropertyResolver(clientOptions.getPropertyResolver());
        }
        return modifiedOptions;
    }

    public TablePayloadFormat getTablePayloadFormat() {
        return this.payloadFormat;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public boolean getDateBackwardCompatibility() {
        return this.dateBackwardCompatibility;
    }

    public void setTablePayloadFormat(TablePayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public void setDateBackwardCompatibility(boolean dateBackwardCompatibility) {
        this.dateBackwardCompatibility = dateBackwardCompatibility;
    }

    public static interface PropertyResolver {
        public EdmType propertyResolver(String var1, String var2, String var3, String var4);
    }
}

