/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.deser;

import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonParser;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonProcessingException;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.core.JsonToken;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.BeanProperty;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.DeserializationContext;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JavaType;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonDeserializer;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.JsonMappingException;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.PropertyMetadata;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.PropertyName;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.deser.impl.FailingDeserializer;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.deser.impl.NullProvider;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.introspect.AnnotatedMember;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.util.Annotations;
import io.prestosql.hadoop.$internal.htrace.shaded.fasterxml.jackson.databind.util.ViewMatcher;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;

public abstract class SettableBeanProperty
implements BeanProperty,
Serializable {
    protected static final JsonDeserializer<Object> MISSING_VALUE_DESERIALIZER = new FailingDeserializer("No _valueDeserializer assigned");
    protected final PropertyName _propName;
    protected final JavaType _type;
    protected final PropertyName _wrapperName;
    protected final transient Annotations _contextAnnotations;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final NullProvider _nullProvider;
    protected final PropertyMetadata _metadata;
    protected String _managedReferenceName;
    protected ObjectIdInfo _objectIdInfo;
    protected ViewMatcher _viewMatcher;
    protected int _propertyIndex = -1;

    protected SettableBeanProperty(BeanPropertyDefinition propDef, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations) {
        this(propDef.getFullName(), type, propDef.getWrapperName(), typeDeser, contextAnnotations, propDef.getMetadata());
    }

    @Deprecated
    protected SettableBeanProperty(String propName, JavaType type, PropertyName wrapper, TypeDeserializer typeDeser, Annotations contextAnnotations) {
        this(new PropertyName(propName), type, wrapper, typeDeser, contextAnnotations, PropertyMetadata.STD_OPTIONAL);
    }

    @Deprecated
    protected SettableBeanProperty(String propName, JavaType type, PropertyName wrapper, TypeDeserializer typeDeser, Annotations contextAnnotations, boolean isRequired) {
        this(new PropertyName(propName), type, wrapper, typeDeser, contextAnnotations, PropertyMetadata.construct(isRequired, null, null));
    }

    protected SettableBeanProperty(PropertyName propName, JavaType type, PropertyName wrapper, TypeDeserializer typeDeser, Annotations contextAnnotations, PropertyMetadata metadata) {
        this._propName = propName == null ? PropertyName.NO_NAME : propName.internSimpleName();
        this._type = type;
        this._wrapperName = wrapper;
        this._metadata = metadata;
        this._contextAnnotations = contextAnnotations;
        this._viewMatcher = null;
        this._nullProvider = null;
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(this);
        }
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = MISSING_VALUE_DESERIALIZER;
    }

    protected SettableBeanProperty(PropertyName propName, JavaType type, PropertyMetadata metadata, JsonDeserializer<Object> valueDeser) {
        this._propName = propName == null ? PropertyName.NO_NAME : propName.internSimpleName();
        this._type = type;
        this._wrapperName = null;
        this._metadata = metadata;
        this._contextAnnotations = null;
        this._viewMatcher = null;
        this._nullProvider = null;
        this._valueTypeDeserializer = null;
        this._valueDeserializer = valueDeser;
    }

    protected SettableBeanProperty(SettableBeanProperty src) {
        this._propName = src._propName;
        this._type = src._type;
        this._wrapperName = src._wrapperName;
        this._metadata = src._metadata;
        this._contextAnnotations = src._contextAnnotations;
        this._valueDeserializer = src._valueDeserializer;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
        this._nullProvider = src._nullProvider;
        this._managedReferenceName = src._managedReferenceName;
        this._propertyIndex = src._propertyIndex;
        this._viewMatcher = src._viewMatcher;
    }

    protected SettableBeanProperty(SettableBeanProperty src, JsonDeserializer<?> deser) {
        this._propName = src._propName;
        this._type = src._type;
        this._wrapperName = src._wrapperName;
        this._metadata = src._metadata;
        this._contextAnnotations = src._contextAnnotations;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
        this._managedReferenceName = src._managedReferenceName;
        this._propertyIndex = src._propertyIndex;
        if (deser == null) {
            this._nullProvider = null;
            this._valueDeserializer = MISSING_VALUE_DESERIALIZER;
        } else {
            Object nvl = deser.getNullValue();
            this._nullProvider = nvl == null ? null : new NullProvider(this._type, nvl);
            this._valueDeserializer = deser;
        }
        this._viewMatcher = src._viewMatcher;
    }

    @Deprecated
    protected SettableBeanProperty(SettableBeanProperty src, String newName) {
        this(src, new PropertyName(newName));
    }

    protected SettableBeanProperty(SettableBeanProperty src, PropertyName newName) {
        this._propName = newName;
        this._type = src._type;
        this._wrapperName = src._wrapperName;
        this._metadata = src._metadata;
        this._contextAnnotations = src._contextAnnotations;
        this._valueDeserializer = src._valueDeserializer;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
        this._nullProvider = src._nullProvider;
        this._managedReferenceName = src._managedReferenceName;
        this._propertyIndex = src._propertyIndex;
        this._viewMatcher = src._viewMatcher;
    }

    public abstract SettableBeanProperty withValueDeserializer(JsonDeserializer<?> var1);

    public abstract SettableBeanProperty withName(PropertyName var1);

    public SettableBeanProperty withSimpleName(String simpleName) {
        PropertyName n = this._propName == null ? new PropertyName(simpleName) : this._propName.withSimpleName(simpleName);
        return n == this._propName ? this : this.withName(n);
    }

    @Deprecated
    public SettableBeanProperty withName(String simpleName) {
        return this.withName(new PropertyName(simpleName));
    }

    public void setManagedReferenceName(String n) {
        this._managedReferenceName = n;
    }

    public void setObjectIdInfo(ObjectIdInfo objectIdInfo) {
        this._objectIdInfo = objectIdInfo;
    }

    public void setViews(Class<?>[] views) {
        this._viewMatcher = views == null ? null : ViewMatcher.construct(views);
    }

    public void assignIndex(int index) {
        if (this._propertyIndex != -1) {
            throw new IllegalStateException("Property '" + this.getName() + "' already had index (" + this._propertyIndex + "), trying to assign " + index);
        }
        this._propertyIndex = index;
    }

    @Override
    public final String getName() {
        return this._propName.getSimpleName();
    }

    @Override
    public PropertyName getFullName() {
        return this._propName;
    }

    @Override
    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public JavaType getType() {
        return this._type;
    }

    @Override
    public PropertyName getWrapperName() {
        return this._wrapperName;
    }

    @Override
    public abstract <A extends Annotation> A getAnnotation(Class<A> var1);

    @Override
    public abstract AnnotatedMember getMember();

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return this._contextAnnotations.get(acls);
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor) throws JsonMappingException {
        if (this.isRequired()) {
            objectVisitor.property(this);
        } else {
            objectVisitor.optionalProperty(this);
        }
    }

    protected final Class<?> getDeclaringClass() {
        return this.getMember().getDeclaringClass();
    }

    public String getManagedReferenceName() {
        return this._managedReferenceName;
    }

    public ObjectIdInfo getObjectIdInfo() {
        return this._objectIdInfo;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null && this._valueDeserializer != MISSING_VALUE_DESERIALIZER;
    }

    public boolean hasValueTypeDeserializer() {
        return this._valueTypeDeserializer != null;
    }

    public JsonDeserializer<Object> getValueDeserializer() {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        if (deser == MISSING_VALUE_DESERIALIZER) {
            return null;
        }
        return deser;
    }

    public TypeDeserializer getValueTypeDeserializer() {
        return this._valueTypeDeserializer;
    }

    public boolean visibleInView(Class<?> activeView) {
        return this._viewMatcher == null || this._viewMatcher.isVisibleForView(activeView);
    }

    public boolean hasViews() {
        return this._viewMatcher != null;
    }

    public int getPropertyIndex() {
        return this._propertyIndex;
    }

    public int getCreatorIndex() {
        return -1;
    }

    public Object getInjectableValueId() {
        return null;
    }

    public abstract void deserializeAndSet(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public abstract Object deserializeSetAndReturn(JsonParser var1, DeserializationContext var2, Object var3) throws IOException, JsonProcessingException;

    public abstract void set(Object var1, Object var2) throws IOException;

    public abstract Object setAndReturn(Object var1, Object var2) throws IOException;

    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this._nullProvider == null ? null : this._nullProvider.nullValue(ctxt);
        }
        if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        }
        return this._valueDeserializer.deserialize(jp, ctxt);
    }

    protected void _throwAsIOE(Exception e, Object value) throws IOException {
        if (e instanceof IllegalArgumentException) {
            String actType = value == null ? "[NULL]" : value.getClass().getName();
            StringBuilder msg = new StringBuilder("Problem deserializing property '").append(this.getName());
            msg.append("' (expected type: ").append(this.getType());
            msg.append("; actual type: ").append(actType).append(")");
            String origMsg = e.getMessage();
            if (origMsg != null) {
                msg.append(", problem: ").append(origMsg);
            } else {
                msg.append(" (no error message provided)");
            }
            throw new JsonMappingException(msg.toString(), null, e);
        }
        this._throwAsIOE(e);
    }

    protected IOException _throwAsIOE(Exception e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        Throwable th = e;
        while (th.getCause() != null) {
            th = th.getCause();
        }
        throw new JsonMappingException(th.getMessage(), null, th);
    }

    public String toString() {
        return "[property '" + this.getName() + "']";
    }
}

