/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx;

import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.FullHttpRequest;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.FullHttpResponse;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpHeaders;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpResponseStatus;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.HttpVersion;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.prestosql.hadoop.$internal.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.prestosql.hadoop.$internal.io.netty.util.CharsetUtil;

public class WebSocketServerHandshaker13
extends WebSocketServerHandshaker {
    public static final String WEBSOCKET_13_ACCEPT_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private final boolean allowExtensions;

    public WebSocketServerHandshaker13(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        super(WebSocketVersion.V13, webSocketURL, subprotocols, maxFramePayloadLength);
        this.allowExtensions = allowExtensions;
    }

    @Override
    protected FullHttpResponse newHandshakeResponse(FullHttpRequest req, HttpHeaders headers) {
        String key;
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        if (headers != null) {
            res.headers().add(headers);
        }
        if ((key = req.headers().get("Sec-WebSocket-Key")) == null) {
            throw new WebSocketHandshakeException("not a WebSocket request: missing key");
        }
        String acceptSeed = key + WEBSOCKET_13_ACCEPT_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        String accept = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 13 server handshake key: {}, response: {}", (Object)key, (Object)accept);
        }
        res.headers().add("Upgrade", (Object)"WebSocket".toLowerCase());
        res.headers().add("Connection", (Object)"Upgrade");
        res.headers().add("Sec-WebSocket-Accept", (Object)accept);
        String subprotocols = req.headers().get("Sec-WebSocket-Protocol");
        if (subprotocols != null) {
            String selectedSubprotocol = this.selectSubprotocol(subprotocols);
            if (selectedSubprotocol == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Requested subprotocol(s) not supported: {}", (Object)subprotocols);
                }
            } else {
                res.headers().add("Sec-WebSocket-Protocol", (Object)selectedSubprotocol);
            }
        }
        return res;
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket13FrameDecoder(true, this.allowExtensions, this.maxFramePayloadLength());
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket13FrameEncoder(false);
    }
}

