/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.avro.io;

import io.prestosql.hadoop.$internal.org.apache.avro.AvroTypeException;
import io.prestosql.hadoop.$internal.org.apache.avro.Schema;
import io.prestosql.hadoop.$internal.org.apache.avro.io.Decoder;
import io.prestosql.hadoop.$internal.org.apache.avro.io.DecoderFactory;
import io.prestosql.hadoop.$internal.org.apache.avro.io.ValidatingDecoder;
import io.prestosql.hadoop.$internal.org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import io.prestosql.hadoop.$internal.org.apache.avro.io.parsing.Symbol;
import java.io.IOException;

public class ResolvingDecoder
extends ValidatingDecoder {
    private Decoder backup;

    ResolvingDecoder(Schema writer, Schema reader, Decoder in) throws IOException {
        this(ResolvingDecoder.resolve(writer, reader), in);
    }

    private ResolvingDecoder(Object resolver, Decoder in) throws IOException {
        super((Symbol)resolver, in);
    }

    public static Object resolve(Schema writer, Schema reader) throws IOException {
        if (null == writer) {
            throw new NullPointerException("writer cannot be null!");
        }
        if (null == reader) {
            throw new NullPointerException("reader cannot be null!");
        }
        return new ResolvingGrammarGenerator().generate(writer, reader);
    }

    public final Schema.Field[] readFieldOrder() throws IOException {
        return ((Symbol.FieldOrderAction)this.parser.advance((Symbol)Symbol.FIELD_ACTION)).fields;
    }

    public final void drain() throws IOException {
        this.parser.processImplicitActions();
    }

    @Override
    public long readLong() throws IOException {
        Symbol actual = this.parser.advance(Symbol.LONG);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.DOUBLE) {
            return (long)this.in.readDouble();
        }
        assert (actual == Symbol.LONG);
        return this.in.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        Symbol actual = this.parser.advance(Symbol.FLOAT);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.LONG) {
            return this.in.readLong();
        }
        assert (actual == Symbol.FLOAT);
        return this.in.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        Symbol actual = this.parser.advance(Symbol.DOUBLE);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.LONG) {
            return this.in.readLong();
        }
        if (actual == Symbol.FLOAT) {
            return this.in.readFloat();
        }
        assert (actual == Symbol.DOUBLE);
        return this.in.readDouble();
    }

    @Override
    public int readEnum() throws IOException {
        this.parser.advance(Symbol.ENUM);
        Symbol.EnumAdjustAction top = (Symbol.EnumAdjustAction)this.parser.popSymbol();
        int n = this.in.readEnum();
        Object o = top.adjustments[n];
        if (o instanceof Integer) {
            return (Integer)o;
        }
        throw new AvroTypeException((String)o);
    }

    @Override
    public int readIndex() throws IOException {
        this.parser.advance(Symbol.UNION);
        Symbol.UnionAdjustAction top = (Symbol.UnionAdjustAction)this.parser.popSymbol();
        this.parser.pushSymbol(top.symToParse);
        return top.rindex;
    }

    @Override
    public Symbol doAction(Symbol input, Symbol top) throws IOException {
        if (top instanceof Symbol.FieldOrderAction) {
            return input == Symbol.FIELD_ACTION ? top : null;
        }
        if (top instanceof Symbol.ResolvingAction) {
            Symbol.ResolvingAction t = (Symbol.ResolvingAction)top;
            if (t.reader != input) {
                throw new AvroTypeException("Found " + t.reader + " while looking for " + input);
            }
            return t.writer;
        }
        if (top instanceof Symbol.SkipAction) {
            Symbol symToSkip = ((Symbol.SkipAction)top).symToSkip;
            this.parser.skipSymbol(symToSkip);
        } else if (top instanceof Symbol.WriterUnionAction) {
            Symbol.Alternative branches = (Symbol.Alternative)this.parser.popSymbol();
            this.parser.pushSymbol(branches.getSymbol(this.in.readIndex()));
        } else {
            if (top instanceof Symbol.ErrorAction) {
                throw new AvroTypeException(((Symbol.ErrorAction)top).msg);
            }
            if (top instanceof Symbol.DefaultStartAction) {
                Symbol.DefaultStartAction dsa = (Symbol.DefaultStartAction)top;
                this.backup = this.in;
                this.in = DecoderFactory.get().binaryDecoder(dsa.contents, null);
            } else if (top == Symbol.DEFAULT_END_ACTION) {
                this.in = this.backup;
            } else {
                throw new AvroTypeException("Unknown action: " + top);
            }
        }
        return null;
    }

    @Override
    public void skipAction() throws IOException {
        Symbol top = this.parser.popSymbol();
        if (top instanceof Symbol.ResolvingAction) {
            this.parser.pushSymbol(((Symbol.ResolvingAction)top).writer);
        } else if (top instanceof Symbol.SkipAction) {
            this.parser.pushSymbol(((Symbol.SkipAction)top).symToSkip);
        } else if (top instanceof Symbol.WriterUnionAction) {
            Symbol.Alternative branches = (Symbol.Alternative)this.parser.popSymbol();
            this.parser.pushSymbol(branches.getSymbol(this.in.readIndex()));
        } else {
            if (top instanceof Symbol.ErrorAction) {
                throw new AvroTypeException(((Symbol.ErrorAction)top).msg);
            }
            if (top instanceof Symbol.DefaultStartAction) {
                Symbol.DefaultStartAction dsa = (Symbol.DefaultStartAction)top;
                this.backup = this.in;
                this.in = DecoderFactory.get().binaryDecoder(dsa.contents, null);
            } else if (top == Symbol.DEFAULT_END_ACTION) {
                this.in = this.backup;
            }
        }
    }
}

