/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.random;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.security.SecureRandom;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.util.NativeCodeLoader;

@InterfaceAudience.Private
public class OpensslSecureRandom
extends Random {
    private static final long serialVersionUID = -7828193502768789584L;
    private static final Log LOG = LogFactory.getLog(OpensslSecureRandom.class.getName());
    private SecureRandom fallback = null;
    private static boolean nativeEnabled = false;

    public static boolean isNativeCodeLoaded() {
        return nativeEnabled;
    }

    public OpensslSecureRandom() {
        if (!nativeEnabled) {
            this.fallback = new SecureRandom();
        }
    }

    @Override
    public void nextBytes(byte[] bytes) {
        if (!nativeEnabled || !this.nextRandBytes(bytes)) {
            this.fallback.nextBytes(bytes);
        }
    }

    @Override
    public void setSeed(long seed) {
    }

    @Override
    protected final int next(int numBits) {
        Preconditions.checkArgument(numBits >= 0 && numBits <= 32);
        int numBytes = (numBits + 7) / 8;
        byte[] b = new byte[numBytes];
        int next = 0;
        this.nextBytes(b);
        for (int i = 0; i < numBytes; ++i) {
            next = (next << 8) + (b[i] & 0xFF);
        }
        return next >>> numBytes * 8 - numBits;
    }

    private static native void initSR();

    private native boolean nextRandBytes(byte[] var1);

    static {
        if (NativeCodeLoader.isNativeCodeLoaded() && NativeCodeLoader.buildSupportsOpenssl()) {
            try {
                OpensslSecureRandom.initSR();
                nativeEnabled = true;
            }
            catch (Throwable t) {
                LOG.error("Failed to load Openssl SecureRandom", t);
            }
        }
    }
}

