/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure.metrics;

import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.RequestResult;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.ResponseReceivedEvent;
import io.prestosql.hadoop.$internal.com.microsoft.azure.storage.StorageEvent;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.metrics.AzureFileSystemInstrumentation;

@InterfaceAudience.Private
public final class ErrorMetricUpdater
extends StorageEvent<ResponseReceivedEvent> {
    private final AzureFileSystemInstrumentation instrumentation;
    private final OperationContext operationContext;

    private ErrorMetricUpdater(OperationContext operationContext, AzureFileSystemInstrumentation instrumentation) {
        this.instrumentation = instrumentation;
        this.operationContext = operationContext;
    }

    public static void hook(OperationContext operationContext, AzureFileSystemInstrumentation instrumentation) {
        ErrorMetricUpdater listener = new ErrorMetricUpdater(operationContext, instrumentation);
        operationContext.getResponseReceivedEventHandler().addListener(listener);
    }

    @Override
    public void eventOccurred(ResponseReceivedEvent eventArg) {
        RequestResult currentResult = this.operationContext.getLastResult();
        int statusCode = currentResult.getStatusCode();
        if (statusCode >= 400 && statusCode < 500 && statusCode != 404) {
            this.instrumentation.clientErrorEncountered();
        } else if (statusCode >= 500) {
            this.instrumentation.serverErrorEncountered();
        }
    }
}

