/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.bzip2;

import io.prestosql.hadoop.$internal.org.apache.commons.logging.Log;
import io.prestosql.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.bzip2.Bzip2Factory;

public class Bzip2Compressor
implements Compressor {
    private static final int DEFAULT_DIRECT_BUFFER_SIZE = 65536;
    static final int DEFAULT_BLOCK_SIZE = 9;
    static final int DEFAULT_WORK_FACTOR = 30;
    private static final Log LOG = LogFactory.getLog(Bzip2Compressor.class);
    private static Class<Bzip2Compressor> clazz = Bzip2Compressor.class;
    private long stream;
    private int blockSize;
    private int workFactor;
    private int directBufferSize;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private Buffer uncompressedDirectBuf = null;
    private int uncompressedDirectBufOff = 0;
    private int uncompressedDirectBufLen = 0;
    private boolean keepUncompressedBuf = false;
    private Buffer compressedDirectBuf = null;
    private boolean finish;
    private boolean finished;

    public Bzip2Compressor() {
        this(9, 30, 65536);
    }

    public Bzip2Compressor(Configuration conf) {
        this(Bzip2Factory.getBlockSize(conf), Bzip2Factory.getWorkFactor(conf), 65536);
    }

    public Bzip2Compressor(int blockSize, int workFactor, int directBufferSize) {
        this.blockSize = blockSize;
        this.workFactor = workFactor;
        this.directBufferSize = directBufferSize;
        this.stream = Bzip2Compressor.init(blockSize, workFactor);
        this.uncompressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf = ByteBuffer.allocateDirect(directBufferSize);
        this.compressedDirectBuf.position(directBufferSize);
    }

    @Override
    public synchronized void reinit(Configuration conf) {
        this.reset();
        Bzip2Compressor.end(this.stream);
        if (conf == null) {
            this.stream = Bzip2Compressor.init(this.blockSize, this.workFactor);
            return;
        }
        this.blockSize = Bzip2Factory.getBlockSize(conf);
        this.workFactor = Bzip2Factory.getWorkFactor(conf);
        this.stream = Bzip2Compressor.init(this.blockSize, this.workFactor);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reinit compressor with new compression configuration");
        }
    }

    @Override
    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.uncompressedDirectBufOff = 0;
        this.setInputFromSavedData();
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
    }

    synchronized void setInputFromSavedData() {
        int len = Math.min(this.userBufLen, this.uncompressedDirectBuf.remaining());
        ((ByteBuffer)this.uncompressedDirectBuf).put(this.userBuf, this.userBufOff, len);
        this.userBufLen -= len;
        this.userBufOff += len;
        this.uncompressedDirectBufLen = this.uncompressedDirectBuf.position();
    }

    @Override
    public synchronized void setDictionary(byte[] b, int off, int len) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized boolean needsInput() {
        if (this.compressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.keepUncompressedBuf && this.uncompressedDirectBufLen > 0) {
            return false;
        }
        if (this.uncompressedDirectBuf.remaining() > 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
            return this.uncompressedDirectBuf.remaining() > 0;
        }
        return false;
    }

    @Override
    public synchronized void finish() {
        this.finish = true;
    }

    @Override
    public synchronized boolean finished() {
        return this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    @Override
    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
            return n;
        }
        this.compressedDirectBuf.rewind();
        this.compressedDirectBuf.limit(this.directBufferSize);
        n = this.deflateBytesDirect();
        this.compressedDirectBuf.limit(n);
        if (this.uncompressedDirectBufLen <= 0) {
            this.keepUncompressedBuf = false;
            this.uncompressedDirectBuf.clear();
            this.uncompressedDirectBufOff = 0;
            this.uncompressedDirectBufLen = 0;
        } else {
            this.keepUncompressedBuf = true;
        }
        n = Math.min(n, len);
        ((ByteBuffer)this.compressedDirectBuf).get(b, off, n);
        return n;
    }

    @Override
    public synchronized long getBytesWritten() {
        this.checkStream();
        return Bzip2Compressor.getBytesWritten(this.stream);
    }

    @Override
    public synchronized long getBytesRead() {
        this.checkStream();
        return Bzip2Compressor.getBytesRead(this.stream);
    }

    @Override
    public synchronized void reset() {
        this.checkStream();
        Bzip2Compressor.end(this.stream);
        this.stream = Bzip2Compressor.init(this.blockSize, this.workFactor);
        this.finish = false;
        this.finished = false;
        this.uncompressedDirectBuf.rewind();
        this.uncompressedDirectBufLen = 0;
        this.uncompressedDirectBufOff = 0;
        this.keepUncompressedBuf = false;
        this.compressedDirectBuf.limit(this.directBufferSize);
        this.compressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    @Override
    public synchronized void end() {
        if (this.stream != 0L) {
            Bzip2Compressor.end(this.stream);
            this.stream = 0L;
        }
    }

    static void initSymbols(String libname) {
        Bzip2Compressor.initIDs(libname);
    }

    private void checkStream() {
        if (this.stream == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs(String var0);

    private static native long init(int var0, int var1);

    private native int deflateBytesDirect();

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void end(long var0);

    public static native String getLibraryName();
}

