/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.function;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.apache.pinot.common.function.FunctionInfo;
import org.apache.pinot.common.function.FunctionInvoker;
import org.apache.pinot.common.function.FunctionRegistry;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.spi.data.readers.GenericRow;

public class InbuiltFunctionEvaluator
implements FunctionEvaluator {
    private final ExecutableNode _rootNode;
    private final List<String> _arguments = new ArrayList<String>();

    public InbuiltFunctionEvaluator(String functionExpression) {
        this._rootNode = this.planExecution(RequestContextUtils.getExpressionFromSQL((String)functionExpression));
    }

    private ExecutableNode planExecution(ExpressionContext expression) {
        switch (expression.getType()) {
            case LITERAL: {
                return new ConstantExecutionNode(expression.getLiteral());
            }
            case IDENTIFIER: {
                String columnName = expression.getIdentifier();
                ColumnExecutionNode columnExecutionNode = new ColumnExecutionNode(columnName, this._arguments.size());
                this._arguments.add(columnName);
                return columnExecutionNode;
            }
            case FUNCTION: {
                FunctionContext function = expression.getFunction();
                List arguments = function.getArguments();
                int numArguments = arguments.size();
                ExecutableNode[] childNodes = new ExecutableNode[numArguments];
                for (int i = 0; i < numArguments; ++i) {
                    childNodes[i] = this.planExecution((ExpressionContext)arguments.get(i));
                }
                String functionName = function.getFunctionName();
                FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo((String)functionName, (int)numArguments);
                Preconditions.checkState((functionInfo != null ? 1 : 0) != 0, (String)"Unsupported function: %s with %s parameters", (Object)functionName, (int)numArguments);
                return new FunctionExecutionNode(functionInfo, childNodes);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public List<String> getArguments() {
        return this._arguments;
    }

    @Override
    public Object evaluate(GenericRow row) {
        return this._rootNode.execute(row);
    }

    @Override
    public Object evaluate(Object[] values) {
        return this._rootNode.execute(values);
    }

    private static class ColumnExecutionNode
    implements ExecutableNode {
        final String _column;
        final int _id;

        ColumnExecutionNode(String column, int id) {
            this._column = column;
            this._id = id;
        }

        @Override
        public Object execute(GenericRow row) {
            return row.getValue(this._column);
        }

        @Override
        public Object execute(Object[] values) {
            return values[this._id];
        }
    }

    private static class ConstantExecutionNode
    implements ExecutableNode {
        final String _value;

        ConstantExecutionNode(String value) {
            this._value = value;
        }

        @Override
        public String execute(GenericRow row) {
            return this._value;
        }

        @Override
        public Object execute(Object[] values) {
            return this._value;
        }
    }

    private static class FunctionExecutionNode
    implements ExecutableNode {
        final FunctionInvoker _functionInvoker;
        final ExecutableNode[] _argumentNodes;
        final Object[] _arguments;

        FunctionExecutionNode(FunctionInfo functionInfo, ExecutableNode[] argumentNodes) {
            this._functionInvoker = new FunctionInvoker(functionInfo);
            this._argumentNodes = argumentNodes;
            this._arguments = new Object[this._argumentNodes.length];
        }

        @Override
        public Object execute(GenericRow row) {
            int numArguments = this._argumentNodes.length;
            for (int i = 0; i < numArguments; ++i) {
                this._arguments[i] = this._argumentNodes[i].execute(row);
            }
            this._functionInvoker.convertTypes(this._arguments);
            return this._functionInvoker.invoke(this._arguments);
        }

        @Override
        public Object execute(Object[] values) {
            int numArguments = this._argumentNodes.length;
            for (int i = 0; i < numArguments; ++i) {
                this._arguments[i] = this._argumentNodes[i].execute(values);
            }
            this._functionInvoker.convertTypes(this._arguments);
            return this._functionInvoker.invoke(this._arguments);
        }
    }

    private static interface ExecutableNode {
        public Object execute(GenericRow var1);

        public Object execute(Object[] var1);
    }
}

