/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.immutable;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.indexsegment.immutable.EmptyIndexSegment;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentImpl;
import org.apache.pinot.segment.local.segment.index.column.PhysicalColumnIndexContainer;
import org.apache.pinot.segment.local.segment.index.converter.SegmentFormatConverterFactory;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.SegmentPreProcessor;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.segment.local.startree.v2.store.StarTreeIndexContainer;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.converter.SegmentFormatConverter;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoader;
import org.apache.pinot.segment.spi.loader.SegmentDirectoryLoaderRegistry;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmutableSegmentLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmutableSegmentLoader.class);

    private ImmutableSegmentLoader() {
    }

    public static ImmutableSegment load(File indexDir, ReadMode readMode) throws Exception {
        IndexLoadingConfig defaultIndexLoadingConfig = new IndexLoadingConfig();
        defaultIndexLoadingConfig.setReadMode(readMode);
        return ImmutableSegmentLoader.load(indexDir, defaultIndexLoadingConfig, null);
    }

    public static ImmutableSegment load(File indexDir, IndexLoadingConfig indexLoadingConfig) throws Exception {
        return ImmutableSegmentLoader.load(indexDir, indexLoadingConfig, null);
    }

    /*
     * WARNING - void declaration
     */
    public static ImmutableSegment load(File indexDir, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        void var16_24;
        SegmentVersion segmentVersionOnDisk;
        Preconditions.checkArgument((boolean)indexDir.isDirectory(), (String)"Index directory: %s does not exist or is not a directory", (Object)indexDir);
        String segmentName = indexDir.getName();
        SegmentVersion segmentVersionToLoad = indexLoadingConfig.getSegmentVersion();
        SegmentMetadataImpl localSegmentMetadata = new SegmentMetadataImpl(indexDir);
        if (segmentVersionToLoad != null && !SegmentDirectoryPaths.segmentDirectoryFor((File)indexDir, (SegmentVersion)segmentVersionToLoad).isDirectory() && (segmentVersionOnDisk = localSegmentMetadata.getVersion()) != segmentVersionToLoad) {
            LOGGER.info("Segment: {} needs to be converted from version: {} to {}", new Object[]{segmentName, segmentVersionOnDisk, segmentVersionToLoad});
            SegmentFormatConverter converter = SegmentFormatConverterFactory.getConverter(segmentVersionOnDisk, segmentVersionToLoad);
            LOGGER.info("Using converter: {} to up-convert segment: {}", (Object)converter.getClass().getName(), (Object)segmentName);
            converter.convert(indexDir);
            LOGGER.info("Successfully up-converted segment: {} from version: {} to {}", new Object[]{segmentName, segmentVersionOnDisk, segmentVersionToLoad});
        }
        if (localSegmentMetadata.getTotalDocs() == 0) {
            return new EmptyIndexSegment(localSegmentMetadata);
        }
        PinotConfiguration tierConfigs = indexLoadingConfig.getTierConfigs();
        PinotConfiguration segmentDirectoryLoaderConfigs = new PinotConfiguration(tierConfigs.toMap());
        SegmentDirectory localSegmentDirectory = SegmentDirectoryLoaderRegistry.getLocalSegmentDirectoryLoader().load(indexDir.toURI(), segmentDirectoryLoaderConfigs);
        try (SegmentPreProcessor preProcessor = new SegmentPreProcessor(localSegmentDirectory, indexLoadingConfig, schema);){
            preProcessor.process();
        }
        SegmentDirectoryLoader segmentLoaderDirectory = SegmentDirectoryLoaderRegistry.getSegmentDirectoryLoader((String)indexLoadingConfig.getTierBackend());
        SegmentDirectory actualSegmentDirectory = segmentLoaderDirectory.load(indexDir.toURI(), segmentDirectoryLoaderConfigs);
        SegmentDirectory.Reader segmentReader = actualSegmentDirectory.createReader();
        SegmentMetadataImpl segmentMetadata = actualSegmentDirectory.getSegmentMetadata();
        Map columnMetadataMap = segmentMetadata.getColumnMetadataMap();
        if (schema != null) {
            HashSet columnsInMetadata = new HashSet(columnMetadataMap.keySet());
            columnsInMetadata.removeIf(arg_0 -> ((Schema)schema).hasColumn(arg_0));
            if (!columnsInMetadata.isEmpty()) {
                LOGGER.info("Skip loading columns only exist in metadata but not in schema: {}", columnsInMetadata);
                for (String string : columnsInMetadata) {
                    segmentMetadata.removeColumn(string);
                }
            }
        }
        HashMap<String, ColumnIndexContainer> indexContainerMap = new HashMap<String, ColumnIndexContainer>();
        for (Map.Entry entry : columnMetadataMap.entrySet()) {
            indexContainerMap.put((String)entry.getKey(), new PhysicalColumnIndexContainer(segmentReader, (ColumnMetadata)entry.getValue(), indexLoadingConfig, indexDir));
        }
        Schema segmentSchema = segmentMetadata.getSchema();
        VirtualColumnProviderFactory.addBuiltInVirtualColumnsToSegmentSchema(segmentSchema, segmentName);
        for (FieldSpec fieldSpec : segmentSchema.getAllFieldSpecs()) {
            if (!fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            VirtualColumnContext context = new VirtualColumnContext(fieldSpec, segmentMetadata.getTotalDocs());
            VirtualColumnProvider provider = VirtualColumnProviderFactory.buildProvider(context);
            indexContainerMap.put(columnName, provider.buildColumnIndexContainer(context));
            columnMetadataMap.put(columnName, provider.buildMetadata(context));
        }
        Object var16_22 = null;
        if (segmentMetadata.getStarTreeV2MetadataList() != null) {
            StarTreeIndexContainer starTreeIndexContainer = new StarTreeIndexContainer(SegmentDirectoryPaths.findSegmentDirectory((File)indexDir), segmentMetadata, indexContainerMap, indexLoadingConfig.getReadMode());
        }
        ImmutableSegmentImpl segment = new ImmutableSegmentImpl(actualSegmentDirectory, segmentMetadata, indexContainerMap, (StarTreeIndexContainer)var16_24);
        LOGGER.info("Successfully loaded segment {} with config: {}", (Object)segmentName, (Object)segmentDirectoryLoaderConfigs);
        return segment;
    }
}

