/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.mutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.pinot.common.metadata.segment.RealtimeSegmentZKMetadata;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerMeter;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentConfig;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.segment.local.realtime.impl.dictionary.MutableDictionaryFactory;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteMVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.VarByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.geospatial.MutableH3Index;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeInvertedIndexReader;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneIndexRefreshState;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneTextIndexReader;
import org.apache.pinot.segment.local.realtime.impl.json.MutableJsonIndex;
import org.apache.pinot.segment.local.realtime.impl.nullvalue.MutableNullValueVector;
import org.apache.pinot.segment.local.segment.index.datasource.ImmutableDataSource;
import org.apache.pinot.segment.local.segment.index.datasource.MutableDataSource;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProvider;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnProviderFactory;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.local.utils.FixedIntArrayOffHeapIdMap;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.local.utils.IdMap;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.MutableDictionary;
import org.apache.pinot.segment.spi.index.reader.MutableForwardIndex;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.FixedIntArray;
import org.roaringbitmap.PeekableIntIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutableSegmentImpl
implements MutableSegment {
    private static final int MAX_MULTI_VALUES_PER_ROW = 1000;
    private static final String RECORD_ID_MAP = "__recordIdMap__";
    private static final int EXPECTED_COMPRESSION = 1000;
    private static final int MIN_ROWS_TO_INDEX = 1000000;
    private static final int MIN_RECORD_ID_MAP_CACHE_SIZE = 10000;
    private static final int NODICT_VARIABLE_WIDTH_ESTIMATED_AVERAGE_VALUE_LENGTH_DEFAULT = 100;
    private static final int NODICT_VARIABLE_WIDTH_ESTIMATED_NUMBER_OF_VALUES_DEFAULT = 100000;
    private final Logger _logger;
    private final long _startTimeMillis = System.currentTimeMillis();
    private final ServerMetrics _serverMetrics;
    private final String _tableNameWithType;
    private final String _segmentName;
    private final Schema _schema;
    private final String _timeColumnName;
    private final int _capacity;
    private final SegmentMetadata _segmentMetadata;
    private final boolean _offHeap;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final RealtimeSegmentStatsHistory _statsHistory;
    private final String _partitionColumn;
    private final PartitionFunction _partitionFunction;
    private final boolean _nullHandlingEnabled;
    private final Map<String, IndexContainer> _indexContainerMap = new HashMap<String, IndexContainer>();
    private final IdMap<FixedIntArray> _recordIdMap;
    private boolean _aggregateMetrics;
    private volatile int _numDocsIndexed = 0;
    private final int _numKeyColumns;
    private final Collection<FieldSpec> _physicalFieldSpecs;
    private final Collection<DimensionFieldSpec> _physicalDimensionFieldSpecs;
    private final Collection<MetricFieldSpec> _physicalMetricFieldSpecs;
    private final Collection<String> _physicalTimeColumnNames;
    private volatile long _lastIndexedTimeMs = Long.MIN_VALUE;
    private volatile long _latestIngestionTimeMs = Long.MIN_VALUE;
    private RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders _realtimeLuceneReaders;
    private final Map<String, FieldSpec> _newlyAddedColumnsFieldMap = new ConcurrentHashMap<String, FieldSpec>();
    private final Map<String, FieldSpec> _newlyAddedPhysicalColumnsFieldMap = new ConcurrentHashMap<String, FieldSpec>();
    private final UpsertConfig.Mode _upsertMode;
    private final PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private final ThreadSafeMutableRoaringBitmap _validDocIds;

    public MutableSegmentImpl(RealtimeSegmentConfig config, @Nullable ServerMetrics serverMetrics) {
        this._serverMetrics = serverMetrics;
        this._tableNameWithType = config.getTableNameWithType();
        this._segmentName = config.getSegmentName();
        this._schema = config.getSchema();
        this._timeColumnName = config.getTimeColumnName();
        this._capacity = config.getCapacity();
        RealtimeSegmentZKMetadata realtimeSegmentZKMetadata = config.getRealtimeSegmentZKMetadata();
        this._segmentMetadata = new SegmentMetadataImpl(realtimeSegmentZKMetadata.getTableName(), realtimeSegmentZKMetadata.getSegmentName(), this._schema, realtimeSegmentZKMetadata.getCreationTime()){

            public int getTotalDocs() {
                return MutableSegmentImpl.this._numDocsIndexed;
            }

            public long getLastIndexedTimestamp() {
                return MutableSegmentImpl.this._lastIndexedTimeMs;
            }

            public long getLatestIngestionTimestamp() {
                return MutableSegmentImpl.this._latestIngestionTimeMs;
            }
        };
        this._offHeap = config.isOffHeap();
        this._memoryManager = config.getMemoryManager();
        this._statsHistory = config.getStatsHistory();
        this._partitionColumn = config.getPartitionColumn();
        this._partitionFunction = config.getPartitionFunction();
        this._nullHandlingEnabled = config.isNullHandlingEnabled();
        this._aggregateMetrics = config.aggregateMetrics();
        Collection allFieldSpecs = this._schema.getAllFieldSpecs();
        ArrayList<FieldSpec> physicalFieldSpecs = new ArrayList<FieldSpec>(allFieldSpecs.size());
        ArrayList<DimensionFieldSpec> physicalDimensionFieldSpecs = new ArrayList<DimensionFieldSpec>(this._schema.getDimensionNames().size());
        ArrayList<MetricFieldSpec> physicalMetricFieldSpecs = new ArrayList<MetricFieldSpec>(this._schema.getMetricNames().size());
        ArrayList<String> physicalTimeColumnNames = new ArrayList<String>();
        for (FieldSpec fieldSpec : allFieldSpecs) {
            if (fieldSpec.isVirtualColumn()) continue;
            physicalFieldSpecs.add(fieldSpec);
            FieldSpec.FieldType fieldType = fieldSpec.getFieldType();
            if (fieldType == FieldSpec.FieldType.DIMENSION) {
                physicalDimensionFieldSpecs.add((DimensionFieldSpec)fieldSpec);
                continue;
            }
            if (fieldType == FieldSpec.FieldType.METRIC) {
                physicalMetricFieldSpecs.add((MetricFieldSpec)fieldSpec);
                continue;
            }
            if (fieldType != FieldSpec.FieldType.DATE_TIME && fieldType != FieldSpec.FieldType.TIME) continue;
            physicalTimeColumnNames.add(fieldSpec.getName());
        }
        this._physicalFieldSpecs = Collections.unmodifiableCollection(physicalFieldSpecs);
        this._physicalDimensionFieldSpecs = Collections.unmodifiableCollection(physicalDimensionFieldSpecs);
        this._physicalMetricFieldSpecs = Collections.unmodifiableCollection(physicalMetricFieldSpecs);
        this._physicalTimeColumnNames = Collections.unmodifiableCollection(physicalTimeColumnNames);
        this._numKeyColumns = this._physicalDimensionFieldSpecs.size() + this._physicalTimeColumnNames.size();
        this._logger = LoggerFactory.getLogger((String)(MutableSegmentImpl.class.getName() + "_" + this._segmentName + "_" + config.getStreamName()));
        Set<String> noDictionaryColumns = config.getNoDictionaryColumns();
        Set<String> invertedIndexColumns = config.getInvertedIndexColumns();
        Set<String> textIndexColumns = config.getTextIndexColumns();
        Set<String> fstIndexColumns = config.getFSTIndexColumns();
        Set<String> jsonIndexColumns = config.getJsonIndexColumns();
        Map<String, H3IndexConfig> h3IndexConfigs = config.getH3IndexConfigs();
        int avgNumMultiValues = config.getAvgNumMultiValues();
        for (FieldSpec fieldSpec : this._physicalFieldSpecs) {
            MutableH3Index h3Index;
            RealtimeLuceneTextIndexReader textIndex;
            RealtimeInvertedIndexReader invertedIndexReader;
            Object forwardIndex;
            MutableDictionary dictionary;
            String column = fieldSpec.getName();
            PartitionFunction partitionFunction = null;
            ConcurrentHashMap.KeySetView partitions = null;
            if (column.equals(this._partitionColumn)) {
                partitionFunction = this._partitionFunction;
                partitions = ConcurrentHashMap.newKeySet();
                partitions.add(config.getPartitionId());
            }
            FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
            boolean isFixedWidthColumn = storedType.isFixedWidth();
            if (this.isNoDictionaryColumn(noDictionaryColumns, invertedIndexColumns, fieldSpec, column)) {
                assert (fieldSpec.isSingleValueField());
                dictionary = null;
                String allocationContext = this.buildAllocationContext(this._segmentName, column, ".sv.raw.fwd");
                if (isFixedWidthColumn) {
                    forwardIndex = new FixedByteSVMutableForwardIndex(false, storedType, this._capacity, this._memoryManager, allocationContext);
                } else {
                    int initialCapacity = Math.min(this._capacity, 100000);
                    forwardIndex = new VarByteSVMutableForwardIndex(storedType, this._memoryManager, allocationContext, initialCapacity, 100);
                }
            } else {
                String allocationContext;
                int dictionaryColumnSize = isFixedWidthColumn ? storedType.size() : this._statsHistory.getEstimatedAvgColSize(column);
                int estimatedCardinality = (int)((double)this._statsHistory.getEstimatedCardinality(column) * 1.1);
                String dictionaryAllocationContext = this.buildAllocationContext(this._segmentName, column, ".dict");
                dictionary = MutableDictionaryFactory.getMutableDictionary(storedType, this._offHeap, this._memoryManager, dictionaryColumnSize, Math.min(estimatedCardinality, this._capacity), dictionaryAllocationContext);
                if (fieldSpec.isSingleValueField()) {
                    allocationContext = this.buildAllocationContext(this._segmentName, column, ".sv.unsorted.fwd");
                    forwardIndex = new FixedByteSVMutableForwardIndex(true, FieldSpec.DataType.INT, this._capacity, this._memoryManager, allocationContext);
                } else {
                    allocationContext = this.buildAllocationContext(this._segmentName, column, ".mv.fwd");
                    forwardIndex = new FixedByteMVMutableForwardIndex(1000, avgNumMultiValues, this._capacity, 4, this._memoryManager, allocationContext);
                }
                noDictionaryColumns.remove(column);
            }
            RealtimeInvertedIndexReader realtimeInvertedIndexReader = invertedIndexReader = invertedIndexColumns.contains(column) ? new RealtimeInvertedIndexReader() : null;
            if (textIndexColumns.contains(column)) {
                textIndex = new RealtimeLuceneTextIndexReader(column, new File(config.getConsumerDir()), this._segmentName);
                if (this._realtimeLuceneReaders == null) {
                    this._realtimeLuceneReaders = new RealtimeLuceneIndexRefreshState.RealtimeLuceneReaders(this._segmentName);
                }
                this._realtimeLuceneReaders.addReader(textIndex);
            } else {
                textIndex = null;
            }
            MutableJsonIndex jsonIndex = jsonIndexColumns.contains(column) ? new MutableJsonIndex() : null;
            try {
                H3IndexConfig h3IndexConfig = h3IndexConfigs.get(column);
                h3Index = h3IndexConfig != null ? new MutableH3Index(h3IndexConfig.getResolution()) : null;
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Failed to initiate H3 index for column: %s", column), e);
            }
            MutableNullValueVector nullValueVector = this._nullHandlingEnabled ? new MutableNullValueVector() : null;
            this._indexContainerMap.put(column, new IndexContainer(fieldSpec, partitionFunction, partitions, new NumValuesInfo(), (MutableForwardIndex)forwardIndex, dictionary, invertedIndexReader, null, textIndex, fstIndexColumns.contains(column), jsonIndex, h3Index, null, nullValueVector));
        }
        if (this._realtimeLuceneReaders != null) {
            RealtimeLuceneIndexRefreshState realtimeLuceneIndexRefreshState = RealtimeLuceneIndexRefreshState.getInstance();
            realtimeLuceneIndexRefreshState.addRealtimeReadersToQueue(this._realtimeLuceneReaders);
        }
        this._recordIdMap = this.enableMetricsAggregationIfPossible(config, noDictionaryColumns);
        this._upsertMode = config.getUpsertMode();
        if (this.isUpsertEnabled()) {
            Preconditions.checkState((!this._aggregateMetrics ? 1 : 0) != 0, (Object)"Metrics aggregation and upsert cannot be enabled together");
            this._partitionUpsertMetadataManager = config.getPartitionUpsertMetadataManager();
            this._validDocIds = new ThreadSafeMutableRoaringBitmap();
        } else {
            this._partitionUpsertMetadataManager = null;
            this._validDocIds = null;
        }
    }

    private boolean isNoDictionaryColumn(Set<String> noDictionaryColumns, Set<String> invertedIndexColumns, FieldSpec fieldSpec, String column) {
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        if (noDictionaryColumns.contains(column)) {
            if (fieldSpec instanceof DimensionFieldSpec && this._aggregateMetrics && (dataType == FieldSpec.DataType.STRING || dataType == FieldSpec.DataType.BYTES)) {
                this._logger.info("Aggregate metrics is enabled. Will create dictionary in consuming segment for column {} of type {}", (Object)column, (Object)dataType.toString());
                return false;
            }
            return fieldSpec.isSingleValueField() && !invertedIndexColumns.contains(column);
        }
        return false;
    }

    public SegmentPartitionConfig getSegmentPartitionConfig() {
        if (this._partitionColumn != null) {
            return new SegmentPartitionConfig(Collections.singletonMap(this._partitionColumn, new ColumnPartitionConfig(this._partitionFunction.toString(), this._partitionFunction.getNumPartitions())));
        }
        return null;
    }

    @Deprecated
    public long getMinTime() {
        Long minTime = IngestionUtils.extractTimeValue(this._indexContainerMap.get((Object)this._timeColumnName)._minValue);
        if (minTime != null) {
            return minTime;
        }
        return Long.MAX_VALUE;
    }

    @Deprecated
    public long getMaxTime() {
        Long maxTime = IngestionUtils.extractTimeValue(this._indexContainerMap.get((Object)this._timeColumnName)._maxValue);
        if (maxTime != null) {
            return maxTime;
        }
        return Long.MIN_VALUE;
    }

    public void addExtraColumns(Schema newSchema) {
        for (String columnName : newSchema.getColumnNames()) {
            if (this._schema.getColumnNames().contains(columnName)) continue;
            FieldSpec fieldSpec = newSchema.getFieldSpecFor(columnName);
            this._newlyAddedColumnsFieldMap.put(columnName, fieldSpec);
            if (fieldSpec.isVirtualColumn()) continue;
            this._newlyAddedPhysicalColumnsFieldMap.put(columnName, fieldSpec);
        }
        this._logger.info("Newly added columns: " + this._newlyAddedColumnsFieldMap.toString());
    }

    public boolean index(GenericRow row, @Nullable RowMetadata rowMetadata) throws IOException {
        boolean canTakeMore;
        if (this.isUpsertEnabled()) {
            row = this.handleUpsert(row, this._numDocsIndexed);
            this.updateDictionary(row);
            this.addNewRow(row);
            canTakeMore = this._numDocsIndexed++ < this._capacity;
        } else {
            this.updateDictionary(row);
            int docId = this.getOrCreateDocId();
            if (docId == this._numDocsIndexed) {
                this.addNewRow(row);
                canTakeMore = this._numDocsIndexed++ < this._capacity;
            } else {
                assert (this._aggregateMetrics);
                this.aggregateMetrics(row, docId);
                canTakeMore = true;
            }
        }
        this._lastIndexedTimeMs = System.currentTimeMillis();
        if (rowMetadata != null) {
            this._latestIngestionTimeMs = Math.max(this._latestIngestionTimeMs, rowMetadata.getIngestionTimeMs());
        }
        return canTakeMore;
    }

    private boolean isUpsertEnabled() {
        return this._upsertMode != UpsertConfig.Mode.NONE;
    }

    private GenericRow handleUpsert(GenericRow row, int docId) {
        PrimaryKey primaryKey = row.getPrimaryKey(this._schema.getPrimaryKeyColumns());
        Object timeValue = row.getValue(this._timeColumnName);
        Preconditions.checkArgument((boolean)(timeValue instanceof Comparable), (Object)"time column shall be comparable");
        long timestamp = IngestionUtils.extractTimeValue((Comparable)timeValue);
        return this._partitionUpsertMetadataManager.updateRecord((IndexSegment)this, new PartitionUpsertMetadataManager.RecordInfo(primaryKey, docId, timestamp), row);
    }

    private void updateDictionary(GenericRow row) {
        for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
            String column = entry.getKey();
            IndexContainer indexContainer = entry.getValue();
            Object value = row.getValue(column);
            MutableDictionary dictionary = indexContainer._dictionary;
            if (dictionary == null) continue;
            if (indexContainer._fieldSpec.isSingleValueField()) {
                indexContainer._dictId = dictionary.index(value);
            } else {
                indexContainer._dictIds = dictionary.index((Object[])value);
            }
            indexContainer._minValue = dictionary.getMinVal();
            indexContainer._maxValue = dictionary.getMaxVal();
        }
    }

    private void addNewRow(GenericRow row) throws IOException {
        int docId = this._numDocsIndexed;
        for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
            String column = entry.getKey();
            IndexContainer indexContainer = entry.getValue();
            Object value = row.getValue(column);
            FieldSpec fieldSpec = indexContainer._fieldSpec;
            if (fieldSpec.isSingleValueField()) {
                MutableH3Index h3Index;
                MutableJsonIndex jsonIndex;
                int partition;
                if (column.equals(this._partitionColumn) && indexContainer._partitions.add(partition = this._partitionFunction.getPartition(value))) {
                    this._logger.warn("Found new partition: {} from partition column: {}, value: {}", new Object[]{partition, column, value});
                    if (this._serverMetrics != null) {
                        this._serverMetrics.addMeteredTableValue(this._tableNameWithType, (AbstractMetrics.Meter)ServerMeter.REALTIME_PARTITION_MISMATCH, 1L);
                    }
                }
                indexContainer._numValuesInfo.updateSVEntry();
                MutableForwardIndex forwardIndex = indexContainer._forwardIndex;
                int dictId = indexContainer._dictId;
                if (dictId >= 0) {
                    forwardIndex.setDictId(docId, dictId);
                    RealtimeInvertedIndexReader invertedIndex = indexContainer._invertedIndex;
                    if (invertedIndex != null) {
                        invertedIndex.add(dictId, docId);
                    }
                } else {
                    FieldSpec.DataType dataType = fieldSpec.getDataType();
                    switch (dataType.getStoredType()) {
                        case INT: {
                            forwardIndex.setInt(docId, ((Integer)value).intValue());
                            break;
                        }
                        case LONG: {
                            forwardIndex.setLong(docId, ((Long)value).longValue());
                            break;
                        }
                        case FLOAT: {
                            forwardIndex.setFloat(docId, ((Float)value).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            forwardIndex.setDouble(docId, ((Double)value).doubleValue());
                            break;
                        }
                        case STRING: {
                            forwardIndex.setString(docId, (String)value);
                            break;
                        }
                        case BYTES: {
                            forwardIndex.setBytes(docId, (byte[])value);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for no-dictionary column: " + column);
                        }
                    }
                    if (!this._aggregateMetrics || fieldSpec.getFieldType() != FieldSpec.FieldType.METRIC) {
                        Comparable comparable = dataType == FieldSpec.DataType.BYTES ? new ByteArray((byte[])value) : (Comparable)value;
                        if (indexContainer._minValue == null) {
                            indexContainer._minValue = comparable;
                            indexContainer._maxValue = comparable;
                        } else {
                            if (comparable.compareTo(indexContainer._minValue) < 0) {
                                indexContainer._minValue = comparable;
                            }
                            if (comparable.compareTo(indexContainer._maxValue) > 0) {
                                indexContainer._maxValue = comparable;
                            }
                        }
                    }
                }
                RealtimeLuceneTextIndexReader textIndex = indexContainer._textIndex;
                if (textIndex != null) {
                    textIndex.add((String)value);
                }
                if ((jsonIndex = indexContainer._jsonIndex) != null) {
                    jsonIndex.add((String)value);
                }
                if ((h3Index = indexContainer._h3Index) != null) {
                    h3Index.add(GeometrySerializer.deserialize((byte[])value));
                }
            } else {
                int[] dictIds = indexContainer._dictIds;
                indexContainer._numValuesInfo.updateMVEntry(dictIds.length);
                indexContainer._forwardIndex.setDictIdMV(docId, dictIds);
                RealtimeInvertedIndexReader invertedIndex = indexContainer._invertedIndex;
                if (invertedIndex != null) {
                    for (int dictId : dictIds) {
                        invertedIndex.add(dictId, docId);
                    }
                }
            }
            if (!this._nullHandlingEnabled || !row.isNullValue(column)) continue;
            indexContainer._nullValueVector.setNull(docId);
        }
    }

    private void aggregateMetrics(GenericRow row, int docId) {
        block6: for (MetricFieldSpec metricFieldSpec : this._physicalMetricFieldSpecs) {
            String column = metricFieldSpec.getName();
            Object value = row.getValue(column);
            MutableForwardIndex forwardIndex = this._indexContainerMap.get((Object)column)._forwardIndex;
            FieldSpec.DataType dataType = metricFieldSpec.getDataType();
            switch (dataType) {
                case INT: {
                    forwardIndex.setInt(docId, (Integer)value + forwardIndex.getInt(docId));
                    continue block6;
                }
                case LONG: {
                    forwardIndex.setLong(docId, (Long)value + forwardIndex.getLong(docId));
                    continue block6;
                }
                case FLOAT: {
                    forwardIndex.setFloat(docId, ((Float)value).floatValue() + forwardIndex.getFloat(docId));
                    continue block6;
                }
                case DOUBLE: {
                    forwardIndex.setDouble(docId, (Double)value + forwardIndex.getDouble(docId));
                    continue block6;
                }
            }
            throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for aggregate metric column: " + column);
        }
    }

    public int getNumDocsIndexed() {
        return this._numDocsIndexed;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public SegmentMetadata getSegmentMetadata() {
        return this._segmentMetadata;
    }

    public Set<String> getColumnNames() {
        return Sets.union((Set)this._schema.getColumnNames(), this._newlyAddedColumnsFieldMap.keySet());
    }

    public Set<String> getPhysicalColumnNames() {
        HashSet<String> physicalColumnNames = new HashSet<String>();
        for (FieldSpec fieldSpec : this._physicalFieldSpecs) {
            physicalColumnNames.add(fieldSpec.getName());
        }
        return Sets.union(physicalColumnNames, this._newlyAddedPhysicalColumnsFieldMap.keySet());
    }

    public DataSource getDataSource(String column) {
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        if (fieldSpec == null || fieldSpec.isVirtualColumn()) {
            if (fieldSpec == null) {
                fieldSpec = this._newlyAddedColumnsFieldMap.get(column);
                Preconditions.checkNotNull((Object)fieldSpec, (Object)("FieldSpec for " + column + " should not be null. Potentially invalid column name specified."));
            }
            VirtualColumnContext virtualColumnContext = new VirtualColumnContext(fieldSpec, this._numDocsIndexed);
            VirtualColumnProvider virtualColumnProvider = VirtualColumnProviderFactory.buildProvider(virtualColumnContext);
            return new ImmutableDataSource(virtualColumnProvider.buildMetadata(virtualColumnContext), virtualColumnProvider.buildColumnIndexContainer(virtualColumnContext));
        }
        return this._indexContainerMap.get(column).toDataSource();
    }

    public List<StarTreeV2> getStarTrees() {
        return null;
    }

    @Nullable
    public ThreadSafeMutableRoaringBitmap getValidDocIds() {
        return this._validDocIds;
    }

    public GenericRow getRecord(int docId, GenericRow reuse) {
        for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
            String column = entry.getKey();
            IndexContainer indexContainer = entry.getValue();
            Object value = MutableSegmentImpl.getValue(docId, indexContainer._forwardIndex, indexContainer._dictionary, indexContainer._numValuesInfo._maxNumValuesPerMVEntry);
            if (this._nullHandlingEnabled && indexContainer._nullValueVector.isNull(docId)) {
                reuse.putDefaultNullValue(column, value);
                continue;
            }
            reuse.putValue(column, value);
        }
        return reuse;
    }

    private static Object getValue(int docId, MutableForwardIndex forwardIndex, @Nullable MutableDictionary dictionary, int maxNumMultiValues) {
        if (dictionary != null) {
            if (forwardIndex.isSingleValue()) {
                int dictId = forwardIndex.getDictId(docId);
                return dictionary.get(dictId);
            }
            int[] dictIds = new int[maxNumMultiValues];
            int numValues = forwardIndex.getDictIdMV(docId, dictIds);
            Object[] value = new Object[numValues];
            for (int i = 0; i < numValues; ++i) {
                value[i] = dictionary.get(dictIds[i]);
            }
            return value;
        }
        switch (forwardIndex.getValueType()) {
            case INT: {
                return forwardIndex.getInt(docId);
            }
            case LONG: {
                return forwardIndex.getLong(docId);
            }
            case FLOAT: {
                return Float.valueOf(forwardIndex.getFloat(docId));
            }
            case DOUBLE: {
                return forwardIndex.getDouble(docId);
            }
            case STRING: {
                return forwardIndex.getString(docId);
            }
            case BYTES: {
                return forwardIndex.getBytes(docId);
            }
        }
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this._logger.info("Trying to close RealtimeSegmentImpl : {}", (Object)this._segmentName);
        if (this._offHeap && this._numDocsIndexed > 0) {
            int numSeconds = (int)((System.currentTimeMillis() - this._startTimeMillis) / 1000L);
            long totalMemBytes = this._memoryManager.getTotalAllocatedBytes();
            this._logger.info("Segment used {} bytes of memory for {} rows consumed in {} seconds", new Object[]{totalMemBytes, this._numDocsIndexed, numSeconds});
            RealtimeSegmentStatsHistory.SegmentStats segmentStats = new RealtimeSegmentStatsHistory.SegmentStats();
            for (Map.Entry<String, IndexContainer> entry : this._indexContainerMap.entrySet()) {
                String column = entry.getKey();
                BaseOffHeapMutableDictionary dictionary = (BaseOffHeapMutableDictionary)entry.getValue()._dictionary;
                if (dictionary == null) continue;
                RealtimeSegmentStatsHistory.ColumnStats columnStats = new RealtimeSegmentStatsHistory.ColumnStats();
                columnStats.setCardinality(dictionary.length());
                columnStats.setAvgColumnSize(dictionary.getAvgValueSize());
                segmentStats.setColumnStats(column, columnStats);
            }
            segmentStats.setNumRowsConsumed(this._numDocsIndexed);
            segmentStats.setNumRowsIndexed(this._numDocsIndexed);
            segmentStats.setMemUsedBytes(totalMemBytes);
            segmentStats.setNumSeconds(numSeconds);
            this._statsHistory.addSegmentStats(segmentStats);
        }
        if (this._realtimeLuceneReaders != null) {
            this._realtimeLuceneReaders.getLock().lock();
            try {
                this._realtimeLuceneReaders.setSegmentDestroyed();
                this._realtimeLuceneReaders.clearRealtimeReaderList();
            }
            finally {
                this._realtimeLuceneReaders.getLock().unlock();
            }
        }
        for (IndexContainer indexContainer : this._indexContainerMap.values()) {
            indexContainer.close();
        }
        if (this._recordIdMap != null) {
            try {
                this._recordIdMap.close();
            }
            catch (IOException e) {
                this._logger.error("Failed to close the record id map. Continuing with error.", (Throwable)e);
            }
        }
        try {
            this._memoryManager.close();
        }
        catch (IOException e) {
            this._logger.error("Failed to close the memory manager", (Throwable)e);
        }
    }

    public int[] getSortedDocIdIterationOrderWithSortedColumn(String column) {
        IndexContainer indexContainer = this._indexContainerMap.get(column);
        MutableDictionary dictionary = indexContainer._dictionary;
        int numValues = dictionary.length();
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            dictIds[i] = i;
        }
        IntArrays.quickSort((int[])dictIds, (arg_0, arg_1) -> ((MutableDictionary)dictionary).compare(arg_0, arg_1));
        RealtimeInvertedIndexReader invertedIndex = indexContainer._invertedIndex;
        int[] docIds = new int[this._numDocsIndexed];
        int docIdIndex = 0;
        for (int dictId : dictIds) {
            PeekableIntIterator intIterator = invertedIndex.getDocIds(dictId).getIntIterator();
            while (intIterator.hasNext()) {
                docIds[docIdIndex++] = intIterator.next();
            }
        }
        Preconditions.checkState((this._numDocsIndexed == docIdIndex ? 1 : 0) != 0, (String)"The number of documents indexed: %s is not equal to the number of sorted documents: %s", (int)this._numDocsIndexed, (int)docIdIndex);
        return docIds;
    }

    private String buildAllocationContext(String segmentName, String columnName, String indexType) {
        return segmentName + ":" + columnName + indexType;
    }

    private int getOrCreateDocId() {
        if (!this._aggregateMetrics) {
            return this._numDocsIndexed;
        }
        int i = 0;
        int[] dictIds = new int[this._numKeyColumns];
        for (FieldSpec fieldSpec : this._physicalDimensionFieldSpecs) {
            dictIds[i++] = this._indexContainerMap.get((Object)fieldSpec.getName())._dictId;
        }
        for (String string : this._physicalTimeColumnNames) {
            dictIds[i++] = this._indexContainerMap.get((Object)string)._dictId;
        }
        return this._recordIdMap.put(new FixedIntArray(dictIds));
    }

    private IdMap<FixedIntArray> enableMetricsAggregationIfPossible(RealtimeSegmentConfig config, Set<String> noDictionaryColumns) {
        if (!this._aggregateMetrics) {
            this._logger.info("Metrics aggregation is disabled.");
            return null;
        }
        for (FieldSpec fieldSpec : this._physicalMetricFieldSpecs) {
            String metric = fieldSpec.getName();
            if (!noDictionaryColumns.contains(metric)) {
                this._logger.warn("Metrics aggregation cannot be turned ON in presence of dictionary encoded metrics, eg: {}", (Object)metric);
                this._aggregateMetrics = false;
                break;
            }
            if (fieldSpec.isSingleValueField()) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of multi-value metric columns, eg: {}", (Object)metric);
            this._aggregateMetrics = false;
            break;
        }
        for (FieldSpec fieldSpec : this._physicalDimensionFieldSpecs) {
            String dimension = fieldSpec.getName();
            if (noDictionaryColumns.contains(dimension)) {
                this._logger.warn("Metrics aggregation cannot be turned ON in presence of no-dictionary dimensions, eg: {}", (Object)dimension);
                this._aggregateMetrics = false;
                break;
            }
            if (fieldSpec.isSingleValueField()) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of multi-value dimension columns, eg: {}", (Object)dimension);
            this._aggregateMetrics = false;
            break;
        }
        for (String string : this._physicalTimeColumnNames) {
            if (!noDictionaryColumns.contains(string)) continue;
            this._logger.warn("Metrics aggregation cannot be turned ON in presence of no-dictionary datetime/time columns, eg: {}", (Object)string);
            this._aggregateMetrics = false;
            break;
        }
        if (!this._aggregateMetrics) {
            return null;
        }
        int estimatedRowsToIndex = this._statsHistory.isEmpty() ? Math.max(config.getCapacity() / 1000, 1000000) : Math.max(this._statsHistory.getEstimatedRowsToIndex(), 1000000);
        int n = Math.max(estimatedRowsToIndex / 1000, 10000);
        this._logger.info("Initializing metrics update: estimatedRowsToIndex:{}, cacheSize:{}", (Object)estimatedRowsToIndex, (Object)n);
        return new FixedIntArrayOffHeapIdMap(estimatedRowsToIndex, n, this._numKeyColumns, this._memoryManager, RECORD_ID_MAP);
    }

    private class IndexContainer
    implements Closeable {
        final FieldSpec _fieldSpec;
        final PartitionFunction _partitionFunction;
        final Set<Integer> _partitions;
        final NumValuesInfo _numValuesInfo;
        final MutableForwardIndex _forwardIndex;
        final MutableDictionary _dictionary;
        final RealtimeInvertedIndexReader _invertedIndex;
        final InvertedIndexReader _rangeIndex;
        final MutableH3Index _h3Index;
        final RealtimeLuceneTextIndexReader _textIndex;
        final boolean _enableFST;
        final MutableJsonIndex _jsonIndex;
        final BloomFilterReader _bloomFilter;
        final MutableNullValueVector _nullValueVector;
        volatile Comparable _minValue;
        volatile Comparable _maxValue;
        int _dictId = Integer.MIN_VALUE;
        int[] _dictIds;

        IndexContainer(@Nullable FieldSpec fieldSpec, @Nullable PartitionFunction partitionFunction, Set<Integer> partitions, NumValuesInfo numValuesInfo, @Nullable MutableForwardIndex forwardIndex, @Nullable MutableDictionary dictionary, @Nullable RealtimeInvertedIndexReader invertedIndex, @Nullable InvertedIndexReader rangeIndex, RealtimeLuceneTextIndexReader textIndex, @Nullable boolean enableFST, @Nullable MutableJsonIndex jsonIndex, @Nullable MutableH3Index h3Index, @Nullable BloomFilterReader bloomFilter, MutableNullValueVector nullValueVector) {
            this._fieldSpec = fieldSpec;
            this._partitionFunction = partitionFunction;
            this._partitions = partitions;
            this._numValuesInfo = numValuesInfo;
            this._forwardIndex = forwardIndex;
            this._dictionary = dictionary;
            this._invertedIndex = invertedIndex;
            this._rangeIndex = rangeIndex;
            this._h3Index = h3Index;
            this._textIndex = textIndex;
            this._enableFST = enableFST;
            this._jsonIndex = jsonIndex;
            this._bloomFilter = bloomFilter;
            this._nullValueVector = nullValueVector;
        }

        DataSource toDataSource() {
            return new MutableDataSource(this._fieldSpec, MutableSegmentImpl.this._numDocsIndexed, this._numValuesInfo._numValues, this._numValuesInfo._maxNumValuesPerMVEntry, this._partitionFunction, this._partitions, this._minValue, this._maxValue, (ForwardIndexReader)this._forwardIndex, (Dictionary)this._dictionary, this._invertedIndex, this._rangeIndex, this._textIndex, this._enableFST, this._jsonIndex, this._h3Index, this._bloomFilter, this._nullValueVector);
        }

        @Override
        public void close() {
            String column = this._fieldSpec.getName();
            try {
                this._forwardIndex.close();
            }
            catch (Exception e) {
                MutableSegmentImpl.this._logger.error("Caught exception while closing forward index for column: {}, continuing with error", (Object)column, (Object)e);
            }
            if (this._dictionary != null) {
                try {
                    this._dictionary.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing dictionary for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._invertedIndex != null) {
                try {
                    this._invertedIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing inverted index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._rangeIndex != null) {
                try {
                    this._rangeIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing range index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._textIndex != null) {
                try {
                    this._textIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing text index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._jsonIndex != null) {
                try {
                    this._jsonIndex.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing json index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._h3Index != null) {
                try {
                    this._h3Index.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing H3 index for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
            if (this._bloomFilter != null) {
                try {
                    this._bloomFilter.close();
                }
                catch (Exception e) {
                    MutableSegmentImpl.this._logger.error("Caught exception while closing bloom filter for column: {}, continuing with error", (Object)column, (Object)e);
                }
            }
        }
    }

    private static class NumValuesInfo {
        volatile int _numValues = 0;
        volatile int _maxNumValuesPerMVEntry = -1;

        private NumValuesInfo() {
        }

        void updateSVEntry() {
            ++this._numValues;
        }

        void updateMVEntry(int numValuesInMVEntry) {
            this._numValues += numValuesInMVEntry;
            this._maxNumValuesPerMVEntry = Math.max(this._maxNumValuesPerMVEntry, numValuesInMVEntry);
        }
    }
}

