/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import org.apache.pinot.segment.local.io.compression.LZ4Compressor;
import org.apache.pinot.segment.local.io.compression.LZ4Decompressor;
import org.apache.pinot.segment.local.io.compression.PassThroughCompressor;
import org.apache.pinot.segment.local.io.compression.PassThroughDecompressor;
import org.apache.pinot.segment.local.io.compression.SnappyCompressor;
import org.apache.pinot.segment.local.io.compression.SnappyDecompressor;
import org.apache.pinot.segment.local.io.compression.ZstandardCompressor;
import org.apache.pinot.segment.local.io.compression.ZstandardDecompressor;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;

public class ChunkCompressorFactory {
    private ChunkCompressorFactory() {
    }

    public static ChunkCompressor getCompressor(ChunkCompressionType compressionType) {
        switch (compressionType) {
            case PASS_THROUGH: {
                return new PassThroughCompressor();
            }
            case SNAPPY: {
                return new SnappyCompressor();
            }
            case ZSTANDARD: {
                return new ZstandardCompressor();
            }
            case LZ4: {
                return new LZ4Compressor();
            }
        }
        throw new IllegalArgumentException("Illegal compressor name " + compressionType);
    }

    public static ChunkDecompressor getDecompressor(ChunkCompressionType compressionType) {
        switch (compressionType) {
            case PASS_THROUGH: {
                return new PassThroughDecompressor();
            }
            case SNAPPY: {
                return new SnappyDecompressor();
            }
            case ZSTANDARD: {
                return new ZstandardDecompressor();
            }
            case LZ4: {
                return new LZ4Decompressor();
            }
        }
        throw new IllegalArgumentException("Illegal compressor name " + compressionType);
    }
}

