/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;

public class LZ4Decompressor
implements ChunkDecompressor {
    private static LZ4Factory _lz4Factory;

    public LZ4Decompressor() {
        _lz4Factory = LZ4Factory.fastestInstance();
    }

    public int decompress(ByteBuffer compressedInput, ByteBuffer decompressedOutput) throws IOException {
        _lz4Factory.safeDecompressor().decompress(compressedInput, decompressedOutput);
        decompressedOutput.flip();
        return decompressedOutput.limit();
    }
}

