/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.pinot.segment.local.io.compression.ChunkCompressorFactory;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseChunkSVForwardIndexWriter
implements Closeable {
    public static final int DEFAULT_VERSION = 2;
    public static final int CURRENT_VERSION = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseChunkSVForwardIndexWriter.class);
    private static final int FILE_HEADER_ENTRY_CHUNK_OFFSET_SIZE_V1V2 = 4;
    private static final int FILE_HEADER_ENTRY_CHUNK_OFFSET_SIZE_V3 = 8;
    protected final FileChannel _dataFile;
    protected ByteBuffer _header;
    protected final ByteBuffer _chunkBuffer;
    protected final ByteBuffer _compressedBuffer;
    protected final ChunkCompressor _chunkCompressor;
    protected int _chunkSize;
    protected long _dataOffset;
    private final int _headerEntryChunkOffsetSize;

    protected BaseChunkSVForwardIndexWriter(File file, ChunkCompressionType compressionType, int totalDocs, int numDocsPerChunk, int chunkSize, int sizeOfEntry, int version) throws FileNotFoundException {
        Preconditions.checkArgument((version == 2 || version == 3 ? 1 : 0) != 0);
        this._chunkSize = chunkSize;
        this._chunkCompressor = ChunkCompressorFactory.getCompressor(compressionType);
        this._headerEntryChunkOffsetSize = BaseChunkSVForwardIndexWriter.getHeaderEntryChunkOffsetSize(version);
        this._dataOffset = this.writeHeader(compressionType, totalDocs, numDocsPerChunk, sizeOfEntry, version);
        this._chunkBuffer = ByteBuffer.allocateDirect(chunkSize);
        this._compressedBuffer = ByteBuffer.allocateDirect(chunkSize * 2);
        this._dataFile = new RandomAccessFile(file, "rw").getChannel();
    }

    public static int getHeaderEntryChunkOffsetSize(int version) {
        switch (version) {
            case 1: 
            case 2: {
                return 4;
            }
            case 3: {
                return 8;
            }
        }
        throw new IllegalStateException("Invalid version: " + version);
    }

    @Override
    public void close() throws IOException {
        if (this._chunkBuffer.position() > 0) {
            this.writeChunk();
        }
        this._header.flip();
        this._dataFile.write(this._header, 0L);
        this._dataFile.close();
    }

    private int writeHeader(ChunkCompressionType compressionType, int totalDocs, int numDocsPerChunk, int sizeOfEntry, int version) {
        int numChunks = (totalDocs + numDocsPerChunk - 1) / numDocsPerChunk;
        int headerSize = 28 + numChunks * this._headerEntryChunkOffsetSize;
        this._header = ByteBuffer.allocateDirect(headerSize);
        int offset = 0;
        this._header.putInt(version);
        offset += 4;
        this._header.putInt(numChunks);
        offset += 4;
        this._header.putInt(numDocsPerChunk);
        offset += 4;
        this._header.putInt(sizeOfEntry);
        offset += 4;
        if (version > 1) {
            this._header.putInt(totalDocs);
            offset += 4;
            this._header.putInt(compressionType.getValue());
            int dataHeaderStart = (offset += 4) + 4;
            this._header.putInt(dataHeaderStart);
        }
        return headerSize;
    }

    protected void writeChunk() {
        int sizeToWrite;
        this._chunkBuffer.flip();
        try {
            sizeToWrite = this._chunkCompressor.compress(this._chunkBuffer, this._compressedBuffer);
            this._dataFile.write(this._compressedBuffer, this._dataOffset);
            this._compressedBuffer.clear();
        }
        catch (IOException e) {
            LOGGER.error("Exception caught while compressing/writing data chunk", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this._headerEntryChunkOffsetSize == 4) {
            this._header.putInt((int)this._dataOffset);
        } else if (this._headerEntryChunkOffsetSize == 8) {
            this._header.putLong(this._dataOffset);
        }
        this._dataOffset += (long)sizeToWrite;
        this._chunkBuffer.clear();
    }
}

