/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.segment.local.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.segment.local.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class FixedBitMVForwardIndexWriter
implements Closeable {
    private static final int SIZE_OF_INT = 4;
    private static final int NUM_COLS_IN_HEADER = 1;
    private static final int PREFERRED_NUM_VALUES_PER_CHUNK = 2048;
    private PinotDataBuffer indexDataBuffer;
    private PinotDataBuffer chunkOffsetsBuffer;
    private PinotDataBuffer bitsetBuffer;
    private PinotDataBuffer rawDataBuffer;
    private FixedByteValueReaderWriter chunkOffsetsWriter;
    private PinotDataBitSet customBitSet;
    private FixedBitIntReaderWriter rawDataWriter;
    private int numChunks;
    int prevRowStartIndex = 0;
    int prevRowLength = 0;
    private int chunkOffsetHeaderSize;
    private int bitsetSize;
    private long rawDataSize;
    private long totalSize;
    private int docsPerChunk;
    private int _nextDocId = 0;

    public FixedBitMVForwardIndexWriter(File file, int numDocs, int totalNumValues, int numBitsPerValue) throws Exception {
        float averageValuesPerDoc = totalNumValues / numDocs;
        this.docsPerChunk = (int)Math.ceil(2048.0f / averageValuesPerDoc);
        this.numChunks = (numDocs + this.docsPerChunk - 1) / this.docsPerChunk;
        this.chunkOffsetHeaderSize = this.numChunks * 4 * 1;
        this.bitsetSize = (totalNumValues + 7) / 8;
        this.rawDataSize = ((long)totalNumValues * (long)numBitsPerValue + 7L) / 8L;
        this.totalSize = (long)(this.chunkOffsetHeaderSize + this.bitsetSize) + this.rawDataSize;
        Preconditions.checkState((this.totalSize > 0L && this.totalSize < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Total size can not exceed 2GB for file: ", (Object)file.toString());
        this.indexDataBuffer = PinotDataBuffer.mapFile((File)file, (boolean)false, (long)0L, (long)this.totalSize, (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());
        this.chunkOffsetsBuffer = this.indexDataBuffer.view(0L, (long)this.chunkOffsetHeaderSize);
        int bitsetEndPos = this.chunkOffsetHeaderSize + this.bitsetSize;
        this.bitsetBuffer = this.indexDataBuffer.view((long)this.chunkOffsetHeaderSize, (long)bitsetEndPos);
        this.rawDataBuffer = this.indexDataBuffer.view((long)bitsetEndPos, (long)bitsetEndPos + this.rawDataSize);
        this.chunkOffsetsWriter = new FixedByteValueReaderWriter(this.chunkOffsetsBuffer);
        this.customBitSet = new PinotDataBitSet(this.bitsetBuffer);
        this.rawDataWriter = new FixedBitIntReaderWriter(this.rawDataBuffer, totalNumValues, numBitsPerValue);
    }

    public int getChunkOffsetHeaderSize() {
        return this.chunkOffsetHeaderSize;
    }

    public int getBitsetSize() {
        return this.bitsetSize;
    }

    public long getRawDataSize() {
        return this.rawDataSize;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public int getNumChunks() {
        return this.numChunks;
    }

    public int getRowsPerChunk() {
        return this.docsPerChunk;
    }

    @Override
    public void close() throws IOException {
        this.customBitSet.close();
        this.chunkOffsetsWriter.close();
        this.rawDataWriter.close();
        this.indexDataBuffer.close();
        this.chunkOffsetsBuffer = null;
        this.bitsetBuffer = null;
        this.rawDataBuffer = null;
        this.customBitSet = null;
        this.chunkOffsetsWriter = null;
        this.rawDataWriter = null;
    }

    private int updateHeader(int length) {
        int docId;
        int newStartIndex = this.prevRowStartIndex + this.prevRowLength;
        if ((docId = this._nextDocId++) % this.docsPerChunk == 0) {
            int chunkId = docId / this.docsPerChunk;
            this.chunkOffsetsWriter.writeInt(chunkId, newStartIndex);
        }
        this.customBitSet.setBit(newStartIndex);
        this.prevRowStartIndex = newStartIndex;
        this.prevRowLength = length;
        return newStartIndex;
    }

    public void putDictIds(int[] dictIds) {
        this.rawDataWriter.writeInt(this.updateHeader(dictIds.length), dictIds.length, dictIds);
    }
}

