/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import java.io.File;
import java.io.FileNotFoundException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.segment.local.io.writer.impl.BaseChunkSVForwardIndexWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;

@NotThreadSafe
public class FixedByteChunkSVForwardIndexWriter
extends BaseChunkSVForwardIndexWriter {
    private int _chunkDataOffset = 0;

    public FixedByteChunkSVForwardIndexWriter(File file, ChunkCompressionType compressionType, int totalDocs, int numDocsPerChunk, int sizeOfEntry, int writerVersion) throws FileNotFoundException {
        super(file, compressionType, totalDocs, numDocsPerChunk, sizeOfEntry * numDocsPerChunk, sizeOfEntry, writerVersion);
    }

    public void putInt(int value) {
        this._chunkBuffer.putInt(value);
        this._chunkDataOffset += 4;
        this.flushChunkIfNeeded();
    }

    public void putLong(long value) {
        this._chunkBuffer.putLong(value);
        this._chunkDataOffset += 8;
        this.flushChunkIfNeeded();
    }

    public void putFloat(float value) {
        this._chunkBuffer.putFloat(value);
        this._chunkDataOffset += 4;
        this.flushChunkIfNeeded();
    }

    public void putDouble(double value) {
        this._chunkBuffer.putDouble(value);
        this._chunkDataOffset += 8;
        this.flushChunkIfNeeded();
    }

    @Override
    protected void writeChunk() {
        super.writeChunk();
        this._chunkDataOffset = 0;
    }

    private void flushChunkIfNeeded() {
        if (this._chunkDataOffset == this._chunkSize) {
            this.writeChunk();
        }
    }
}

