/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class FixedByteSingleValueMultiColWriter
implements Closeable {
    private final int[] _columnOffsets;
    private final int _rowSizeInBytes;
    private final PinotDataBuffer _dataBuffer;
    private final boolean _shouldCloseDataBuffer;

    public FixedByteSingleValueMultiColWriter(File file, int rows, int cols, int[] columnSizes) throws IOException {
        this._columnOffsets = new int[cols];
        int rowSizeInBytes = 0;
        for (int i = 0; i < cols; ++i) {
            this._columnOffsets[i] = rowSizeInBytes;
            int colSize = columnSizes[i];
            rowSizeInBytes += colSize;
        }
        this._rowSizeInBytes = rowSizeInBytes;
        int totalSize = rowSizeInBytes * rows;
        this._dataBuffer = PinotDataBuffer.mapFile((File)file, (boolean)false, (long)0L, (long)totalSize, (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());
        this._shouldCloseDataBuffer = true;
    }

    public FixedByteSingleValueMultiColWriter(PinotDataBuffer dataBuffer, int cols, int[] columnSizes) {
        this._columnOffsets = new int[cols];
        int rowSizeInBytes = 0;
        for (int i = 0; i < cols; ++i) {
            this._columnOffsets[i] = rowSizeInBytes;
            int colSize = columnSizes[i];
            rowSizeInBytes += colSize;
        }
        this._rowSizeInBytes = rowSizeInBytes;
        this._dataBuffer = dataBuffer;
        this._shouldCloseDataBuffer = false;
    }

    @Override
    public void close() throws IOException {
        if (this._shouldCloseDataBuffer) {
            this._dataBuffer.close();
        }
    }

    public boolean open() {
        return true;
    }

    public void setChar(int row, int col, char ch) {
        int offset = this._rowSizeInBytes * row + this._columnOffsets[col];
        this._dataBuffer.putChar(offset, ch);
    }

    public void setInt(int row, int col, int i) {
        int offset = this._rowSizeInBytes * row + this._columnOffsets[col];
        this._dataBuffer.putInt(offset, i);
    }

    public void setShort(int row, int col, short s) {
        int offset = this._rowSizeInBytes * row + this._columnOffsets[col];
        this._dataBuffer.putShort(offset, s);
    }

    public void setLong(int row, int col, long l) {
        int offset = this._rowSizeInBytes * row + this._columnOffsets[col];
        this._dataBuffer.putLong(offset, l);
    }

    public void setFloat(int row, int col, float f) {
        int offset = this._rowSizeInBytes * row + this._columnOffsets[col];
        this._dataBuffer.putFloat(offset, f);
    }

    public void setDouble(int row, int col, double d) {
        int offset = this._rowSizeInBytes * row + this._columnOffsets[col];
        this._dataBuffer.putDouble(offset, d);
    }

    public void setString(int row, int col, String string) {
        this.setBytes(row, col, StringUtil.encodeUtf8((String)string));
    }

    public void setBytes(int row, int col, byte[] bytes) {
        int offset = this._rowSizeInBytes * row + this._columnOffsets[col];
        this._dataBuffer.readFrom((long)offset, bytes);
    }
}

