/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeSegmentStatsHistory
implements Serializable {
    public static Logger LOGGER = LoggerFactory.getLogger(RealtimeSegmentStatsHistory.class);
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_ROWS_TO_INDEX = 100000;
    private static final String OLD_PACKAGE_FOR_CLASS = "org.apache.pinot.core.realtime.impl";
    private static int MAX_NUM_ENTRIES = 16;
    private int _cursor = 0;
    private SegmentStats[] _entries = new SegmentStats[MAX_NUM_ENTRIES];
    private boolean _isFull = false;
    private String _historyFilePath;
    private static final int DEFAULT_EST_AVG_COL_SIZE = 32;
    private static final int DEFAULT_EST_CARDINALITY = 5000;
    transient int _arraySize;
    transient File _historyFile;
    transient long _minIntervalBetweenUpdatesMillis = 0L;
    transient long _lastUpdateTimeMillis = 0L;

    @VisibleForTesting
    public static int getMaxNumEntries() {
        return MAX_NUM_ENTRIES;
    }

    @VisibleForTesting
    public static int getDefaultEstAvgColSize() {
        return 32;
    }

    @VisibleForTesting
    public static int getDefaultEstCardinality() {
        return 5000;
    }

    @VisibleForTesting
    public static void setMaxNumEntries(int maxNumEntries) {
        MAX_NUM_ENTRIES = maxNumEntries;
    }

    private RealtimeSegmentStatsHistory(String historyFilePath) {
        this._historyFilePath = historyFilePath;
        this._historyFile = new File(this._historyFilePath);
        this.normalize();
    }

    private void normalize() {
        int toCopy;
        if (this._entries.length == MAX_NUM_ENTRIES) {
            this._arraySize = MAX_NUM_ENTRIES;
            return;
        }
        if (this.isFull()) {
            toCopy = Math.min(this._entries.length, MAX_NUM_ENTRIES);
            if (this._entries.length > MAX_NUM_ENTRIES) {
                this._cursor = 0;
            } else {
                this._isFull = false;
                this._cursor = this._entries.length;
            }
        } else {
            toCopy = Math.min(this._cursor, MAX_NUM_ENTRIES);
            if (this._cursor > MAX_NUM_ENTRIES) {
                this._cursor = 0;
                this._isFull = true;
            }
        }
        SegmentStats[] tmp = this._entries;
        this._entries = new SegmentStats[MAX_NUM_ENTRIES];
        for (int i = 0; i < toCopy; ++i) {
            this._entries[i] = tmp[i];
        }
        this._arraySize = this._entries.length;
    }

    public int getCursor() {
        return this._cursor;
    }

    public int getArraySize() {
        return this._arraySize;
    }

    public boolean isFull() {
        return this._isFull;
    }

    public synchronized boolean isEmpty() {
        return this.getNumEntriesToScan() == 0;
    }

    public synchronized void setMinIntervalBetweenUpdatesMillis(long millis) {
        this._minIntervalBetweenUpdatesMillis = millis;
    }

    public synchronized void addSegmentStats(SegmentStats segmentStats) {
        if (this._minIntervalBetweenUpdatesMillis > 0L) {
            long now = System.currentTimeMillis();
            if (now - this._lastUpdateTimeMillis < this._minIntervalBetweenUpdatesMillis) {
                return;
            }
            this._lastUpdateTimeMillis = now;
        }
        this._entries[this._cursor] = segmentStats;
        if (this._cursor >= this._arraySize - 1) {
            this._isFull = true;
        }
        this._cursor = (this._cursor + 1) % this._arraySize;
        this.save();
    }

    public synchronized int getEstimatedCardinality(@Nonnull String columnName) {
        int avgEstimatedCardinality;
        int numEntriesToScan = this.getNumEntriesToScan();
        if (numEntriesToScan == 0) {
            return 5000;
        }
        int totalCardinality = 0;
        int numValidValues = 0;
        for (int i = 0; i < numEntriesToScan; ++i) {
            SegmentStats segmentStats = this.getSegmentStatsAt(i);
            ColumnStats columnStats = segmentStats.getColumnStats(columnName);
            if (columnStats == null) continue;
            totalCardinality += columnStats.getCardinality();
            ++numValidValues;
        }
        if (numValidValues > 0 && (avgEstimatedCardinality = totalCardinality / numValidValues) > 0) {
            return avgEstimatedCardinality;
        }
        return 5000;
    }

    public synchronized int getEstimatedAvgColSize(@Nonnull String columnName) {
        int avgColSize;
        int numEntriesToScan = this.getNumEntriesToScan();
        if (numEntriesToScan == 0) {
            return 32;
        }
        int totalColSize = 0;
        int numValidValues = 0;
        for (int i = 0; i < numEntriesToScan; ++i) {
            SegmentStats segmentStats = this.getSegmentStatsAt(i);
            ColumnStats columnStats = segmentStats.getColumnStats(columnName);
            if (columnStats == null) continue;
            totalColSize += columnStats.getAvgColumnSize();
            ++numValidValues;
        }
        if (numValidValues > 0 && (avgColSize = totalColSize / numValidValues) > 0) {
            return avgColSize;
        }
        return 32;
    }

    public synchronized int getEstimatedRowsToIndex() {
        int numEntriesToScan = this.getNumEntriesToScan();
        if (numEntriesToScan == 0) {
            return 100000;
        }
        long numRowsIndexed = 0L;
        for (int i = 0; i < numEntriesToScan; ++i) {
            SegmentStats segmentStats = this.getSegmentStatsAt(i);
            numRowsIndexed += (long)segmentStats.getNumRowsIndexed();
        }
        return numRowsIndexed > 0L ? (int)(numRowsIndexed / (long)numEntriesToScan) : 100000;
    }

    public synchronized long getLatestSegmentMemoryConsumed() {
        if (this.isEmpty()) {
            return -1L;
        }
        int latestSegmentIndex = (this._cursor + this._arraySize - 1) % this._arraySize;
        SegmentStats stats = this.getSegmentStatsAt(latestSegmentIndex);
        return stats._memUsedBytes;
    }

    public SegmentStats getSegmentStatsAt(int index) {
        return this._entries[index];
    }

    public String toString() {
        return "cursor=" + this.getCursor() + ",numEntries=" + this.getArraySize() + ",isFull=" + this.isFull();
    }

    private void save() {
        try (FileOutputStream os = new FileOutputStream(new File(this._historyFilePath));
             ObjectOutputStream obos = new ObjectOutputStream(os);){
            obos.writeObject(this);
            obos.flush();
            os.flush();
        }
        catch (IOException e) {
            LOGGER.warn("Could not update stats file {}", (Object)this._historyFile, (Object)e);
        }
    }

    public static synchronized RealtimeSegmentStatsHistory deserialzeFrom(File inFile) throws IOException, ClassNotFoundException {
        if (inFile.exists()) {
            try (FileInputStream is = new FileInputStream(inFile);){
                RealtimeSegmentStatsHistory realtimeSegmentStatsHistory;
                try (CustomObjectInputStream obis = new CustomObjectInputStream(is);){
                    RealtimeSegmentStatsHistory history = (RealtimeSegmentStatsHistory)obis.readObject();
                    history.normalize();
                    realtimeSegmentStatsHistory = history;
                }
                return realtimeSegmentStatsHistory;
            }
        }
        return new RealtimeSegmentStatsHistory(inFile.getAbsolutePath());
    }

    private int getNumEntriesToScan() {
        if (this.isFull()) {
            return this.getArraySize();
        }
        return this.getCursor();
    }

    private static class CustomObjectInputStream
    extends ObjectInputStream {
        public CustomObjectInputStream(InputStream in) throws IOException {
            super(in);
            this.enableResolveObject(true);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws SecurityException, IOException, ClassNotFoundException {
            ObjectStreamClass objectStreamClass = super.readClassDescriptor();
            if (objectStreamClass.getName().contains(RealtimeSegmentStatsHistory.OLD_PACKAGE_FOR_CLASS)) {
                objectStreamClass = ObjectStreamClass.lookup(Class.forName(objectStreamClass.getName().replace(RealtimeSegmentStatsHistory.OLD_PACKAGE_FOR_CLASS, RealtimeSegmentStatsHistory.class.getPackage().getName())));
            }
            return objectStreamClass;
        }
    }

    public static class ColumnStats
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int _avgColumnSize;
        private int _cardinality;

        public int getCardinality() {
            return this._cardinality;
        }

        public void setCardinality(int cardinality) {
            this._cardinality = cardinality;
        }

        public int getAvgColumnSize() {
            return this._avgColumnSize;
        }

        public void setAvgColumnSize(int avgColumnSize) {
            this._avgColumnSize = avgColumnSize;
        }

        public String toString() {
            return "cardinality=" + this.getCardinality() + ",avgSize=" + this.getAvgColumnSize();
        }
    }

    public static class SegmentStats
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int _numRowsConsumed;
        private int _numRowsIndexed = 100000;
        private int _numSeconds;
        private long _memUsedBytes;
        private Map<String, ColumnStats> _colNameToStats = new HashMap<String, ColumnStats>();

        public int getNumRowsConsumed() {
            return this._numRowsConsumed;
        }

        public void setNumRowsConsumed(int numRowsConsumed) {
            this._numRowsConsumed = numRowsConsumed;
        }

        public int getNumRowsIndexed() {
            return this._numRowsIndexed;
        }

        public void setNumRowsIndexed(int numRowsIndexed) {
            this._numRowsIndexed = numRowsIndexed;
        }

        public int getNumSeconds() {
            return this._numSeconds;
        }

        public void setNumSeconds(int numSeconds) {
            this._numSeconds = numSeconds;
        }

        public long getMemUsedBytes() {
            return this._memUsedBytes;
        }

        public void setMemUsedBytes(long memUsedBytes) {
            this._memUsedBytes = memUsedBytes;
        }

        public void setColumnStats(@Nonnull String columnName, @Nonnull ColumnStats columnStats) {
            this._colNameToStats.put(columnName, columnStats);
        }

        @Nullable
        public ColumnStats getColumnStats(String columnName) {
            return this._colNameToStats.get(columnName);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("nRows=" + this.getNumRowsConsumed()).append(",nMinutes=" + this.getNumSeconds()).append(",memUsed=" + this.getMemUsedBytes());
            for (Map.Entry<String, ColumnStats> entry : this._colNameToStats.entrySet()) {
                sb.append(",").append(entry.getKey()).append(":").append(entry.getValue().toString());
            }
            return sb.toString();
        }
    }
}

