/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Arrays;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOnHeapMutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class FloatOnHeapMutableDictionary
extends BaseOnHeapMutableDictionary {
    private volatile float _min = Float.MAX_VALUE;
    private volatile float _max = Float.MIN_VALUE;

    public int index(Object value) {
        Float floatValue = (Float)value;
        this.updateMinMax(floatValue.floatValue());
        return this.indexValue(floatValue);
    }

    public int[] index(Object[] values) {
        int numValues = values.length;
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            Float floatValue = (Float)values[i];
            this.updateMinMax(floatValue.floatValue());
            dictIds[i] = this.indexValue(floatValue);
        }
        return dictIds;
    }

    public int compare(int dictId1, int dictId2) {
        return Float.compare(this.getFloatValue(dictId1), this.getFloatValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        if (lower.equals("*")) {
            float upperValue = Float.parseFloat(upper);
            if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    float value = this.getFloatValue(dictId);
                    if (!(value <= upperValue)) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    float value = this.getFloatValue(dictId);
                    if (!(value < upperValue)) continue;
                    dictIds.add(dictId);
                }
            }
        } else if (upper.equals("*")) {
            float lowerValue = Float.parseFloat(lower);
            if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    float value = this.getFloatValue(dictId);
                    if (!(value >= lowerValue)) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    float value = this.getFloatValue(dictId);
                    if (!(value > lowerValue)) continue;
                    dictIds.add(dictId);
                }
            }
        } else {
            float lowerValue = Float.parseFloat(lower);
            float upperValue = Float.parseFloat(upper);
            if (includeLower && includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    float value = this.getFloatValue(dictId);
                    if (!(value >= lowerValue) || !(value <= upperValue)) continue;
                    dictIds.add(dictId);
                }
            } else if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    float value = this.getFloatValue(dictId);
                    if (!(value >= lowerValue) || !(value < upperValue)) continue;
                    dictIds.add(dictId);
                }
            } else if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    float value = this.getFloatValue(dictId);
                    if (!(value > lowerValue) || !(value <= upperValue)) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    float value = this.getFloatValue(dictId);
                    if (!(value > lowerValue) || !(value < upperValue)) continue;
                    dictIds.add(dictId);
                }
            }
        }
        return dictIds;
    }

    public Float getMinVal() {
        return Float.valueOf(this._min);
    }

    public Float getMaxVal() {
        return Float.valueOf(this._max);
    }

    public float[] getSortedValues() {
        int numValues = this.length();
        float[] sortedValues = new float[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getFloatValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.FLOAT;
    }

    public int indexOf(String stringValue) {
        return this.getDictId(Float.valueOf(stringValue));
    }

    public int getIntValue(int dictId) {
        return (int)this.getFloatValue(dictId);
    }

    public long getLongValue(int dictId) {
        return (long)this.getFloatValue(dictId);
    }

    public float getFloatValue(int dictId) {
        return ((Float)this.get(dictId)).floatValue();
    }

    public double getDoubleValue(int dictId) {
        return this.getFloatValue(dictId);
    }

    public String getStringValue(int dictId) {
        return Float.toString(this.getFloatValue(dictId));
    }

    private void updateMinMax(float value) {
        if (value < this._min) {
            this._min = value;
        }
        if (value > this._max) {
            this._max = value;
        }
    }
}

