/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.forward;

import java.io.IOException;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.segment.local.io.readerwriter.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.local.io.writer.impl.MutableOffHeapByteArrayStore;
import org.apache.pinot.segment.spi.index.reader.MutableForwardIndex;
import org.apache.pinot.spi.data.FieldSpec;

public class VarByteSVMutableForwardIndex
implements MutableForwardIndex {
    private final FieldSpec.DataType _valueType;
    private final MutableOffHeapByteArrayStore _byteArrayStore;
    private int _lengthOfShortestElement;
    private int _lengthOfLongestElement;

    public VarByteSVMutableForwardIndex(FieldSpec.DataType valueType, PinotDataBufferMemoryManager memoryManager, String allocationContext, int estimatedMaxNumberOfValues, int estimatedAverageStringLength) {
        this._valueType = valueType;
        this._byteArrayStore = new MutableOffHeapByteArrayStore(memoryManager, allocationContext, estimatedMaxNumberOfValues, estimatedAverageStringLength);
        this._lengthOfShortestElement = Integer.MAX_VALUE;
        this._lengthOfLongestElement = Integer.MIN_VALUE;
    }

    public boolean isDictionaryEncoded() {
        return false;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return this._valueType;
    }

    public int getLengthOfShortestElement() {
        return this._lengthOfShortestElement;
    }

    public int getLengthOfLongestElement() {
        return this._lengthOfLongestElement;
    }

    public String getString(int docId) {
        return StringUtil.decodeUtf8((byte[])this._byteArrayStore.get(docId));
    }

    public byte[] getBytes(int docId) {
        return this._byteArrayStore.get(docId);
    }

    public void setString(int docId, String value) {
        this.setBytes(docId, StringUtil.encodeUtf8((String)value));
    }

    public void setBytes(int docId, byte[] value) {
        this._byteArrayStore.add(value);
        this._lengthOfLongestElement = Math.max(this._lengthOfLongestElement, value.length);
        this._lengthOfShortestElement = Math.min(this._lengthOfShortestElement, value.length);
    }

    public void close() throws IOException {
        this._byteArrayStore.close();
    }
}

