/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneIndexReaderRefreshThread;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneTextIndexReader;

public class RealtimeLuceneIndexRefreshState {
    private static RealtimeLuceneIndexRefreshState _singletonInstance;
    private static RealtimeLuceneIndexReaderRefreshThread _realtimeRefreshThread;
    private final Lock _mutex = new ReentrantLock();
    private final Condition _conditionVariable = this._mutex.newCondition();
    private static ConcurrentLinkedQueue<RealtimeLuceneReaders> _luceneRealtimeReaders;

    private RealtimeLuceneIndexRefreshState() {
        _luceneRealtimeReaders = new ConcurrentLinkedQueue();
    }

    public void start() {
        _realtimeRefreshThread = new RealtimeLuceneIndexReaderRefreshThread(_luceneRealtimeReaders, this._mutex, this._conditionVariable);
        Thread t = new Thread(_realtimeRefreshThread);
        t.start();
    }

    public void stop() {
        _realtimeRefreshThread.setStopped();
        this._mutex.lock();
        this._conditionVariable.signal();
        this._mutex.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RealtimeLuceneIndexRefreshState getInstance() {
        if (_singletonInstance != null) return _singletonInstance;
        Class<RealtimeLuceneIndexRefreshState> clazz = RealtimeLuceneIndexRefreshState.class;
        synchronized (RealtimeLuceneIndexRefreshState.class) {
            if (_singletonInstance != null) return _singletonInstance;
            _singletonInstance = new RealtimeLuceneIndexRefreshState();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _singletonInstance;
        }
    }

    public void addRealtimeReadersToQueue(RealtimeLuceneReaders readersForRealtimeSegment) {
        this._mutex.lock();
        _luceneRealtimeReaders.offer(readersForRealtimeSegment);
        this._conditionVariable.signal();
        this._mutex.unlock();
    }

    public static class RealtimeLuceneReaders {
        private final String segmentName;
        private final Lock lock;
        private boolean segmentDestroyed;
        private final List<RealtimeLuceneTextIndexReader> realtimeLuceneReaders;

        public RealtimeLuceneReaders(String segmentName) {
            this.segmentName = segmentName;
            this.lock = new ReentrantLock();
            this.segmentDestroyed = false;
            this.realtimeLuceneReaders = new LinkedList<RealtimeLuceneTextIndexReader>();
        }

        public void addReader(RealtimeLuceneTextIndexReader realtimeLuceneTextIndexReader) {
            this.realtimeLuceneReaders.add(realtimeLuceneTextIndexReader);
        }

        public void setSegmentDestroyed() {
            this.segmentDestroyed = true;
        }

        public Lock getLock() {
            return this.lock;
        }

        public String getSegmentName() {
            return this.segmentName;
        }

        public List<RealtimeLuceneTextIndexReader> getRealtimeLuceneReaders() {
            return this.realtimeLuceneReaders;
        }

        public void clearRealtimeReaderList() {
            this.realtimeLuceneReaders.clear();
        }

        boolean isSegmentDestroyed() {
            return this.segmentDestroyed;
        }
    }
}

