/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import java.io.File;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeLuceneDocIdCollector;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RealtimeLuceneTextIndexReader
implements TextIndexReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealtimeLuceneTextIndexReader.class);
    private final QueryParser _queryParser;
    private final LuceneTextIndexCreator _indexCreator;
    private SearcherManager _searcherManager;
    private final String _column;
    private final String _segmentName;

    public RealtimeLuceneTextIndexReader(String column, File segmentIndexDir, String segmentName) {
        this._column = column;
        this._segmentName = segmentName;
        try {
            this._indexCreator = new LuceneTextIndexCreator(column, new File(segmentIndexDir.getAbsolutePath() + "/" + segmentName), false);
            IndexWriter indexWriter = this._indexCreator.getIndexWriter();
            this._searcherManager = new SearcherManager(indexWriter, false, false, null);
        }
        catch (Exception e) {
            LOGGER.error("Failed to instantiate realtime Lucene index reader for column {}, exception {}", (Object)column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        StandardAnalyzer analyzer = new StandardAnalyzer();
        this._queryParser = new QueryParser(column, (Analyzer)analyzer);
    }

    public void add(String document) {
        this._indexCreator.add(document);
    }

    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MutableRoaringBitmap getDocIds(String searchQuery) {
        MutableRoaringBitmap mutableRoaringBitmap;
        MutableRoaringBitmap docIDs = new MutableRoaringBitmap();
        RealtimeLuceneDocIdCollector docIDCollector = new RealtimeLuceneDocIdCollector(docIDs);
        IndexSearcher indexSearcher = null;
        try {
            Query query = this._queryParser.parse(searchQuery);
            indexSearcher = (IndexSearcher)this._searcherManager.acquire();
            indexSearcher.search(query, (Collector)docIDCollector);
            mutableRoaringBitmap = this.getPinotDocIds(indexSearcher, docIDs);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Failed while searching the realtime text index for column {}, search query {}, exception {}", new Object[]{this._column, searchQuery, e.getMessage()});
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (indexSearcher == null) throw throwable;
                    this._searcherManager.release(indexSearcher);
                    throw throwable;
                }
                catch (Exception e2) {
                    LOGGER.error("Failed while releasing the searcher manager for realtime text index for column {}, exception {}", (Object)this._column, (Object)e2.getMessage());
                }
                throw throwable;
            }
        }
        try {
            if (indexSearcher == null) return mutableRoaringBitmap;
            this._searcherManager.release((Object)indexSearcher);
            return mutableRoaringBitmap;
        }
        catch (Exception e) {
            LOGGER.error("Failed while releasing the searcher manager for realtime text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
        }
        return mutableRoaringBitmap;
    }

    private MutableRoaringBitmap getPinotDocIds(IndexSearcher indexSearcher, MutableRoaringBitmap luceneDocIds) {
        PeekableIntIterator luceneDocIDIterator = luceneDocIds.getIntIterator();
        MutableRoaringBitmap actualDocIDs = new MutableRoaringBitmap();
        try {
            while (luceneDocIDIterator.hasNext()) {
                int luceneDocId = luceneDocIDIterator.next();
                Document document = indexSearcher.doc(luceneDocId);
                int pinotDocId = Integer.valueOf(document.get("DocID"));
                actualDocIDs.add(pinotDocId);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failure while retrieving document from index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return actualDocIDs;
    }

    public void close() {
        try {
            this._searcherManager.close();
            this._searcherManager = null;
            this._indexCreator.close();
        }
        catch (Exception e) {
            LOGGER.error("Failed while closing the realtime text index for column {}, exception {}", (Object)this._column, (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    SearcherManager getSearcherManager() {
        return this._searcherManager;
    }
}

