/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.function.scalar.JsonFunctions;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.ComplexTypeConfig;
import org.apache.pinot.spi.data.readers.GenericRow;

public class ComplexTypeTransformer
implements RecordTransformer {
    public static final String DEFAULT_DELIMITER = ".";
    public static final ComplexTypeConfig.CollectionNotUnnestedToJson DEFAULT_COLLECTION_TO_JSON_MODE = ComplexTypeConfig.CollectionNotUnnestedToJson.NON_PRIMITIVE;
    private final List<String> _fieldsToUnnest;
    private final String _delimiter;
    private final ComplexTypeConfig.CollectionNotUnnestedToJson _collectionNotUnnestedToJson;

    public ComplexTypeTransformer(TableConfig tableConfig) {
        this(ComplexTypeTransformer.parseFieldsToUnnest(tableConfig), ComplexTypeTransformer.parseDelimiter(tableConfig), ComplexTypeTransformer.parseCollectionNotUnnestedToJson(tableConfig));
    }

    @VisibleForTesting
    ComplexTypeTransformer(List<String> fieldsToUnnest, String delimiter) {
        this(fieldsToUnnest, delimiter, DEFAULT_COLLECTION_TO_JSON_MODE);
    }

    @VisibleForTesting
    ComplexTypeTransformer(List<String> fieldsToUnnest, String delimiter, ComplexTypeConfig.CollectionNotUnnestedToJson collectionNotUnnestedToJson) {
        this._fieldsToUnnest = new ArrayList<String>(fieldsToUnnest);
        this._delimiter = delimiter;
        this._collectionNotUnnestedToJson = collectionNotUnnestedToJson;
        Collections.sort(this._fieldsToUnnest);
    }

    private static List<String> parseFieldsToUnnest(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig().getFieldsToUnnest() != null) {
            return tableConfig.getIngestionConfig().getComplexTypeConfig().getFieldsToUnnest();
        }
        return new ArrayList<String>();
    }

    private static String parseDelimiter(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig().getDelimiter() != null) {
            return tableConfig.getIngestionConfig().getComplexTypeConfig().getDelimiter();
        }
        return DEFAULT_DELIMITER;
    }

    @Nullable
    public static ComplexTypeTransformer getComplexTypeTransformer(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null) {
            return new ComplexTypeTransformer(tableConfig);
        }
        return null;
    }

    private static ComplexTypeConfig.CollectionNotUnnestedToJson parseCollectionNotUnnestedToJson(TableConfig tableConfig) {
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig() != null && tableConfig.getIngestionConfig().getComplexTypeConfig().getCollectionNotUnnestedToJson() != null) {
            return tableConfig.getIngestionConfig().getComplexTypeConfig().getCollectionNotUnnestedToJson();
        }
        return DEFAULT_COLLECTION_TO_JSON_MODE;
    }

    @Override
    @Nullable
    public GenericRow transform(GenericRow record) {
        this.flattenMap(record, new ArrayList<String>(record.getFieldToValueMap().keySet()));
        for (String collection : this._fieldsToUnnest) {
            this.unnestCollection(record, collection);
        }
        return record;
    }

    private GenericRow unnestCollection(GenericRow record, String column) {
        Object value = record.getValue("$MULTIPLE_RECORDS_KEY$");
        if (value == null) {
            ArrayList<GenericRow> list = new ArrayList<GenericRow>();
            this.unnestCollection(record, column, list);
            record.putValue("$MULTIPLE_RECORDS_KEY$", list);
        } else {
            Collection records = (Collection)value;
            ArrayList<GenericRow> list = new ArrayList<GenericRow>();
            for (GenericRow innerRecord : records) {
                this.unnestCollection(innerRecord, column, list);
            }
            record.putValue("$MULTIPLE_RECORDS_KEY$", list);
        }
        return record;
    }

    private void unnestCollection(GenericRow record, String column, List<GenericRow> list) {
        block7: {
            Object value;
            block8: {
                block6: {
                    value = record.removeValue(column);
                    if (value != null) break block6;
                    list.add(record);
                    break block7;
                }
                if (!(value instanceof Collection)) break block8;
                if (((Collection)value).isEmpty()) {
                    list.add(record);
                } else {
                    for (Object obj : (Collection)value) {
                        GenericRow copy = this.flattenCollectionItem(record, obj, column);
                        list.add(copy);
                    }
                }
                break block7;
            }
            if (!ComplexTypeTransformer.isArray(value)) break block7;
            if (((Object[])value).length == 0) {
                list.add(record);
            } else {
                for (Object obj : (Object[])value) {
                    GenericRow copy = this.flattenCollectionItem(record, obj, column);
                    list.add(copy);
                }
            }
        }
    }

    private GenericRow flattenCollectionItem(GenericRow record, Object obj, String column) {
        GenericRow copy = record.copy();
        if (obj instanceof Map) {
            Map map = (Map)obj;
            for (Map.Entry entry : map.entrySet()) {
                String flattenName = this.concat(column, (String)entry.getKey());
                copy.putValue(flattenName, entry.getValue());
            }
        } else {
            copy.putValue(column, obj);
        }
        return copy;
    }

    @VisibleForTesting
    protected void flattenMap(GenericRow record, List<String> columns) {
        for (String column : columns) {
            String jsonString;
            Object value = record.getValue(column);
            if (value instanceof Map) {
                Map map = (Map)record.removeValue(column);
                ArrayList mapColumns = new ArrayList();
                for (Map.Entry entry : new ArrayList(map.entrySet())) {
                    String flattenName = this.concat(column, (String)entry.getKey());
                    Object nestedValue = entry.getValue();
                    record.putValue(flattenName, nestedValue);
                    if (!(nestedValue instanceof Map) && !(nestedValue instanceof Collection) && !ComplexTypeTransformer.isArray(nestedValue)) continue;
                    mapColumns.add(flattenName);
                }
                this.flattenMap(record, mapColumns);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                if (this._fieldsToUnnest.contains(column)) {
                    for (Object inner : collection) {
                        if (!(inner instanceof Map)) continue;
                        Map innerMap = (Map)inner;
                        this.flattenMap(column, innerMap, new ArrayList<String>(innerMap.keySet()));
                    }
                    continue;
                }
                if (!this.shallConvertToJson(collection)) continue;
                try {
                    jsonString = JsonFunctions.jsonFormat((Object)collection);
                    record.putValue(column, (Object)jsonString);
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(String.format("Caught exception while converting value to JSON string %s", value), e);
                }
            }
            if (!ComplexTypeTransformer.isArray(value)) continue;
            Object[] array = (Object[])value;
            if (this._fieldsToUnnest.contains(column)) {
                for (Object inner : array) {
                    if (!(inner instanceof Map)) continue;
                    Map innerMap = (Map)inner;
                    this.flattenMap(column, innerMap, new ArrayList<String>(innerMap.keySet()));
                }
                continue;
            }
            if (!this.shallConvertToJson(array)) continue;
            try {
                jsonString = JsonFunctions.jsonFormat((Object)array);
                record.putValue(column, (Object)jsonString);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Caught exception while converting value to JSON string %s", value), e);
            }
        }
    }

    private boolean containPrimitives(Object[] value) {
        if (value.length == 0) {
            return true;
        }
        Object element = value[0];
        return !(element instanceof Map) && !(element instanceof Collection) && !ComplexTypeTransformer.isArray(element);
    }

    private boolean containPrimitives(Collection value) {
        if (value.isEmpty()) {
            return true;
        }
        Object element = value.iterator().next();
        return !(element instanceof Map) && !(element instanceof Collection) && !ComplexTypeTransformer.isArray(element);
    }

    protected static boolean isArray(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj.getClass().isArray();
    }

    private void flattenMap(String path, Map<String, Object> map, Collection<String> fields) {
        for (String field : fields) {
            String jsonString;
            Object value = map.get(field);
            String concatName = this.concat(path, field);
            if (value instanceof Map) {
                Map innerMap = (Map)map.remove(field);
                ArrayList innerMapFields = new ArrayList();
                for (Map.Entry innerEntry : new ArrayList(innerMap.entrySet())) {
                    Object innerValue = innerEntry.getValue();
                    String innerCancatName = this.concat(field, (String)innerEntry.getKey());
                    map.put(innerCancatName, innerEntry.getValue());
                    if (!(innerValue instanceof Map) && !(innerValue instanceof Collection) && !ComplexTypeTransformer.isArray(innerValue)) continue;
                    innerMapFields.add(innerCancatName);
                }
                if (innerMapFields.isEmpty()) continue;
                this.flattenMap(concatName, map, innerMapFields);
                continue;
            }
            if (value instanceof Collection && this._fieldsToUnnest.contains(concatName)) {
                Collection collection = (Collection)value;
                if (this._fieldsToUnnest.contains(concatName)) {
                    for (Object inner : (Collection)value) {
                        if (!(inner instanceof Map)) continue;
                        Map innerMap = (Map)inner;
                        this.flattenMap(concatName, innerMap, new ArrayList<String>(innerMap.keySet()));
                    }
                    continue;
                }
                if (!this.shallConvertToJson(collection)) continue;
                try {
                    jsonString = JsonFunctions.jsonFormat((Object)collection);
                    map.put(field, jsonString);
                    continue;
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(String.format("Caught exception while converting value to JSON string %s", value), e);
                }
            }
            if (!ComplexTypeTransformer.isArray(value)) continue;
            Object[] array = (Object[])value;
            if (this._fieldsToUnnest.contains(concatName)) {
                for (Object inner : (Object[])value) {
                    if (!(inner instanceof Map)) continue;
                    Map innerMap = (Map)inner;
                    this.flattenMap(concatName, innerMap, new ArrayList<String>(innerMap.keySet()));
                }
                continue;
            }
            if (!this.shallConvertToJson(array)) continue;
            try {
                jsonString = JsonFunctions.jsonFormat((Object)array);
                map.put(field, jsonString);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(String.format("Caught exception while converting value to JSON string %s", value), e);
            }
        }
    }

    private boolean shallConvertToJson(Object[] value) {
        switch (this._collectionNotUnnestedToJson) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case NON_PRIMITIVE: {
                return !this.containPrimitives(value);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported collectionNotUnnestedToJson %s", this._collectionNotUnnestedToJson));
    }

    private boolean shallConvertToJson(Collection value) {
        switch (this._collectionNotUnnestedToJson) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case NON_PRIMITIVE: {
                return !this.containPrimitives(value);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported collectionNotUnnestedToJson %s", this._collectionNotUnnestedToJson));
    }

    private String concat(String left, String right) {
        return String.join((CharSequence)this._delimiter, left, right);
    }
}

