/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator;

import org.apache.pinot.common.Utils;
import org.apache.pinot.segment.local.indexsegment.mutable.IntermediateSegment;
import org.apache.pinot.segment.local.segment.creator.IntermediateSegmentStatsContainer;
import org.apache.pinot.segment.local.segment.readers.IntermediateSegmentRecordReader;
import org.apache.pinot.segment.spi.creator.SegmentCreationDataSource;
import org.apache.pinot.segment.spi.creator.SegmentPreIndexStatsContainer;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateSegmentSegmentCreationDataSource
implements SegmentCreationDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateSegmentSegmentCreationDataSource.class);
    private final IntermediateSegment _intermediateSegment;
    private final IntermediateSegmentRecordReader _intermediateSegmentRecordReader;

    public IntermediateSegmentSegmentCreationDataSource(IntermediateSegmentRecordReader intermediateSegmentRecordReader) {
        this._intermediateSegmentRecordReader = intermediateSegmentRecordReader;
        this._intermediateSegment = this._intermediateSegmentRecordReader.getIntermediateSegment();
    }

    public SegmentPreIndexStatsContainer gatherStats(StatsCollectorConfig statsCollectorConfig) {
        return new IntermediateSegmentStatsContainer(this._intermediateSegment);
    }

    public RecordReader getRecordReader() {
        try {
            this._intermediateSegmentRecordReader.rewind();
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while rewinding record reader", (Throwable)e);
            Utils.rethrowException((Throwable)e);
        }
        return this._intermediateSegmentRecordReader;
    }
}

