/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.common.utils.FileUtils;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueFixedByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueVarByteRawIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.OffHeapBitmapInvertedIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.OnHeapBitmapInvertedIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.BaseH3IndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.OffHeapH3IndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.OnHeapH3IndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.BaseJsonIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.OffHeapJsonIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.OnHeapJsonIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.inv.text.LuceneFSTIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.nullvalue.NullValueVectorCreator;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.segment.spi.creator.SegmentCreator;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.creator.GeoSpatialIndexCreator;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.creator.JsonIndexCreator;
import org.apache.pinot.segment.spi.index.creator.SegmentIndexCreationInfo;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.index.creator.TextIndexType;
import org.apache.pinot.segment.spi.index.reader.H3IndexResolution;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.TimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentColumnarIndexCreator
implements SegmentCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentColumnarIndexCreator.class);
    private static final int METADATA_PROPERTY_LENGTH_LIMIT = 512;
    private SegmentGeneratorConfig config;
    private Map<String, ColumnIndexCreationInfo> indexCreationInfoMap;
    private final Map<String, SegmentDictionaryCreator> _dictionaryCreatorMap = new HashMap<String, SegmentDictionaryCreator>();
    private final Map<String, ForwardIndexCreator> _forwardIndexCreatorMap = new HashMap<String, ForwardIndexCreator>();
    private final Map<String, DictionaryBasedInvertedIndexCreator> _invertedIndexCreatorMap = new HashMap<String, DictionaryBasedInvertedIndexCreator>();
    private final Map<String, TextIndexCreator> _textIndexCreatorMap = new HashMap<String, TextIndexCreator>();
    private final Map<String, TextIndexCreator> _fstIndexCreatorMap = new HashMap<String, TextIndexCreator>();
    private final Map<String, JsonIndexCreator> _jsonIndexCreatorMap = new HashMap<String, JsonIndexCreator>();
    private final Map<String, GeoSpatialIndexCreator> _h3IndexCreatorMap = new HashMap<String, GeoSpatialIndexCreator>();
    private final Map<String, NullValueVectorCreator> _nullValueVectorCreatorMap = new HashMap<String, NullValueVectorCreator>();
    private String segmentName;
    private Schema schema;
    private File _indexDir;
    private int totalDocs;
    private int docIdCounter;
    private boolean _nullHandlingEnabled;
    private Map<String, Map<String, String>> _columnProperties;

    public void init(SegmentGeneratorConfig segmentCreationSpec, SegmentIndexCreationInfo segmentIndexCreationInfo, Map<String, ColumnIndexCreationInfo> indexCreationInfoMap, Schema schema, File outDir) throws Exception {
        this.docIdCounter = 0;
        this.config = segmentCreationSpec;
        this.indexCreationInfoMap = indexCreationInfoMap;
        this._columnProperties = segmentCreationSpec.getColumnProperties();
        Preconditions.checkState((!outDir.exists() ? 1 : 0) != 0, (String)"Segment output directory: %s already exists", (Object)outDir);
        Preconditions.checkState((boolean)outDir.mkdirs(), (String)"Failed to create output directory: %s", (Object)outDir);
        this._indexDir = outDir;
        this.schema = schema;
        this.totalDocs = segmentIndexCreationInfo.getTotalDocs();
        if (this.totalDocs == 0) {
            return;
        }
        Collection fieldSpecs = schema.getAllFieldSpecs();
        HashSet<Object> invertedIndexColumns = new HashSet<Object>();
        for (Object columnName : this.config.getInvertedIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn((String)columnName), (String)"Cannot create inverted index for column: %s because it is not in schema", (Object)columnName);
            invertedIndexColumns.add(columnName);
        }
        HashSet<Object> textIndexColumns = new HashSet<Object>();
        for (Object columnName : this.config.getTextIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn((String)columnName), (String)"Cannot create text index for column: %s because it is not in schema", (Object)columnName);
            textIndexColumns.add(columnName);
        }
        HashSet<Object> fstIndexColumns = new HashSet<Object>();
        for (Object columnName : this.config.getFSTIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn((String)columnName), (String)"Cannot create FST index for column: %s because it is not in schema", (Object)columnName);
            fstIndexColumns.add(columnName);
        }
        HashSet<String> jsonIndexColumns = new HashSet<String>();
        for (String columnName : this.config.getJsonIndexCreationColumns()) {
            Preconditions.checkState((boolean)schema.hasColumn(columnName), (String)"Cannot create text index for column: %s because it is not in schema", (Object)columnName);
            jsonIndexColumns.add(columnName);
        }
        Map h3IndexConfigs = this.config.getH3IndexConfigs();
        for (String columnName : h3IndexConfigs.keySet()) {
            Preconditions.checkState((boolean)schema.hasColumn(columnName), (String)"Cannot create H3 index for column: %s because it is not in schema", (Object)columnName);
        }
        for (FieldSpec fieldSpec : fieldSpecs) {
            H3IndexConfig h3IndexConfig;
            if (fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
            ColumnIndexCreationInfo indexCreationInfo = indexCreationInfoMap.get(columnName);
            Preconditions.checkNotNull((Object)indexCreationInfo, (String)"Missing index creation info for column: %s", (Object)columnName);
            boolean dictEnabledColumn = this.createDictionaryForColumn(indexCreationInfo, segmentCreationSpec, fieldSpec);
            if (dictEnabledColumn) {
                SegmentDictionaryCreator dictionaryCreator = new SegmentDictionaryCreator(indexCreationInfo.getSortedUniqueElementsArray(), fieldSpec, this._indexDir, indexCreationInfo.isUseVarLengthDictionary());
                this._dictionaryCreatorMap.put(columnName, dictionaryCreator);
                try {
                    dictionaryCreator.build();
                }
                catch (Exception e) {
                    LOGGER.error("Error building dictionary for field: {}, cardinality: {}, number of bytes per entry: {}", new Object[]{fieldSpec.getName(), indexCreationInfo.getDistinctValueCount(), dictionaryCreator.getNumBytesPerEntry()});
                    throw e;
                }
                int cardinality = indexCreationInfo.getDistinctValueCount();
                if (fieldSpec.isSingleValueField()) {
                    if (indexCreationInfo.isSorted()) {
                        this._forwardIndexCreatorMap.put(columnName, new SingleValueSortedForwardIndexCreator(this._indexDir, columnName, cardinality));
                    } else {
                        this._forwardIndexCreatorMap.put(columnName, new SingleValueUnsortedForwardIndexCreator(this._indexDir, columnName, cardinality, this.totalDocs));
                    }
                } else {
                    this._forwardIndexCreatorMap.put(columnName, new MultiValueUnsortedForwardIndexCreator(this._indexDir, columnName, cardinality, this.totalDocs, indexCreationInfo.getTotalNumberOfEntries()));
                }
                if (invertedIndexColumns.contains(columnName) && !indexCreationInfo.isSorted()) {
                    if (segmentCreationSpec.isOnHeap()) {
                        this._invertedIndexCreatorMap.put(columnName, new OnHeapBitmapInvertedIndexCreator(this._indexDir, columnName, cardinality));
                    } else {
                        this._invertedIndexCreatorMap.put(columnName, new OffHeapBitmapInvertedIndexCreator(this._indexDir, fieldSpec, cardinality, this.totalDocs, indexCreationInfo.getTotalNumberOfEntries()));
                    }
                }
            } else {
                Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (String)"Cannot create raw index for multi-value column: %s", (Object)columnName);
                Preconditions.checkState((!invertedIndexColumns.contains(columnName) ? 1 : 0) != 0, (String)"Cannot create inverted index for raw index column: %s", (Object)columnName);
                ChunkCompressionType compressionType = this.getColumnCompressionType(segmentCreationSpec, fieldSpec);
                boolean deriveNumDocsPerChunk = SegmentColumnarIndexCreator.shouldDeriveNumDocsPerChunk(columnName, segmentCreationSpec.getColumnProperties());
                int writerVersion = SegmentColumnarIndexCreator.rawIndexWriterVersion(columnName, segmentCreationSpec.getColumnProperties());
                this._forwardIndexCreatorMap.put(columnName, SegmentColumnarIndexCreator.getRawIndexCreatorForColumn(this._indexDir, compressionType, columnName, storedType, this.totalDocs, indexCreationInfo.getLengthOfLongestEntry(), deriveNumDocsPerChunk, writerVersion));
            }
            if (textIndexColumns.contains(columnName)) {
                Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (Object)"Text index is currently only supported on single-value columns");
                Preconditions.checkState((storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Text index is currently only supported on STRING type columns");
                this._textIndexCreatorMap.put(columnName, new LuceneTextIndexCreator(columnName, this._indexDir, true));
            }
            if (fstIndexColumns.contains(columnName)) {
                Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (Object)"FST index is currently only supported on single-value columns");
                Preconditions.checkState((storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"FST index is currently only supported on STRING type columns");
                Preconditions.checkState((boolean)dictEnabledColumn, (Object)"FST index is currently only supported on dictionary-encoded columns");
                this._fstIndexCreatorMap.put(columnName, new LuceneFSTIndexCreator(this._indexDir, columnName, (String[])indexCreationInfo.getSortedUniqueElementsArray()));
            }
            if (jsonIndexColumns.contains(columnName)) {
                Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (Object)"Json index is currently only supported on single-value columns");
                Preconditions.checkState((storedType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Json index is currently only supported on STRING columns");
                BaseJsonIndexCreator jsonIndexCreator = segmentCreationSpec.isOnHeap() ? new OnHeapJsonIndexCreator(this._indexDir, columnName) : new OffHeapJsonIndexCreator(this._indexDir, columnName);
                this._jsonIndexCreatorMap.put(columnName, jsonIndexCreator);
            }
            if ((h3IndexConfig = (H3IndexConfig)h3IndexConfigs.get(columnName)) != null) {
                Preconditions.checkState((boolean)fieldSpec.isSingleValueField(), (Object)"H3 index is currently only supported on single-value columns");
                Preconditions.checkState((storedType == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"H3 index is currently only supported on BYTES columns");
                H3IndexResolution resolution = h3IndexConfig.getResolution();
                BaseH3IndexCreator h3IndexCreator = segmentCreationSpec.isOnHeap() ? new OnHeapH3IndexCreator(this._indexDir, columnName, resolution) : new OffHeapH3IndexCreator(this._indexDir, columnName, resolution);
                this._h3IndexCreatorMap.put(columnName, h3IndexCreator);
            }
            this._nullHandlingEnabled = this.config.isNullHandlingEnabled();
            if (!this._nullHandlingEnabled) continue;
            this._nullValueVectorCreatorMap.put(columnName, new NullValueVectorCreator(this._indexDir, columnName));
        }
    }

    public static boolean shouldDeriveNumDocsPerChunk(String columnName, Map<String, Map<String, String>> columnProperties) {
        if (columnProperties != null) {
            Map<String, String> properties = columnProperties.get(columnName);
            return properties != null && Boolean.parseBoolean(properties.get(FieldConfig.DERIVE_NUM_DOCS_PER_CHUNK_RAW_INDEX_KEY));
        }
        return false;
    }

    public static int rawIndexWriterVersion(String columnName, Map<String, Map<String, String>> columnProperties) {
        if (columnProperties != null && columnProperties.get(columnName) != null) {
            Map<String, String> properties = columnProperties.get(columnName);
            String version = properties.get(FieldConfig.RAW_INDEX_WRITER_VERSION);
            if (version == null) {
                return 2;
            }
            return Integer.parseInt(version);
        }
        return 2;
    }

    private ChunkCompressionType getColumnCompressionType(SegmentGeneratorConfig segmentCreationSpec, FieldSpec fieldSpec) {
        ChunkCompressionType compressionType = (ChunkCompressionType)segmentCreationSpec.getRawIndexCompressionType().get(fieldSpec.getName());
        if (compressionType == null) {
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) {
                return ChunkCompressionType.PASS_THROUGH;
            }
            return ChunkCompressionType.SNAPPY;
        }
        return compressionType;
    }

    private boolean createDictionaryForColumn(ColumnIndexCreationInfo info, SegmentGeneratorConfig config, FieldSpec spec) {
        String column = spec.getName();
        if (config.getRawIndexCreationColumns().contains(column) || config.getRawIndexCompressionType().containsKey(column)) {
            if (!spec.isSingleValueField()) {
                throw new RuntimeException("Creation of indices without dictionaries is supported for single valued columns only.");
            }
            return false;
        }
        return info.isCreateDictionary();
    }

    public void indexRow(GenericRow row) throws IOException {
        for (Map.Entry<String, ForwardIndexCreator> entry : this._forwardIndexCreatorMap.entrySet()) {
            String columnName = entry.getKey();
            ForwardIndexCreator forwardIndexCreator = entry.getValue();
            Object columnValueToIndex = row.getValue(columnName);
            if (columnValueToIndex == null) {
                throw new RuntimeException("Null value for column:" + columnName);
            }
            boolean isSingleValue = this.schema.getFieldSpecFor(columnName).isSingleValueField();
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(columnName);
            if (isSingleValue) {
                GeoSpatialIndexCreator h3IndexCreator;
                JsonIndexCreator jsonIndexCreator;
                TextIndexCreator textIndexCreator = this._textIndexCreatorMap.get(columnName);
                if (textIndexCreator != null) {
                    textIndexCreator.add((String)columnValueToIndex);
                }
                if ((jsonIndexCreator = this._jsonIndexCreatorMap.get(columnName)) != null) {
                    jsonIndexCreator.add((String)columnValueToIndex);
                }
                if ((h3IndexCreator = this._h3IndexCreatorMap.get(columnName)) != null) {
                    h3IndexCreator.add(GeometrySerializer.deserialize((byte[])columnValueToIndex));
                }
                if (dictionaryCreator != null) {
                    int dictId = dictionaryCreator.indexOfSV(columnValueToIndex);
                    forwardIndexCreator.putDictId(dictId);
                    DictionaryBasedInvertedIndexCreator invertedIndexCreator = this._invertedIndexCreatorMap.get(columnName);
                    if (invertedIndexCreator != null) {
                        invertedIndexCreator.add(dictId);
                    }
                } else {
                    if (textIndexCreator != null && !this.shouldStoreRawValueForTextIndex(columnName) && (columnValueToIndex = this._columnProperties.get(columnName).get(FieldConfig.TEXT_INDEX_RAW_VALUE)) == null) {
                        columnValueToIndex = FieldConfig.TEXT_INDEX_DEFAULT_RAW_VALUE;
                    }
                    switch (forwardIndexCreator.getValueType()) {
                        case INT: {
                            forwardIndexCreator.putInt(((Integer)columnValueToIndex).intValue());
                            break;
                        }
                        case LONG: {
                            forwardIndexCreator.putLong(((Long)columnValueToIndex).longValue());
                            break;
                        }
                        case FLOAT: {
                            forwardIndexCreator.putFloat(((Float)columnValueToIndex).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            forwardIndexCreator.putDouble(((Double)columnValueToIndex).doubleValue());
                            break;
                        }
                        case STRING: {
                            forwardIndexCreator.putString((String)columnValueToIndex);
                            break;
                        }
                        case BYTES: {
                            forwardIndexCreator.putBytes((byte[])columnValueToIndex);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                }
            } else {
                int[] dictIds = dictionaryCreator.indexOfMV(columnValueToIndex);
                forwardIndexCreator.putDictIdMV(dictIds);
                DictionaryBasedInvertedIndexCreator invertedIndexCreator = this._invertedIndexCreatorMap.get(columnName);
                if (invertedIndexCreator != null) {
                    invertedIndexCreator.add(dictIds, dictIds.length);
                }
            }
            if (!this._nullHandlingEnabled || !row.isNullValue(columnName)) continue;
            this._nullValueVectorCreatorMap.get(columnName).setNull(this.docIdCounter);
        }
        ++this.docIdCounter;
    }

    private boolean shouldStoreRawValueForTextIndex(String column) {
        if (this._columnProperties != null) {
            Map<String, String> props = this._columnProperties.get(column);
            return props == null || !Boolean.parseBoolean(props.get(FieldConfig.TEXT_INDEX_NO_RAW_DATA));
        }
        return true;
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = segmentName;
    }

    public void seal() throws ConfigurationException, IOException {
        for (DictionaryBasedInvertedIndexCreator invertedIndexCreator : this._invertedIndexCreatorMap.values()) {
            invertedIndexCreator.seal();
        }
        for (TextIndexCreator textIndexCreator : this._textIndexCreatorMap.values()) {
            textIndexCreator.seal();
        }
        for (TextIndexCreator fstIndexCreator : this._fstIndexCreatorMap.values()) {
            fstIndexCreator.seal();
        }
        for (JsonIndexCreator jsonIndexCreator : this._jsonIndexCreatorMap.values()) {
            jsonIndexCreator.seal();
        }
        for (GeoSpatialIndexCreator h3IndexCreator : this._h3IndexCreatorMap.values()) {
            h3IndexCreator.seal();
        }
        for (NullValueVectorCreator nullValueVectorCreator : this._nullValueVectorCreatorMap.values()) {
            nullValueVectorCreator.seal();
        }
        this.writeMetadata();
    }

    private void writeMetadata() throws ConfigurationException {
        ColumnIndexCreationInfo timeColumnIndexCreationInfo;
        PropertiesConfiguration properties = new PropertiesConfiguration(new File(this._indexDir, "metadata.properties"));
        properties.setProperty("creator.version", (Object)this.config.getCreatorVersion());
        properties.setProperty("segment.padding.character", (Object)String.valueOf('\u0000'));
        properties.setProperty("segment.name", (Object)this.segmentName);
        properties.setProperty("segment.table.name", (Object)this.config.getTableName());
        properties.setProperty("segment.dimension.column.names", (Object)this.config.getDimensions());
        properties.setProperty("segment.metric.column.names", (Object)this.config.getMetrics());
        properties.setProperty("segment.datetime.column.names", (Object)this.config.getDateTimeColumnNames());
        String timeColumnName = this.config.getTimeColumnName();
        properties.setProperty("segment.time.column.name", (Object)timeColumnName);
        properties.setProperty("segment.total.docs", (Object)String.valueOf(this.totalDocs));
        if (timeColumnName != null && (timeColumnIndexCreationInfo = this.indexCreationInfoMap.get(timeColumnName)) != null) {
            TimeUnit timeUnit;
            long endTime;
            long l;
            if (this.config.getStartTime() != null) {
                l = Long.parseLong(this.config.getStartTime());
                endTime = Long.parseLong(this.config.getEndTime());
                timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this.config.getSegmentTimeUnit())));
            } else if (this.totalDocs > 0) {
                String startTimeStr = timeColumnIndexCreationInfo.getMin().toString();
                String endTimeStr = timeColumnIndexCreationInfo.getMax().toString();
                if (this.config.getTimeColumnType() == SegmentGeneratorConfig.TimeColumnType.SIMPLE_DATE) {
                    DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern((String)this.config.getSimpleDateFormat());
                    l = dateTimeFormatter.parseMillis(startTimeStr);
                    endTime = dateTimeFormatter.parseMillis(endTimeStr);
                    timeUnit = TimeUnit.MILLISECONDS;
                } else {
                    l = Long.parseLong(startTimeStr);
                    endTime = Long.parseLong(endTimeStr);
                    timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this.config.getSegmentTimeUnit())));
                }
            } else {
                long now = System.currentTimeMillis();
                if (this.config.getTimeColumnType() == SegmentGeneratorConfig.TimeColumnType.SIMPLE_DATE) {
                    l = now;
                    endTime = now;
                    timeUnit = TimeUnit.MILLISECONDS;
                } else {
                    timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)this.config.getSegmentTimeUnit())));
                    l = timeUnit.convert(now, TimeUnit.MILLISECONDS);
                    endTime = timeUnit.convert(now, TimeUnit.MILLISECONDS);
                }
            }
            if (!this.config.isSkipTimeValueCheck()) {
                Interval timeInterval = new Interval(timeUnit.toMillis(l), timeUnit.toMillis(endTime), DateTimeZone.UTC);
                Preconditions.checkState((boolean)TimeUtils.isValidTimeInterval((Interval)timeInterval), (String)"Invalid segment start/end time: %s (in millis: %s/%s) for time column: %s, must be between: %s", (Object[])new Object[]{timeInterval, timeInterval.getStartMillis(), timeInterval.getEndMillis(), timeColumnName, TimeUtils.VALID_TIME_INTERVAL});
            }
            properties.setProperty("segment.start.time", (Object)l);
            properties.setProperty("segment.end.time", (Object)endTime);
            properties.setProperty("segment.time.unit", (Object)timeUnit);
        }
        for (Map.Entry entry : this.config.getCustomProperties().entrySet()) {
            properties.setProperty((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.indexCreationInfoMap.entrySet()) {
            String column = (String)entry.getKey();
            ColumnIndexCreationInfo columnIndexCreationInfo = (ColumnIndexCreationInfo)entry.getValue();
            SegmentDictionaryCreator dictionaryCreator = this._dictionaryCreatorMap.get(column);
            int dictionaryElementSize = dictionaryCreator != null ? dictionaryCreator.getNumBytesPerEntry() : 0;
            boolean hasInvertedIndex = true;
            TextIndexType textIndexType = this._textIndexCreatorMap.containsKey(column) ? TextIndexType.LUCENE : TextIndexType.NONE;
            boolean hasFSTIndex = this._fstIndexCreatorMap.containsKey(column);
            boolean hasJsonIndex = this._jsonIndexCreatorMap.containsKey(column);
            SegmentColumnarIndexCreator.addColumnMetadataInfo(properties, column, columnIndexCreationInfo, this.totalDocs, this.schema.getFieldSpecFor(column), this._dictionaryCreatorMap.containsKey(column), dictionaryElementSize, hasInvertedIndex, textIndexType, hasFSTIndex, hasJsonIndex);
        }
        properties.save();
    }

    public static void addColumnMetadataInfo(PropertiesConfiguration properties, String column, ColumnIndexCreationInfo columnIndexCreationInfo, int totalDocs, FieldSpec fieldSpec, boolean hasDictionary, int dictionaryElementSize, boolean hasInvertedIndex, TextIndexType textIndexType, boolean hasFSTIndex, boolean hasJsonIndex) {
        String defaultNullValue;
        int cardinality = columnIndexCreationInfo.getDistinctValueCount();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"cardinality"), (Object)String.valueOf(cardinality));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"totalDocs"), (Object)String.valueOf(totalDocs));
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"dataType"), (Object)String.valueOf(dataType));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"bitsPerElement"), (Object)String.valueOf(PinotDataBitSet.getNumBitsPerValue(cardinality - 1)));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"lengthOfEachEntry"), (Object)String.valueOf(dictionaryElementSize));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"columnType"), (Object)String.valueOf(fieldSpec.getFieldType()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isSorted"), (Object)String.valueOf(columnIndexCreationInfo.isSorted()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasNullValue"), (Object)String.valueOf(columnIndexCreationInfo.hasNulls()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasDictionary"), (Object)String.valueOf(hasDictionary));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"textIndexType"), (Object)textIndexType.name());
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasInvertedIndex"), (Object)String.valueOf(hasInvertedIndex));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasFSTIndex"), (Object)String.valueOf(hasFSTIndex));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"hasJsonIndex"), (Object)String.valueOf(hasJsonIndex));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isSingleValues"), (Object)String.valueOf(fieldSpec.isSingleValueField()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"maxNumberOfMultiValues"), (Object)String.valueOf(columnIndexCreationInfo.getMaxNumberOfMultiValueElements()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"totalNumberOfEntries"), (Object)String.valueOf(columnIndexCreationInfo.getTotalNumberOfEntries()));
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"isAutoGenerated"), (Object)String.valueOf(columnIndexCreationInfo.isAutoGenerated()));
        PartitionFunction partitionFunction = columnIndexCreationInfo.getPartitionFunction();
        if (partitionFunction != null) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"partitionFunction"), (Object)partitionFunction.toString());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"numPartitions"), (Object)columnIndexCreationInfo.getNumPartitions());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"partitionValues"), (Object)columnIndexCreationInfo.getPartitions());
        }
        if (fieldSpec.getFieldType().equals((Object)FieldSpec.FieldType.DATE_TIME)) {
            DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)fieldSpec;
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"datetimeFormat"), (Object)dateTimeFieldSpec.getFormat());
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"datetimeGranularity"), (Object)dateTimeFieldSpec.getGranularity());
        }
        if (totalDocs > 0) {
            Object min = columnIndexCreationInfo.getMin();
            Object max = columnIndexCreationInfo.getMax();
            if (min != null && max != null) {
                SegmentColumnarIndexCreator.addColumnMinMaxValueInfo(properties, column, min.toString(), max.toString());
            }
        }
        if (SegmentColumnarIndexCreator.isValidPropertyValue(defaultNullValue = columnIndexCreationInfo.getDefaultNullValue().toString())) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"defaultNullValue"), (Object)defaultNullValue);
        }
    }

    public static void addColumnMinMaxValueInfo(PropertiesConfiguration properties, String column, String minValue, String maxValue) {
        if (SegmentColumnarIndexCreator.isValidPropertyValue(minValue)) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"minValue"), (Object)minValue);
        }
        if (SegmentColumnarIndexCreator.isValidPropertyValue(maxValue)) {
            properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)column, (String)"maxValue"), (Object)maxValue);
        }
    }

    @VisibleForTesting
    static boolean isValidPropertyValue(String value) {
        int length = value.length();
        if (length == 0) {
            return true;
        }
        if (length > 512) {
            return false;
        }
        if (Character.isWhitespace(value.charAt(0)) || Character.isWhitespace(value.charAt(length - 1))) {
            return false;
        }
        return value.indexOf(44) == -1;
    }

    public static void removeColumnMetadataInfo(PropertiesConfiguration properties, String column) {
        properties.subset("column." + column).clear();
    }

    public static ForwardIndexCreator getRawIndexCreatorForColumn(File file, ChunkCompressionType compressionType, String column, FieldSpec.DataType dataType, int totalDocs, int lengthOfLongestEntry, boolean deriveNumDocsPerChunk, int writerVersion) throws IOException {
        switch (dataType.getStoredType()) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new SingleValueFixedByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, writerVersion);
            }
            case STRING: 
            case BYTES: {
                return new SingleValueVarByteRawIndexCreator(file, compressionType, column, totalDocs, dataType, lengthOfLongestEntry, deriveNumDocsPerChunk, writerVersion);
            }
        }
        throw new UnsupportedOperationException("Data type not supported for raw indexing: " + dataType);
    }

    public void close() throws IOException {
        FileUtils.close((Iterable)Iterables.concat((Iterable[])new Iterable[]{this._dictionaryCreatorMap.values(), this._forwardIndexCreatorMap.values(), this._invertedIndexCreatorMap.values(), this._textIndexCreatorMap.values(), this._fstIndexCreatorMap.values(), this._jsonIndexCreatorMap.values(), this._h3IndexCreatorMap.values(), this._nullValueVectorCreatorMap.values()}));
    }
}

