/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.segment.local.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.segment.local.io.util.VarLengthValueWriter;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentDictionaryCreator
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentDictionaryCreator.class);
    private final Object _sortedValues;
    private final String _columnName;
    private final FieldSpec.DataType _storedType;
    private final File _dictionaryFile;
    private final boolean _useVarLengthDictionary;
    private Int2IntOpenHashMap _intValueToIndexMap;
    private Long2IntOpenHashMap _longValueToIndexMap;
    private Float2IntOpenHashMap _floatValueToIndexMap;
    private Double2IntOpenHashMap _doubleValueToIndexMap;
    private Object2IntOpenHashMap<String> _stringValueToIndexMap;
    private Object2IntOpenHashMap<ByteArray> _bytesValueToIndexMap;
    private int _numBytesPerEntry = 0;

    public SegmentDictionaryCreator(Object sortedValues, FieldSpec fieldSpec, File indexDir, boolean useVarLengthDictionary) throws IOException {
        this._sortedValues = sortedValues;
        this._columnName = fieldSpec.getName();
        this._storedType = fieldSpec.getDataType().getStoredType();
        this._dictionaryFile = new File(indexDir, this._columnName + ".dict");
        FileUtils.touch((File)this._dictionaryFile);
        this._useVarLengthDictionary = useVarLengthDictionary;
    }

    public SegmentDictionaryCreator(Object sortedValues, FieldSpec fieldSpec, File indexDir) throws IOException {
        this(sortedValues, fieldSpec, indexDir, false);
    }

    public void build() throws IOException {
        switch (this._storedType) {
            case INT: {
                int[] sortedInts = (int[])this._sortedValues;
                int numValues = sortedInts.length;
                Preconditions.checkState((numValues > 0 ? 1 : 0) != 0);
                this._intValueToIndexMap = new Int2IntOpenHashMap(numValues);
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile((File)this._dictionaryFile, (boolean)false, (long)0L, (long)((long)numValues * 4L), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        int value = sortedInts[i];
                        this._intValueToIndexMap.put(value, i);
                        writer.writeInt(i, value);
                    }
                }
                LOGGER.info("Created dictionary for INT column: {} with cardinality: {}, range: {} to {}", new Object[]{this._columnName, numValues, sortedInts[0], sortedInts[numValues - 1]});
                return;
            }
            case LONG: {
                long[] sortedLongs = (long[])this._sortedValues;
                int numValues = sortedLongs.length;
                Preconditions.checkState((numValues > 0 ? 1 : 0) != 0);
                this._longValueToIndexMap = new Long2IntOpenHashMap(numValues);
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile((File)this._dictionaryFile, (boolean)false, (long)0L, (long)((long)numValues * 8L), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        long value = sortedLongs[i];
                        this._longValueToIndexMap.put(value, i);
                        writer.writeLong(i, value);
                    }
                }
                LOGGER.info("Created dictionary for LONG column: {} with cardinality: {}, range: {} to {}", new Object[]{this._columnName, numValues, sortedLongs[0], sortedLongs[numValues - 1]});
                return;
            }
            case FLOAT: {
                float[] sortedFloats = (float[])this._sortedValues;
                int numValues = sortedFloats.length;
                Preconditions.checkState((numValues > 0 ? 1 : 0) != 0);
                this._floatValueToIndexMap = new Float2IntOpenHashMap(numValues);
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile((File)this._dictionaryFile, (boolean)false, (long)0L, (long)((long)numValues * 4L), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        float value = sortedFloats[i];
                        this._floatValueToIndexMap.put(value, i);
                        writer.writeFloat(i, value);
                    }
                }
                LOGGER.info("Created dictionary for FLOAT column: {} with cardinality: {}, range: {} to {}", new Object[]{this._columnName, numValues, Float.valueOf(sortedFloats[0]), Float.valueOf(sortedFloats[numValues - 1])});
                return;
            }
            case DOUBLE: {
                double[] sortedDoubles = (double[])this._sortedValues;
                int numValues = sortedDoubles.length;
                Preconditions.checkState((numValues > 0 ? 1 : 0) != 0);
                this._doubleValueToIndexMap = new Double2IntOpenHashMap(numValues);
                try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile((File)this._dictionaryFile, (boolean)false, (long)0L, (long)((long)numValues * 8L), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());
                     FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                    for (int i = 0; i < numValues; ++i) {
                        double value = sortedDoubles[i];
                        this._doubleValueToIndexMap.put(value, i);
                        writer.writeDouble(i, value);
                    }
                }
                LOGGER.info("Created dictionary for DOUBLE column: {} with cardinality: {}, range: {} to {}", new Object[]{this._columnName, numValues, sortedDoubles[0], sortedDoubles[numValues - 1]});
                return;
            }
            case STRING: {
                String[] sortedStrings = (String[])this._sortedValues;
                int numValues = sortedStrings.length;
                Preconditions.checkState((numValues > 0 ? 1 : 0) != 0);
                this._stringValueToIndexMap = new Object2IntOpenHashMap(numValues);
                byte[][] sortedStringBytes = new byte[numValues][];
                for (int i = 0; i < numValues; ++i) {
                    String value = sortedStrings[i];
                    this._stringValueToIndexMap.put((Object)value, i);
                    byte[] valueBytes = StringUtil.encodeUtf8((String)value);
                    sortedStringBytes[i] = valueBytes;
                    this._numBytesPerEntry = Math.max(this._numBytesPerEntry, valueBytes.length);
                }
                this.writeBytesValueDictionary(sortedStringBytes);
                LOGGER.info("Created dictionary for STRING column: {} with cardinality: {}, max length in bytes: {}, range: {} to {}", new Object[]{this._columnName, numValues, this._numBytesPerEntry, sortedStrings[0], sortedStrings[numValues - 1]});
                return;
            }
            case BYTES: {
                ByteArray[] sortedBytes = (ByteArray[])this._sortedValues;
                int numValues = sortedBytes.length;
                Preconditions.checkState((numValues > 0 ? 1 : 0) != 0);
                this._bytesValueToIndexMap = new Object2IntOpenHashMap(numValues);
                byte[][] sortedByteArrays = new byte[sortedBytes.length][];
                for (int i = 0; i < numValues; ++i) {
                    ByteArray value = sortedBytes[i];
                    sortedByteArrays[i] = value.getBytes();
                    this._bytesValueToIndexMap.put((Object)value, i);
                    this._numBytesPerEntry = Math.max(this._numBytesPerEntry, value.getBytes().length);
                }
                this.writeBytesValueDictionary(sortedByteArrays);
                LOGGER.info("Created dictionary for BYTES column: {} with cardinality: {}, max length in bytes: {}, range: {} to {}", new Object[]{this._columnName, numValues, this._numBytesPerEntry, sortedBytes[0], sortedBytes[numValues - 1]});
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported data type: " + this._storedType);
    }

    private void writeBytesValueDictionary(byte[][] bytesValues) throws IOException {
        if (this._useVarLengthDictionary) {
            try (VarLengthValueWriter writer = new VarLengthValueWriter(this._dictionaryFile, bytesValues.length);){
                for (byte[] value : bytesValues) {
                    writer.add(value);
                }
            }
            LOGGER.info("Using variable length dictionary for column: {}, size: {}", (Object)this._columnName, (Object)this._dictionaryFile.length());
        } else {
            int numValues = bytesValues.length;
            try (PinotDataBuffer dataBuffer = PinotDataBuffer.mapFile((File)this._dictionaryFile, (boolean)false, (long)0L, (long)((long)numValues * (long)this._numBytesPerEntry), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)this.getClass().getSimpleName());
                 FixedByteValueReaderWriter writer = new FixedByteValueReaderWriter(dataBuffer);){
                for (int i = 0; i < bytesValues.length; ++i) {
                    writer.writeBytes(i, this._numBytesPerEntry, bytesValues[i]);
                }
            }
            LOGGER.info("Using fixed length dictionary for column: {}, size: {}", (Object)this._columnName, (Object)((long)numValues * (long)this._numBytesPerEntry));
        }
    }

    public int getNumBytesPerEntry() {
        return this._numBytesPerEntry;
    }

    public int indexOfSV(Object value) {
        switch (this._storedType) {
            case INT: {
                return this._intValueToIndexMap.get(((Integer)value).intValue());
            }
            case LONG: {
                return this._longValueToIndexMap.get(((Long)value).longValue());
            }
            case FLOAT: {
                return this._floatValueToIndexMap.get(((Float)value).floatValue());
            }
            case DOUBLE: {
                return this._doubleValueToIndexMap.get(((Double)value).doubleValue());
            }
            case STRING: {
                return this._stringValueToIndexMap.getInt(value);
            }
            case BYTES: {
                return this._bytesValueToIndexMap.get((Object)new ByteArray((byte[])value));
            }
        }
        throw new UnsupportedOperationException("Unsupported data type : " + this._storedType);
    }

    public int[] indexOfMV(Object value) {
        Object[] multiValues = (Object[])value;
        int[] indexes = new int[multiValues.length];
        switch (this._storedType) {
            case INT: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._intValueToIndexMap.get(((Integer)multiValues[i]).intValue());
                }
                break;
            }
            case LONG: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._longValueToIndexMap.get(((Long)multiValues[i]).longValue());
                }
                break;
            }
            case FLOAT: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._floatValueToIndexMap.get(((Float)multiValues[i]).floatValue());
                }
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._doubleValueToIndexMap.get(((Double)multiValues[i]).doubleValue());
                }
                break;
            }
            case STRING: {
                for (int i = 0; i < multiValues.length; ++i) {
                    indexes[i] = this._stringValueToIndexMap.getInt(multiValues[i]);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type : " + this._storedType);
            }
        }
        return indexes;
    }

    @Override
    public void close() {
    }
}

