/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl;

import com.google.common.base.Preconditions;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.recordtransformer.ComplexTypeTransformer;
import org.apache.pinot.segment.local.recordtransformer.CompositeTransformer;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.segment.local.segment.creator.IntermediateSegmentSegmentCreationDataSource;
import org.apache.pinot.segment.local.segment.creator.RecordReaderSegmentCreationDataSource;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.segment.index.converter.SegmentFormatConverterFactory;
import org.apache.pinot.segment.local.segment.readers.IntermediateSegmentRecordReader;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.local.startree.v2.builder.MultipleTreesBuilder;
import org.apache.pinot.segment.local.utils.CrcUtils;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.segment.spi.converter.SegmentFormatConverter;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.SegmentCreationDataSource;
import org.apache.pinot.segment.spi.creator.SegmentCreator;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.creator.SegmentIndexCreationDriver;
import org.apache.pinot.segment.spi.creator.SegmentPreIndexStatsContainer;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.segment.spi.index.creator.SegmentIndexCreationInfo;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.IngestionSchemaValidator;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.SchemaValidatorFactory;
import org.apache.pinot.spi.data.readers.FileFormat;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.data.readers.RecordReaderConfig;
import org.apache.pinot.spi.data.readers.RecordReaderFactory;
import org.apache.pinot.spi.utils.ByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentIndexCreationDriverImpl
implements SegmentIndexCreationDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentIndexCreationDriverImpl.class);
    private SegmentGeneratorConfig config;
    private RecordReader recordReader;
    private SegmentPreIndexStatsContainer segmentStats;
    private Map<String, ColumnIndexCreationInfo> indexCreationInfoMap;
    private SegmentCreator indexCreator;
    private SegmentIndexCreationInfo segmentIndexCreationInfo;
    private Schema dataSchema;
    private RecordTransformer _recordTransformer;
    private ComplexTypeTransformer _complexTypeTransformer;
    private IngestionSchemaValidator _ingestionSchemaValidator;
    private int totalDocs = 0;
    private File tempIndexDir;
    private String segmentName;
    private long totalRecordReadTime = 0L;
    private long totalIndexTime = 0L;
    private long totalStatsCollectorTime = 0L;

    public void init(SegmentGeneratorConfig config) throws Exception {
        this.init(config, this.getRecordReader(config));
    }

    private RecordReader getRecordReader(SegmentGeneratorConfig segmentGeneratorConfig) throws Exception {
        File dataFile = new File(segmentGeneratorConfig.getInputFilePath());
        Preconditions.checkState((boolean)dataFile.exists(), (Object)("Input file: " + dataFile.getAbsolutePath() + " does not exist"));
        Schema schema = segmentGeneratorConfig.getSchema();
        TableConfig tableConfig = segmentGeneratorConfig.getTableConfig();
        FileFormat fileFormat = segmentGeneratorConfig.getFormat();
        String recordReaderClassName = segmentGeneratorConfig.getRecordReaderPath();
        Set<String> sourceFields = IngestionUtils.getFieldsForRecordExtractor(tableConfig.getIngestionConfig(), segmentGeneratorConfig.getSchema());
        if (recordReaderClassName != null) {
            if (fileFormat != FileFormat.OTHER) {
                LOGGER.warn("Using class: {} to read segment, ignoring configured file format: {}", (Object)recordReaderClassName, (Object)fileFormat);
            }
            return RecordReaderFactory.getRecordReaderByClass((String)recordReaderClassName, (File)dataFile, sourceFields, (RecordReaderConfig)segmentGeneratorConfig.getReaderConfig());
        }
        if (fileFormat == FileFormat.PINOT) {
            return new PinotSegmentRecordReader(dataFile, schema, segmentGeneratorConfig.getColumnSortOrder());
        }
        return RecordReaderFactory.getRecordReader((FileFormat)fileFormat, (File)dataFile, sourceFields, (RecordReaderConfig)segmentGeneratorConfig.getReaderConfig());
    }

    public RecordReader getRecordReader() {
        return this.recordReader;
    }

    public void init(SegmentGeneratorConfig config, RecordReader recordReader) throws Exception {
        Object dataSource;
        if (recordReader instanceof IntermediateSegmentRecordReader) {
            LOGGER.info("IntermediateSegmentRecordReader is used");
            dataSource = new IntermediateSegmentSegmentCreationDataSource((IntermediateSegmentRecordReader)recordReader);
        } else {
            LOGGER.info("RecordReaderSegmentCreationDataSource is used");
            dataSource = new RecordReaderSegmentCreationDataSource(recordReader);
        }
        this.init(config, (SegmentCreationDataSource)dataSource, CompositeTransformer.getDefaultTransformer(config.getTableConfig(), config.getSchema()), ComplexTypeTransformer.getComplexTypeTransformer(config.getTableConfig()));
    }

    public void init(SegmentGeneratorConfig config, SegmentCreationDataSource dataSource, RecordTransformer recordTransformer, @Nullable ComplexTypeTransformer complexTypeTransformer) throws Exception {
        this.config = config;
        this.recordReader = dataSource.getRecordReader();
        this.dataSchema = config.getSchema();
        if (config.isFailOnEmptySegment()) {
            Preconditions.checkState((boolean)this.recordReader.hasNext(), (Object)"No record in data source");
        }
        this._recordTransformer = recordTransformer;
        this._complexTypeTransformer = complexTypeTransformer;
        this.segmentStats = dataSource.gatherStats(new StatsCollectorConfig(config.getTableConfig(), this.dataSchema, config.getSegmentPartitionConfig()));
        this.totalDocs = this.segmentStats.getTotalDocCount();
        this.segmentIndexCreationInfo = new SegmentIndexCreationInfo();
        this.indexCreationInfoMap = new HashMap<String, ColumnIndexCreationInfo>();
        this.indexCreator = new SegmentColumnarIndexCreator();
        File indexDir = new File(config.getOutDir());
        if (!indexDir.exists()) {
            indexDir.mkdirs();
        }
        this._ingestionSchemaValidator = SchemaValidatorFactory.getSchemaValidator((Schema)this.dataSchema, (String)this.recordReader.getClass().getName(), (String)config.getInputFilePath());
        this.tempIndexDir = new File(indexDir, "tmp-" + UUID.randomUUID());
        LOGGER.debug("tempIndexDir:{}", (Object)this.tempIndexDir);
    }

    public void build() throws Exception {
        LOGGER.debug("Start building StatsCollector!");
        this.buildIndexCreationInfo();
        LOGGER.info("Finished building StatsCollector!");
        LOGGER.info("Collected stats for {} documents", (Object)this.totalDocs);
        try {
            this.indexCreator.init(this.config, this.segmentIndexCreationInfo, this.indexCreationInfoMap, this.dataSchema, this.tempIndexDir);
            this.recordReader.rewind();
            LOGGER.info("Start building IndexCreator!");
            GenericRow reuse = new GenericRow();
            while (this.recordReader.hasNext()) {
                long indexStopTime;
                long recordReadStopTime;
                long recordReadStartTime = System.currentTimeMillis();
                reuse.clear();
                GenericRow decodedRow = this.recordReader.next(reuse);
                if (this._complexTypeTransformer != null) {
                    decodedRow = this._complexTypeTransformer.transform(decodedRow);
                }
                if (decodedRow.getValue("$MULTIPLE_RECORDS_KEY$") != null) {
                    recordReadStopTime = System.currentTimeMillis();
                    this.totalRecordReadTime += recordReadStopTime - recordReadStartTime;
                    for (Object singleRow : (Collection)decodedRow.getValue("$MULTIPLE_RECORDS_KEY$")) {
                        recordReadStartTime = System.currentTimeMillis();
                        GenericRow transformedRow = this._recordTransformer.transform((GenericRow)singleRow);
                        recordReadStopTime = System.currentTimeMillis();
                        this.totalRecordReadTime += recordReadStopTime - recordReadStartTime;
                        if (transformedRow == null || !IngestionUtils.shouldIngestRow(transformedRow)) continue;
                        this.indexCreator.indexRow(transformedRow);
                        indexStopTime = System.currentTimeMillis();
                        this.totalIndexTime += indexStopTime - recordReadStopTime;
                    }
                    continue;
                }
                GenericRow transformedRow = this._recordTransformer.transform(decodedRow);
                recordReadStopTime = System.currentTimeMillis();
                this.totalRecordReadTime += recordReadStopTime - recordReadStartTime;
                if (transformedRow == null || !IngestionUtils.shouldIngestRow(transformedRow)) continue;
                this.indexCreator.indexRow(transformedRow);
                indexStopTime = System.currentTimeMillis();
                this.totalIndexTime += indexStopTime - recordReadStopTime;
            }
        }
        catch (Exception e) {
            this.indexCreator.close();
            throw e;
        }
        finally {
            this.recordReader.close();
        }
        LOGGER.info("Finished records indexing in IndexCreator!");
        this.handlePostCreation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePostCreation() throws Exception {
        long creationTime;
        ColumnStatistics timeColumnStatistics = this.segmentStats.getColumnProfileFor(this.config.getTimeColumnName());
        int sequenceId = this.config.getSequenceId();
        if (timeColumnStatistics != null) {
            if (this.totalDocs > 0) {
                this.segmentName = this.config.getSegmentNameGenerator().generateSegmentName(sequenceId, timeColumnStatistics.getMinValue(), timeColumnStatistics.getMaxValue());
            } else {
                Preconditions.checkArgument((!this.config.isFailOnEmptySegment() ? 1 : 0) != 0, (Object)("Failing the empty segment creation as the option 'failOnEmptySegment' is set to: " + this.config.isFailOnEmptySegment()));
                long now = System.currentTimeMillis();
                this.segmentName = this.config.getSegmentNameGenerator().generateSegmentName(sequenceId, (Object)now, (Object)now);
            }
        } else {
            this.segmentName = this.config.getSegmentNameGenerator().generateSegmentName(sequenceId, null, null);
        }
        try {
            this.indexCreator.setSegmentName(this.segmentName);
            this.indexCreator.seal();
        }
        finally {
            this.indexCreator.close();
        }
        LOGGER.info("Finished segment seal!");
        File outputDir = new File(this.config.getOutDir());
        File segmentOutputDir = new File(outputDir, this.segmentName);
        if (segmentOutputDir.exists()) {
            FileUtils.deleteDirectory((File)segmentOutputDir);
        }
        FileUtils.moveDirectory((File)this.tempIndexDir, (File)segmentOutputDir);
        FileUtils.deleteQuietly((File)this.tempIndexDir);
        this.convertFormatIfNecessary(segmentOutputDir);
        if (this.totalDocs > 0) {
            this.buildStarTreeV2IfNecessary(segmentOutputDir);
        }
        long crc = CrcUtils.forAllFilesInFolder(segmentOutputDir).computeCrc();
        String creationTimeInConfig = this.config.getCreationTime();
        if (creationTimeInConfig != null) {
            try {
                creationTime = Long.parseLong(creationTimeInConfig);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while parsing creation time in config, use current time as creation time");
                creationTime = System.currentTimeMillis();
            }
        } else {
            creationTime = System.currentTimeMillis();
        }
        SegmentIndexCreationDriverImpl.persistCreationMeta(segmentOutputDir, crc, creationTime);
        LOGGER.info("Driver, record read time : {}", (Object)this.totalRecordReadTime);
        LOGGER.info("Driver, stats collector time : {}", (Object)this.totalStatsCollectorTime);
        LOGGER.info("Driver, indexing time : {}", (Object)this.totalIndexTime);
    }

    private void buildStarTreeV2IfNecessary(File indexDir) throws Exception {
        List starTreeIndexConfigs = this.config.getStarTreeIndexConfigs();
        boolean enableDefaultStarTree = this.config.isEnableDefaultStarTree();
        if (CollectionUtils.isNotEmpty((Collection)starTreeIndexConfigs) || enableDefaultStarTree) {
            MultipleTreesBuilder.BuildMode buildMode = this.config.isOnHeap() ? MultipleTreesBuilder.BuildMode.ON_HEAP : MultipleTreesBuilder.BuildMode.OFF_HEAP;
            try (MultipleTreesBuilder builder = new MultipleTreesBuilder(starTreeIndexConfigs, enableDefaultStarTree, indexDir, buildMode);){
                builder.build();
            }
        }
    }

    private void convertFormatIfNecessary(File segmentDirectory) throws Exception {
        SegmentVersion versionToGenerate = this.config.getSegmentVersion();
        if (versionToGenerate.equals((Object)SegmentVersion.v1)) {
            return;
        }
        SegmentFormatConverter converter = SegmentFormatConverterFactory.getConverter(SegmentVersion.v1, SegmentVersion.v3);
        converter.convert(segmentDirectory);
    }

    public ColumnStatistics getColumnStatisticsCollector(String columnName) throws Exception {
        return this.segmentStats.getColumnProfileFor(columnName);
    }

    public static void persistCreationMeta(File indexDir, long crc, long creationTime) throws IOException {
        File segmentDir = SegmentDirectoryPaths.findSegmentDirectory((File)indexDir);
        File creationMetaFile = new File(segmentDir, "creation.meta");
        try (DataOutputStream output = new DataOutputStream(new FileOutputStream(creationMetaFile));){
            output.writeLong(crc);
            output.writeLong(creationTime);
        }
    }

    void buildIndexCreationInfo() throws Exception {
        HashSet varLengthDictionaryColumns = new HashSet(this.config.getVarLengthDictionaryColumns());
        for (FieldSpec fieldSpec : this.dataSchema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            String columnName = fieldSpec.getName();
            FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
            ColumnStatistics columnProfile = this.segmentStats.getColumnProfileFor(columnName);
            boolean useVarLengthDictionary = varLengthDictionaryColumns.contains(columnName);
            Object defaultNullValue = fieldSpec.getDefaultNullValue();
            if (storedType == FieldSpec.DataType.BYTES) {
                if (!columnProfile.isFixedLength()) {
                    useVarLengthDictionary = true;
                }
                defaultNullValue = new ByteArray((byte[])defaultNullValue);
            }
            this.indexCreationInfoMap.put(columnName, new ColumnIndexCreationInfo(columnProfile, true, useVarLengthDictionary, false, defaultNullValue));
        }
        this.segmentIndexCreationInfo.setTotalDocs(this.totalDocs);
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public File getOutputDirectory() {
        return new File(new File(this.config.getOutDir()), this.segmentName);
    }

    public IngestionSchemaValidator getIngestionSchemaValidator() {
        return this._ingestionSchemaValidator;
    }

    public SegmentPreIndexStatsContainer getSegmentStats() {
        return this.segmentStats;
    }
}

