/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.apache.pinot.segment.spi.memory.CleanerUtil;
import org.roaringbitmap.RoaringBitmap;

public final class BitmapInvertedIndexWriter
implements Closeable {
    private final FileChannel _fileChannel;
    private final ByteBuffer _offsetBuffer;
    private final ByteBuffer _bitmapBuffer;

    public BitmapInvertedIndexWriter(File outputFile, int numBitmaps) throws IOException {
        this._fileChannel = new RandomAccessFile(outputFile, "rw").getChannel();
        this._offsetBuffer = this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, Integer.MAX_VALUE);
        this._bitmapBuffer = this._offsetBuffer.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        this._bitmapBuffer.position((numBitmaps + 1) * 4);
    }

    public void add(RoaringBitmap bitmap) throws IOException {
        this._offsetBuffer.putInt(this._bitmapBuffer.position());
        bitmap.serialize(this._bitmapBuffer);
    }

    public void add(byte[] bitmapBytes) {
        this.add(bitmapBytes, bitmapBytes.length);
    }

    public void add(byte[] bitmapBytes, int length) {
        this._offsetBuffer.putInt(this._bitmapBuffer.position());
        this._bitmapBuffer.put(bitmapBytes, 0, length);
    }

    @Override
    public void close() throws IOException {
        int fileLength = this._bitmapBuffer.position();
        this._offsetBuffer.putInt(fileLength);
        this._fileChannel.truncate(fileLength);
        this._fileChannel.close();
        if (CleanerUtil.UNMAP_SUPPORTED) {
            CleanerUtil.BufferCleaner cleaner = CleanerUtil.getCleaner();
            cleaner.freeBuffer(this._offsetBuffer);
        }
    }
}

