/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.segment.creator.impl.inv.BitmapInvertedIndexWriter;
import org.apache.pinot.segment.spi.index.creator.DictionaryBasedInvertedIndexCreator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapWriter;

public final class OnHeapBitmapInvertedIndexCreator
implements DictionaryBasedInvertedIndexCreator {
    private final File _invertedIndexFile;
    private final RoaringBitmapWriter<RoaringBitmap>[] _bitmapWriters;
    private int _nextDocId;

    public OnHeapBitmapInvertedIndexCreator(File indexDir, String columnName, int cardinality) {
        this._invertedIndexFile = new File(indexDir, columnName + ".bitmap.inv");
        RoaringBitmapWriter.Wizard writerWizard = RoaringBitmapWriter.writer().runCompress(false);
        this._bitmapWriters = new RoaringBitmapWriter[cardinality];
        for (int i = 0; i < cardinality; ++i) {
            this._bitmapWriters[i] = writerWizard.get();
        }
    }

    public void add(int dictId) {
        this._bitmapWriters[dictId].add(this._nextDocId++);
    }

    public void add(int[] dictIds, int length) {
        for (int i = 0; i < length; ++i) {
            this._bitmapWriters[dictIds[i]].add(this._nextDocId);
        }
        ++this._nextDocId;
    }

    public void seal() throws IOException {
        try (BitmapInvertedIndexWriter writer = new BitmapInvertedIndexWriter(this._invertedIndexFile, this._bitmapWriters.length);){
            for (RoaringBitmapWriter<RoaringBitmap> bitmapWriter : this._bitmapWriters) {
                writer.add((RoaringBitmap)bitmapWriter.get());
            }
        }
    }

    public void close() {
    }
}

