/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.lucene.util.fst.FST;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.utils.fst.FSTBuilder;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneFSTIndexCreator
implements TextIndexCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentColumnarIndexCreator.class);
    private final File _fstIndexFile;
    private final FSTBuilder _fstBuilder;
    Integer _dictId;

    public LuceneFSTIndexCreator(File indexDir, String columnName, String[] sortedEntries) throws IOException {
        this._fstIndexFile = new File(indexDir, columnName + ".lucene.fst");
        this._fstBuilder = new FSTBuilder();
        this._dictId = 0;
        if (sortedEntries != null) {
            this._dictId = 0;
            while (this._dictId < sortedEntries.length) {
                this._fstBuilder.addEntry(sortedEntries[this._dictId], this._dictId);
                Integer n = this._dictId;
                Integer n2 = this._dictId = Integer.valueOf(this._dictId + 1);
            }
        }
    }

    public void add(String document) {
        try {
            this._fstBuilder.addEntry(document, this._dictId);
            Integer n = this._dictId;
            Integer n2 = this._dictId = Integer.valueOf(this._dictId + 1);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to load the schema file", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seal() throws IOException {
        LOGGER.info("Sealing FST index: " + this._fstIndexFile.getAbsolutePath());
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(this._fstIndexFile);
            FST fst = this._fstBuilder.done();
            OutputStreamDataOutput d = new OutputStreamDataOutput((OutputStream)fileOutputStream);
            fst.save((DataOutput)d);
        }
    }

    public void close() throws IOException {
    }
}

