/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;

public class FloatColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private final FloatSet _values = new FloatOpenHashSet(1000);
    private float[] _sortedValues;
    private boolean _sealed = false;

    public FloatColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        if (entry instanceof Object[]) {
            Object[] values;
            for (Object obj : values = (Object[])entry) {
                float value = ((Float)obj).floatValue();
                this._values.add(value);
            }
            this.maxNumberOfMultiValues = Math.max(this.maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values);
        } else {
            float value = ((Float)entry).floatValue();
            this.addressSorted(Float.valueOf(value));
            this.updatePartition(Float.valueOf(value));
            this._values.add(value);
            ++this.totalNumberOfEntries;
        }
    }

    @Override
    public Float getMinValue() {
        if (this._sealed) {
            return Float.valueOf(this._sortedValues[0]);
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Float getMaxValue() {
        if (this._sealed) {
            return Float.valueOf(this._sortedValues[this._sortedValues.length - 1]);
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    @Override
    public Object getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this._sortedValues = this._values.toFloatArray();
        Arrays.sort(this._sortedValues);
        this._sealed = true;
    }
}

