/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;

public class IntColumnPreIndexStatsCollector
extends AbstractColumnStatisticsCollector {
    private final IntSet _values = new IntOpenHashSet(1000);
    private int[] _sortedValues;
    private boolean _sealed = false;

    public IntColumnPreIndexStatsCollector(String column, StatsCollectorConfig statsCollectorConfig) {
        super(column, statsCollectorConfig);
    }

    @Override
    public void collect(Object entry) {
        if (entry instanceof Object[]) {
            Object[] values;
            for (Object obj : values = (Object[])entry) {
                int value = (Integer)obj;
                this._values.add(value);
            }
            this.maxNumberOfMultiValues = Math.max(this.maxNumberOfMultiValues, values.length);
            this.updateTotalNumberOfEntries(values);
        } else {
            int value = (Integer)entry;
            this.addressSorted(value);
            this.updatePartition(value);
            this._values.add(value);
            ++this.totalNumberOfEntries;
        }
    }

    @Override
    public Integer getMinValue() {
        if (this._sealed) {
            return this._sortedValues[0];
        }
        throw new IllegalStateException("you must seal the collector first before asking for min value");
    }

    @Override
    public Integer getMaxValue() {
        if (this._sealed) {
            return this._sortedValues[this._sortedValues.length - 1];
        }
        throw new IllegalStateException("you must seal the collector first before asking for max value");
    }

    @Override
    public Object getUniqueValuesSet() {
        if (this._sealed) {
            return this._sortedValues;
        }
        throw new IllegalStateException("you must seal the collector first before asking for unique values set");
    }

    @Override
    public int getCardinality() {
        if (this._sealed) {
            return this._sortedValues.length;
        }
        throw new IllegalStateException("you must seal the collector first before asking for cardinality");
    }

    public boolean hasNull() {
        return false;
    }

    @Override
    public void seal() {
        this._sortedValues = this._values.toIntArray();
        Arrays.sort(this._sortedValues);
        this._sealed = true;
    }
}

