/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.BytesColumnPredIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.DoubleColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.FloatColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.IntColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.LongColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.StringColumnPreIndexStatsCollector;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.SegmentPreIndexStatsCollector;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPreIndexStatsCollectorImpl
implements SegmentPreIndexStatsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPreIndexStatsCollectorImpl.class);
    private final StatsCollectorConfig _statsCollectorConfig;
    private Map<String, AbstractColumnStatisticsCollector> columnStatsCollectorMap;
    private int totalDocCount;

    public SegmentPreIndexStatsCollectorImpl(StatsCollectorConfig statsCollectorConfig) {
        this._statsCollectorConfig = statsCollectorConfig;
    }

    public void init() {
        this.columnStatsCollectorMap = new HashMap<String, AbstractColumnStatisticsCollector>();
        Schema dataSchema = this._statsCollectorConfig.getSchema();
        block8: for (FieldSpec fieldSpec : dataSchema.getAllFieldSpecs()) {
            String column = fieldSpec.getName();
            switch (fieldSpec.getDataType().getStoredType()) {
                case INT: {
                    this.columnStatsCollectorMap.put(column, new IntColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block8;
                }
                case LONG: {
                    this.columnStatsCollectorMap.put(column, new LongColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block8;
                }
                case FLOAT: {
                    this.columnStatsCollectorMap.put(column, new FloatColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block8;
                }
                case DOUBLE: {
                    this.columnStatsCollectorMap.put(column, new DoubleColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block8;
                }
                case STRING: {
                    this.columnStatsCollectorMap.put(column, new StringColumnPreIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block8;
                }
                case BYTES: {
                    this.columnStatsCollectorMap.put(column, new BytesColumnPredIndexStatsCollector(column, this._statsCollectorConfig));
                    continue block8;
                }
            }
            throw new IllegalStateException("Unsupported data type: " + fieldSpec.getDataType());
        }
    }

    public void build() {
        for (String column : this.columnStatsCollectorMap.keySet()) {
            this.columnStatsCollectorMap.get(column).seal();
        }
    }

    public ColumnStatistics getColumnProfileFor(String column) {
        return this.columnStatsCollectorMap.get(column);
    }

    public void collectRow(GenericRow row) {
        for (Map.Entry columnNameAndValue : row.getFieldToValueMap().entrySet()) {
            String columnName = (String)columnNameAndValue.getKey();
            Object value = columnNameAndValue.getValue();
            if (!this.columnStatsCollectorMap.containsKey(columnName)) continue;
            try {
                this.columnStatsCollectorMap.get(columnName).collect(value);
            }
            catch (Exception e) {
                LOGGER.error("Exception while collecting stats for column:{} in row:{}", (Object)columnName, (Object)row);
                throw e;
            }
        }
        ++this.totalDocCount;
    }

    public int getTotalDocCount() {
        return this.totalDocCount;
    }

    public void logStats() {
        try {
            for (String column : this.columnStatsCollectorMap.keySet()) {
                AbstractColumnStatisticsCollector statisticsCollector = this.columnStatsCollectorMap.get(column);
                LOGGER.info("********** logging for column : " + column + " ********************* ");
                LOGGER.info("min value : " + statisticsCollector.getMinValue());
                LOGGER.info("max value : " + statisticsCollector.getMaxValue());
                LOGGER.info("cardinality : " + statisticsCollector.getCardinality());
                LOGGER.info("length of largest column : " + statisticsCollector.getLengthOfLargestElement());
                LOGGER.info("is sorted : " + statisticsCollector.isSorted());
                LOGGER.info("column type : " + this._statsCollectorConfig.getSchema().getFieldSpecFor(column).getDataType());
                if (statisticsCollector.getPartitionFunction() != null) {
                    LOGGER.info("partitions: " + statisticsCollector.getPartitions().toString());
                }
                LOGGER.info("***********************************************");
            }
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while logging column stats", (Throwable)e);
        }
    }
}

