/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.column;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.local.segment.index.readers.BitmapInvertedIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.BytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.DoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.FloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.IntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LuceneFSTIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.NullValueVectorReaderImpl;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapDoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapFloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapIntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapLongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.OnHeapStringDictionary;
import org.apache.pinot.segment.local.segment.index.readers.RangeIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.local.segment.index.readers.bloom.BloomFilterReaderFactory;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitMVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedBitSVForwardIndexReaderV2;
import org.apache.pinot.segment.local.segment.index.readers.forward.FixedByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.VarByteChunkSVForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.geospatial.ImmutableH3IndexReader;
import org.apache.pinot.segment.local.segment.index.readers.json.ImmutableJsonIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.sorted.SortedIndexReaderImpl;
import org.apache.pinot.segment.local.segment.index.readers.text.LuceneTextIndexReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.H3IndexReader;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.JsonIndexReader;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.segment.spi.index.reader.TextIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhysicalColumnIndexContainer
implements ColumnIndexContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalColumnIndexContainer.class);
    private final ForwardIndexReader<?> _forwardIndex;
    private final InvertedIndexReader<?> _invertedIndex;
    private final InvertedIndexReader<?> _rangeIndex;
    private final TextIndexReader _textIndex;
    private final TextIndexReader _fstIndex;
    private final JsonIndexReader _jsonIndex;
    private final H3IndexReader _h3Index;
    private final BaseImmutableDictionary _dictionary;
    private final BloomFilterReader _bloomFilter;
    private final NullValueVectorReaderImpl _nullValueVectorReader;

    public PhysicalColumnIndexContainer(SegmentDirectory.Reader segmentReader, ColumnMetadata metadata, IndexLoadingConfig indexLoadingConfig, File segmentIndexDir) throws IOException {
        String columnName = metadata.getColumnName();
        boolean loadInvertedIndex = indexLoadingConfig.getInvertedIndexColumns().contains(columnName);
        boolean loadRangeIndex = indexLoadingConfig.getRangeIndexColumns().contains(columnName);
        boolean loadTextIndex = indexLoadingConfig.getTextIndexColumns().contains(columnName);
        boolean loadFSTIndex = indexLoadingConfig.getFSTIndexColumns().contains(columnName);
        boolean loadJsonIndex = indexLoadingConfig.getJsonIndexColumns().contains(columnName);
        boolean loadH3Index = indexLoadingConfig.getH3IndexConfigs().containsKey(columnName);
        boolean loadOnHeapDictionary = indexLoadingConfig.getOnHeapDictionaryColumns().contains(columnName);
        BloomFilterConfig bloomFilterConfig = indexLoadingConfig.getBloomFilterConfigs().get(columnName);
        if (segmentReader.hasIndexFor(columnName, ColumnIndexType.NULLVALUE_VECTOR)) {
            PinotDataBuffer nullValueVectorBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.NULLVALUE_VECTOR);
            this._nullValueVectorReader = new NullValueVectorReaderImpl(nullValueVectorBuffer);
        } else {
            this._nullValueVectorReader = null;
        }
        if (loadTextIndex) {
            Preconditions.checkState((boolean)segmentReader.hasIndexFor(columnName, ColumnIndexType.TEXT_INDEX));
            Map<String, Map<String, String>> columnProperties = indexLoadingConfig.getColumnProperties();
            this._textIndex = new LuceneTextIndexReader(columnName, segmentIndexDir, metadata.getTotalDocs(), columnProperties.get(columnName));
        } else {
            this._textIndex = null;
        }
        if (loadJsonIndex) {
            Preconditions.checkState((boolean)segmentReader.hasIndexFor(columnName, ColumnIndexType.JSON_INDEX));
            PinotDataBuffer jsonIndexBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.JSON_INDEX);
            this._jsonIndex = new ImmutableJsonIndexReader(jsonIndexBuffer, metadata.getTotalDocs());
        } else {
            this._jsonIndex = null;
        }
        if (loadH3Index) {
            Preconditions.checkState((boolean)segmentReader.hasIndexFor(columnName, ColumnIndexType.H3_INDEX));
            PinotDataBuffer h3IndexBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.H3_INDEX);
            this._h3Index = new ImmutableH3IndexReader(h3IndexBuffer);
        } else {
            this._h3Index = null;
        }
        if (bloomFilterConfig != null) {
            PinotDataBuffer bloomFilterBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.BLOOM_FILTER);
            this._bloomFilter = BloomFilterReaderFactory.getBloomFilterReader(bloomFilterBuffer, bloomFilterConfig.isLoadOnHeap());
        } else {
            this._bloomFilter = null;
        }
        PinotDataBuffer fwdIndexBuffer = segmentReader.getIndexFor(columnName, ColumnIndexType.FORWARD_INDEX);
        if (metadata.hasDictionary()) {
            this._dictionary = PhysicalColumnIndexContainer.loadDictionary(segmentReader.getIndexFor(columnName, ColumnIndexType.DICTIONARY), metadata, loadOnHeapDictionary);
            if (metadata.isSingleValue()) {
                if (metadata.isSorted()) {
                    SortedIndexReaderImpl sortedIndexReader = new SortedIndexReaderImpl(fwdIndexBuffer, metadata.getCardinality());
                    this._forwardIndex = sortedIndexReader;
                    this._invertedIndex = sortedIndexReader;
                    this._rangeIndex = null;
                    this._fstIndex = null;
                    return;
                }
                this._forwardIndex = new FixedBitSVForwardIndexReaderV2(fwdIndexBuffer, metadata.getTotalDocs(), metadata.getBitsPerElement());
            } else {
                this._forwardIndex = new FixedBitMVForwardIndexReader(fwdIndexBuffer, metadata.getTotalDocs(), metadata.getTotalNumberOfEntries(), metadata.getBitsPerElement());
            }
            this._invertedIndex = loadInvertedIndex ? new BitmapInvertedIndexReader(segmentReader.getIndexFor(columnName, ColumnIndexType.INVERTED_INDEX), metadata.getCardinality()) : null;
            this._fstIndex = loadFSTIndex ? new LuceneFSTIndexReader(segmentReader.getIndexFor(columnName, ColumnIndexType.FST_INDEX)) : null;
            this._rangeIndex = loadRangeIndex ? new RangeIndexReader(segmentReader.getIndexFor(columnName, ColumnIndexType.RANGE_INDEX)) : null;
        } else {
            this._forwardIndex = PhysicalColumnIndexContainer.loadRawForwardIndex(fwdIndexBuffer, metadata.getDataType());
            this._dictionary = null;
            this._rangeIndex = null;
            this._invertedIndex = null;
            this._fstIndex = null;
        }
    }

    public ForwardIndexReader<?> getForwardIndex() {
        return this._forwardIndex;
    }

    public InvertedIndexReader<?> getInvertedIndex() {
        return this._invertedIndex;
    }

    public InvertedIndexReader<?> getRangeIndex() {
        return this._rangeIndex;
    }

    public TextIndexReader getTextIndex() {
        return this._textIndex;
    }

    public JsonIndexReader getJsonIndex() {
        return this._jsonIndex;
    }

    public H3IndexReader getH3Index() {
        return this._h3Index;
    }

    public BaseImmutableDictionary getDictionary() {
        return this._dictionary;
    }

    public BloomFilterReader getBloomFilter() {
        return this._bloomFilter;
    }

    public TextIndexReader getFSTIndex() {
        return this._fstIndex;
    }

    public NullValueVectorReader getNullValueVector() {
        return this._nullValueVectorReader;
    }

    public static BaseImmutableDictionary loadDictionary(PinotDataBuffer dictionaryBuffer, ColumnMetadata metadata, boolean loadOnHeap) {
        FieldSpec.DataType dataType = metadata.getDataType();
        if (loadOnHeap) {
            String columnName = metadata.getColumnName();
            LOGGER.info("Loading on-heap dictionary for column: {}", (Object)columnName);
        }
        int length = metadata.getCardinality();
        switch (dataType.getStoredType()) {
            case INT: {
                return loadOnHeap ? new OnHeapIntDictionary(dictionaryBuffer, length) : new IntDictionary(dictionaryBuffer, length);
            }
            case LONG: {
                return loadOnHeap ? new OnHeapLongDictionary(dictionaryBuffer, length) : new LongDictionary(dictionaryBuffer, length);
            }
            case FLOAT: {
                return loadOnHeap ? new OnHeapFloatDictionary(dictionaryBuffer, length) : new FloatDictionary(dictionaryBuffer, length);
            }
            case DOUBLE: {
                return loadOnHeap ? new OnHeapDoubleDictionary(dictionaryBuffer, length) : new DoubleDictionary(dictionaryBuffer, length);
            }
            case STRING: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                byte paddingByte = (byte)metadata.getPaddingCharacter();
                return loadOnHeap ? new OnHeapStringDictionary(dictionaryBuffer, length, numBytesPerValue, paddingByte) : new StringDictionary(dictionaryBuffer, length, numBytesPerValue, paddingByte);
            }
            case BYTES: {
                int numBytesPerValue = metadata.getColumnMaxLength();
                return new BytesDictionary(dictionaryBuffer, length, numBytesPerValue);
            }
        }
        throw new IllegalStateException("Illegal data type for dictionary: " + dataType);
    }

    private static ForwardIndexReader<?> loadRawForwardIndex(PinotDataBuffer forwardIndexBuffer, FieldSpec.DataType dataType) {
        FieldSpec.DataType storedType = dataType.getStoredType();
        switch (storedType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return new FixedByteChunkSVForwardIndexReader(forwardIndexBuffer, storedType);
            }
            case STRING: 
            case BYTES: {
                return new VarByteChunkSVForwardIndexReader(forwardIndexBuffer, storedType);
            }
        }
        throw new IllegalStateException("Illegal data type for raw forward index: " + dataType);
    }

    public void close() throws IOException {
        this._forwardIndex.close();
        if (this._invertedIndex != null) {
            this._invertedIndex.close();
        }
        if (this._rangeIndex != null) {
            this._rangeIndex.close();
        }
        if (this._dictionary != null) {
            this._dictionary.close();
        }
        if (this._textIndex != null) {
            this._textIndex.close();
        }
        if (this._fstIndex != null) {
            this._fstIndex.close();
        }
        if (this._jsonIndex != null) {
            this._jsonIndex.close();
        }
        if (this._h3Index != null) {
            this._h3Index.close();
        }
        if (this._bloomFilter != null) {
            this._bloomFilter.close();
        }
    }
}

