/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.bloomfilter.BloomFilterHandler;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGenerator;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.DefaultColumnHandler;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.DefaultColumnHandlerFactory;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.H3IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.InvertedIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.JsonIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.LuceneFSTIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.RangeIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.invertedindex.TextIndexHandler;
import org.apache.pinot.segment.local.startree.StarTreeBuilderUtils;
import org.apache.pinot.segment.local.startree.v2.builder.MultipleTreesBuilder;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPreProcessor
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPreProcessor.class);
    private final File _indexDir;
    private final IndexLoadingConfig _indexLoadingConfig;
    private final Schema _schema;
    private final SegmentDirectory _segmentDirectory;
    private SegmentMetadataImpl _segmentMetadata;

    public SegmentPreProcessor(SegmentDirectory segmentDirectory, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) throws Exception {
        this._segmentDirectory = segmentDirectory;
        this._indexDir = new File(segmentDirectory.getIndexDir());
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._segmentMetadata = segmentDirectory.getSegmentMetadata();
    }

    public void process() throws Exception {
        if (this._segmentMetadata.getTotalDocs() == 0) {
            LOGGER.info("Skip preprocessing empty segment: {}", (Object)this._segmentMetadata.getName());
            return;
        }
        File[] directoryListing = this._indexDir.listFiles();
        String tempFileExtension = ".bitmap.inv.tmp";
        if (directoryListing != null) {
            for (File child : directoryListing) {
                if (!child.getName().endsWith(tempFileExtension)) continue;
                FileUtils.deleteQuietly((File)child);
            }
        }
        try (SegmentDirectory.Writer segmentWriter = this._segmentDirectory.createWriter();){
            ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode;
            Set<String> fstIndexColumns;
            if (this._schema != null) {
                DefaultColumnHandler defaultColumnHandler = DefaultColumnHandlerFactory.getDefaultColumnHandler(this._indexDir, this._segmentMetadata, this._indexLoadingConfig, this._schema, segmentWriter);
                defaultColumnHandler.updateDefaultColumns();
                this._segmentMetadata = new SegmentMetadataImpl(this._indexDir);
                this._segmentDirectory.reloadMetadata();
            } else {
                LOGGER.warn("Skip creating default columns for segment: {} without schema", (Object)this._segmentMetadata.getName());
            }
            InvertedIndexHandler invertedIndexHandler = new InvertedIndexHandler(this._indexDir, (SegmentMetadata)this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            invertedIndexHandler.createInvertedIndices();
            RangeIndexHandler rangeIndexHandler = new RangeIndexHandler(this._indexDir, (SegmentMetadata)this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            rangeIndexHandler.createRangeIndices();
            Set<String> textIndexColumns = this._indexLoadingConfig.getTextIndexColumns();
            if (!textIndexColumns.isEmpty()) {
                TextIndexHandler textIndexHandler = new TextIndexHandler(this._indexDir, (SegmentMetadata)this._segmentMetadata, textIndexColumns, segmentWriter);
                textIndexHandler.createTextIndexesOnSegmentLoad();
            }
            if (!(fstIndexColumns = this._indexLoadingConfig.getFSTIndexColumns()).isEmpty()) {
                LuceneFSTIndexHandler luceneFSTIndexHandler = new LuceneFSTIndexHandler(this._indexDir, (SegmentMetadata)this._segmentMetadata, fstIndexColumns, segmentWriter);
                luceneFSTIndexHandler.createFSTIndexesOnSegmentLoad();
            }
            JsonIndexHandler jsonIndexHandler = new JsonIndexHandler(this._indexDir, (SegmentMetadata)this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            jsonIndexHandler.createJsonIndices();
            if (this._indexLoadingConfig.getH3IndexConfigs() != null) {
                H3IndexHandler h3IndexHandler = new H3IndexHandler(this._indexDir, this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
                h3IndexHandler.createH3Indices();
            }
            BloomFilterHandler bloomFilterHandler = new BloomFilterHandler(this._indexDir, this._segmentMetadata, this._indexLoadingConfig, segmentWriter);
            bloomFilterHandler.createBloomFilters();
            if (this._indexLoadingConfig.isEnableDynamicStarTreeCreation()) {
                List<StarTreeV2BuilderConfig> starTreeBuilderConfigs = StarTreeBuilderUtils.generateBuilderConfigs(this._indexLoadingConfig.getStarTreeIndexConfigs(), this._indexLoadingConfig.isEnableDefaultStarTree(), (SegmentMetadata)this._segmentMetadata);
                boolean shouldGenerateStarTree = !starTreeBuilderConfigs.isEmpty();
                List starTreeMetadataList = this._segmentMetadata.getStarTreeV2MetadataList();
                if (starTreeMetadataList != null) {
                    if (StarTreeBuilderUtils.shouldRemoveExistingStarTrees(starTreeBuilderConfigs, starTreeMetadataList)) {
                        LOGGER.info("Removing star-trees from segment: {}", (Object)this._segmentMetadata.getName());
                        StarTreeBuilderUtils.removeStarTrees(this._indexDir);
                        this._segmentMetadata = new SegmentMetadataImpl(this._indexDir);
                    } else {
                        shouldGenerateStarTree = false;
                    }
                }
                if (shouldGenerateStarTree) {
                    try (MultipleTreesBuilder builder = new MultipleTreesBuilder(starTreeBuilderConfigs, this._indexDir, MultipleTreesBuilder.BuildMode.OFF_HEAP);){
                        builder.build();
                    }
                    this._segmentMetadata = new SegmentMetadataImpl(this._indexDir);
                }
            }
            if ((columnMinMaxValueGeneratorMode = this._indexLoadingConfig.getColumnMinMaxValueGeneratorMode()) != ColumnMinMaxValueGeneratorMode.NONE) {
                ColumnMinMaxValueGenerator columnMinMaxValueGenerator = new ColumnMinMaxValueGenerator(this._segmentMetadata, segmentWriter, columnMinMaxValueGeneratorMode);
                columnMinMaxValueGenerator.addColumnMinMaxValue();
            }
            segmentWriter.save();
        }
    }

    @Override
    public void close() throws Exception {
        this._segmentDirectory.close();
    }
}

