/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.bloomfilter;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.creator.impl.bloom.OnHeapGuavaBloomFilterCreator;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.local.segment.index.readers.BytesDictionary;
import org.apache.pinot.segment.local.segment.index.readers.DoubleDictionary;
import org.apache.pinot.segment.local.segment.index.readers.FloatDictionary;
import org.apache.pinot.segment.local.segment.index.readers.IntDictionary;
import org.apache.pinot.segment.local.segment.index.readers.LongDictionary;
import org.apache.pinot.segment.local.segment.index.readers.StringDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BloomFilterHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Map<String, BloomFilterConfig> _bloomFilterConfigs;
    private final Set<ColumnMetadata> _bloomFilterColumns = new HashSet<ColumnMetadata>();

    public BloomFilterHandler(File indexDir, SegmentMetadataImpl segmentMetadata, IndexLoadingConfig indexLoadingConfig, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = segmentMetadata.getVersion();
        this._bloomFilterConfigs = indexLoadingConfig.getBloomFilterConfigs();
        for (String column : this._bloomFilterConfigs.keySet()) {
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null) continue;
            this._bloomFilterColumns.add(columnMetadata);
        }
    }

    public void createBloomFilters() throws Exception {
        for (ColumnMetadata columnMetadata : this._bloomFilterColumns) {
            if (!columnMetadata.hasDictionary()) continue;
            this.createBloomFilterForColumn(columnMetadata);
        }
    }

    private void createBloomFilterForColumn(ColumnMetadata columnMetadata) throws Exception {
        String columnName = columnMetadata.getColumnName();
        File bloomFilterFileInProgress = new File(this._indexDir, columnName + ".bloom.inprogress");
        File bloomFilterFile = new File(this._indexDir, columnName + ".bloom");
        if (!bloomFilterFileInProgress.exists()) {
            if (this._segmentWriter.hasIndexFor(columnName, ColumnIndexType.BLOOM_FILTER)) {
                LOGGER.info("Found bloom filter for segment: {}, column: {}", (Object)this._segmentName, (Object)columnName);
                return;
            }
            FileUtils.touch((File)bloomFilterFileInProgress);
        } else {
            FileUtils.deleteQuietly((File)bloomFilterFile);
        }
        BloomFilterConfig bloomFilterConfig = this._bloomFilterConfigs.get(columnName);
        LOGGER.info("Creating new bloom filter for segment: {}, column: {} with config: {}", new Object[]{this._segmentName, columnName, bloomFilterConfig});
        try (OnHeapGuavaBloomFilterCreator bloomFilterCreator = new OnHeapGuavaBloomFilterCreator(this._indexDir, columnName, columnMetadata.getCardinality(), bloomFilterConfig);
             BaseImmutableDictionary dictionary = this.getDictionaryReader(columnMetadata, this._segmentWriter);){
            int length = dictionary.length();
            for (int i = 0; i < length; ++i) {
                bloomFilterCreator.add(dictionary.getStringValue(i));
            }
            bloomFilterCreator.seal();
        }
        if (this._segmentVersion == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(this._segmentWriter, columnName, bloomFilterFile, ColumnIndexType.BLOOM_FILTER);
        }
        FileUtils.deleteQuietly((File)bloomFilterFileInProgress);
        LOGGER.info("Created bloom filter for segment: {}, column: {}", (Object)this._segmentName, (Object)columnName);
    }

    private BaseImmutableDictionary getDictionaryReader(ColumnMetadata columnMetadata, SegmentDirectory.Writer segmentWriter) throws IOException {
        PinotDataBuffer dictionaryBuffer = segmentWriter.getIndexFor(columnMetadata.getColumnName(), ColumnIndexType.DICTIONARY);
        int cardinality = columnMetadata.getCardinality();
        FieldSpec.DataType dataType = columnMetadata.getDataType();
        switch (dataType) {
            case INT: {
                return new IntDictionary(dictionaryBuffer, cardinality);
            }
            case LONG: {
                return new LongDictionary(dictionaryBuffer, cardinality);
            }
            case FLOAT: {
                return new FloatDictionary(dictionaryBuffer, cardinality);
            }
            case DOUBLE: {
                return new DoubleDictionary(dictionaryBuffer, cardinality);
            }
            case STRING: {
                return new StringDictionary(dictionaryBuffer, cardinality, columnMetadata.getColumnMaxLength(), (byte)columnMetadata.getPaddingCharacter());
            }
            case BYTES: {
                return new BytesDictionary(dictionaryBuffer, cardinality, columnMetadata.getColumnMaxLength());
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnMetadata.getColumnName());
    }
}

