/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.defaultcolumn;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentColumnarIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentDictionaryCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.MultiValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueSortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.fwd.SingleValueUnsortedForwardIndexCreator;
import org.apache.pinot.segment.local.segment.creator.impl.stats.AbstractColumnStatisticsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.BytesColumnPredIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.DoubleColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.FloatColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.IntColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.LongColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.creator.impl.stats.StringColumnPreIndexStatsCollector;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.DefaultColumnHandler;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.DefaultColumnStatistics;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.ColumnIndexCreationInfo;
import org.apache.pinot.segment.spi.creator.ColumnStatistics;
import org.apache.pinot.segment.spi.creator.StatsCollectorConfig;
import org.apache.pinot.segment.spi.index.creator.TextIndexType;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.ByteArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDefaultColumnHandler
implements DefaultColumnHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDefaultColumnHandler.class);
    protected final File _indexDir;
    protected final SegmentMetadataImpl _segmentMetadata;
    protected final IndexLoadingConfig _indexLoadingConfig;
    protected final Schema _schema;
    protected final SegmentDirectory.Writer _segmentWriter;
    private final PropertiesConfiguration _segmentProperties;

    protected BaseDefaultColumnHandler(File indexDir, SegmentMetadataImpl segmentMetadata, IndexLoadingConfig indexLoadingConfig, Schema schema, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentMetadata = segmentMetadata;
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._segmentWriter = segmentWriter;
        this._segmentProperties = SegmentMetadataImpl.getPropertiesConfiguration((File)indexDir);
    }

    @Override
    public void updateDefaultColumns() throws Exception {
        Map<String, DefaultColumnAction> defaultColumnActionMap = this.computeDefaultColumnActionMap();
        if (defaultColumnActionMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, DefaultColumnAction>> entryIterator = defaultColumnActionMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, DefaultColumnAction> entry = entryIterator.next();
            if (this.updateDefaultColumn(entry.getKey(), entry.getValue())) continue;
            entryIterator.remove();
        }
        List<String> dimensionColumns = LoaderUtils.getStringListFromSegmentProperties("segment.dimension.column.names", this._segmentProperties);
        List<String> metricColumns = LoaderUtils.getStringListFromSegmentProperties("segment.metric.column.names", this._segmentProperties);
        List<String> dateTimeColumns = LoaderUtils.getStringListFromSegmentProperties("segment.datetime.column.names", this._segmentProperties);
        for (Map.Entry<String, DefaultColumnAction> entry : defaultColumnActionMap.entrySet()) {
            String column = entry.getKey();
            DefaultColumnAction action = entry.getValue();
            switch (action) {
                case ADD_DIMENSION: {
                    dimensionColumns.add(column);
                    break;
                }
                case ADD_METRIC: {
                    metricColumns.add(column);
                    break;
                }
                case ADD_DATE_TIME: {
                    dateTimeColumns.add(column);
                    break;
                }
                case REMOVE_DIMENSION: {
                    dimensionColumns.remove(column);
                    break;
                }
                case REMOVE_METRIC: {
                    metricColumns.remove(column);
                    break;
                }
                case REMOVE_DATE_TIME: {
                    dateTimeColumns.remove(column);
                }
            }
        }
        this._segmentProperties.setProperty("segment.dimension.column.names", dimensionColumns);
        this._segmentProperties.setProperty("segment.metric.column.names", metricColumns);
        this._segmentProperties.setProperty("segment.datetime.column.names", dateTimeColumns);
        File metadataFile = this._segmentProperties.getFile();
        File metadataBackUpFile = new File(metadataFile + ".bak");
        if (!metadataBackUpFile.exists()) {
            FileUtils.copyFile((File)metadataFile, (File)metadataBackUpFile);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(this._segmentProperties.getFile());){
            this._segmentProperties.save((OutputStream)fileOutputStream);
        }
    }

    @VisibleForTesting
    Map<String, DefaultColumnAction> computeDefaultColumnActionMap() {
        HashMap<String, DefaultColumnAction> defaultColumnActionMap = new HashMap<String, DefaultColumnAction>();
        Set columnsInSchema = this._schema.getPhysicalColumnNames();
        block5: for (String column : columnsInSchema) {
            FieldSpec fieldSpecInSchema = this._schema.getFieldSpecFor(column);
            Preconditions.checkNotNull((Object)fieldSpecInSchema);
            FieldSpec.FieldType fieldTypeInSchema = fieldSpecInSchema.getFieldType();
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata != null) {
                if (!columnMetadata.isAutoGenerated()) continue;
                FieldSpec fieldSpecInMetadata = columnMetadata.getFieldSpec();
                FieldSpec.FieldType fieldTypeInMetadata = fieldSpecInMetadata.getFieldType();
                if (fieldTypeInMetadata != fieldTypeInSchema) {
                    String failureMessage = "Field type: " + fieldTypeInMetadata + " for auto-generated column: " + column + " does not match field type: " + fieldTypeInSchema + " in schema, throw exception to drop and re-download the segment.";
                    throw new RuntimeException(failureMessage);
                }
                FieldSpec.DataType dataTypeInMetadata = fieldSpecInMetadata.getDataType();
                FieldSpec.DataType dataTypeInSchema = fieldSpecInSchema.getDataType();
                boolean isSingleValueInMetadata = fieldSpecInMetadata.isSingleValueField();
                boolean isSingleValueInSchema = fieldSpecInSchema.isSingleValueField();
                String defaultValueInMetadata = fieldSpecInMetadata.getDefaultNullValueString();
                String defaultValueInSchema = fieldSpecInSchema.getDefaultNullValueString();
                if (fieldTypeInMetadata == FieldSpec.FieldType.DIMENSION) {
                    if (dataTypeInMetadata != dataTypeInSchema) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_DATA_TYPE);
                        continue;
                    }
                    if (!defaultValueInSchema.equals(defaultValueInMetadata)) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_DEFAULT_VALUE);
                        continue;
                    }
                    if (isSingleValueInMetadata == isSingleValueInSchema) continue;
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DIMENSION_NUMBER_OF_VALUES);
                    continue;
                }
                if (fieldTypeInMetadata == FieldSpec.FieldType.METRIC) {
                    if (dataTypeInMetadata != dataTypeInSchema) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_DATA_TYPE);
                        continue;
                    }
                    if (!defaultValueInSchema.equals(defaultValueInMetadata)) {
                        defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_DEFAULT_VALUE);
                        continue;
                    }
                    if (isSingleValueInMetadata == isSingleValueInSchema) continue;
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_METRIC_NUMBER_OF_VALUES);
                    continue;
                }
                if (fieldTypeInMetadata != FieldSpec.FieldType.DATE_TIME) continue;
                if (dataTypeInMetadata != dataTypeInSchema) {
                    defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DATE_TIME_DATA_TYPE);
                    continue;
                }
                if (defaultValueInSchema.equals(defaultValueInMetadata)) continue;
                defaultColumnActionMap.put(column, DefaultColumnAction.UPDATE_DATE_TIME_DEFAULT_VALUE);
                continue;
            }
            switch (fieldTypeInSchema) {
                case DIMENSION: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_DIMENSION);
                    continue block5;
                }
                case METRIC: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_METRIC);
                    continue block5;
                }
                case DATE_TIME: {
                    defaultColumnActionMap.put(column, DefaultColumnAction.ADD_DATE_TIME);
                }
            }
            LOGGER.warn("Skip adding default column for column: {} with field type: {}", (Object)column, (Object)fieldTypeInSchema);
        }
        Set columnsInMetadata = this._segmentMetadata.getAllColumns();
        for (String column : columnsInMetadata) {
            ColumnMetadata columnMetadata;
            if (columnsInSchema.contains(column) || !(columnMetadata = this._segmentMetadata.getColumnMetadataFor(column)).isAutoGenerated()) continue;
            FieldSpec.FieldType fieldTypeInMetadata = columnMetadata.getFieldSpec().getFieldType();
            if (fieldTypeInMetadata == FieldSpec.FieldType.DIMENSION) {
                defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_DIMENSION);
                continue;
            }
            if (fieldTypeInMetadata == FieldSpec.FieldType.METRIC) {
                defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_METRIC);
                continue;
            }
            if (fieldTypeInMetadata != FieldSpec.FieldType.DATE_TIME) continue;
            defaultColumnActionMap.put(column, DefaultColumnAction.REMOVE_DATE_TIME);
        }
        return defaultColumnActionMap;
    }

    protected abstract boolean updateDefaultColumn(String var1, DefaultColumnAction var2) throws Exception;

    protected void removeColumnV1Indices(String column) throws IOException {
        FileUtils.forceDelete((File)new File(this._indexDir, column + ".dict"));
        File svFwdIndex = new File(this._indexDir, column + ".sv.sorted.fwd");
        if (svFwdIndex.exists()) {
            FileUtils.forceDelete((File)svFwdIndex);
        } else {
            FileUtils.forceDelete((File)new File(this._indexDir, column + ".mv.fwd"));
        }
        SegmentColumnarIndexCreator.removeColumnMetadataInfo(this._segmentProperties, column);
    }

    protected boolean createColumnV1Indices(String column) throws Exception {
        TableConfig tableConfig = this._indexLoadingConfig.getTableConfig();
        if (tableConfig != null && tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getTransformConfigs() != null) {
            List transformConfigs = tableConfig.getIngestionConfig().getTransformConfigs();
            for (TransformConfig transformConfig : transformConfigs) {
                if (!transformConfig.getColumnName().equals(column)) continue;
                String transformFunction = transformConfig.getTransformFunction();
                FunctionEvaluator functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(transformFunction);
                List<String> arguments = functionEvaluator.getArguments();
                ArrayList<ColumnMetadata> argumentsMetadata = new ArrayList<ColumnMetadata>(arguments.size());
                for (String argument : arguments) {
                    ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(argument);
                    if (columnMetadata == null) {
                        LOGGER.warn("Skip creating derived column: {} because argument: {} does not exist in the segment", (Object)column, (Object)argument);
                        return false;
                    }
                    argumentsMetadata.add(columnMetadata);
                }
                if (this._indexLoadingConfig.getNoDictionaryColumns().contains(column)) {
                    LOGGER.warn("Skip creating raw derived column: {}", (Object)column);
                    return false;
                }
                if (!this._schema.getFieldSpecFor(column).isSingleValueField()) {
                    LOGGER.warn("Skip creating MV derived column: {}, creating default value column instead", (Object)column);
                    return false;
                }
                try {
                    this.createDerivedColumnV1Indices(column, functionEvaluator, argumentsMetadata);
                    return true;
                }
                catch (Exception e) {
                    LOGGER.error("Caught exception while creating derived column: {} with transform function: {}", new Object[]{column, transformFunction, e});
                    return false;
                }
            }
        }
        this.createDefaultValueColumnV1Indices(column);
        return true;
    }

    private void createDefaultValueColumnV1Indices(String column) throws Exception {
        Object[] sortedArray;
        FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
        int totalDocs = this._segmentMetadata.getTotalDocs();
        FieldSpec.DataType dataType = fieldSpec.getDataType();
        Object defaultValue = fieldSpec.getDefaultNullValue();
        boolean isSingleValue = fieldSpec.isSingleValueField();
        int maxNumberOfMultiValueElements = isSingleValue ? 0 : 1;
        int dictionaryElementSize = 0;
        switch (dataType.getStoredType()) {
            case INT: {
                Preconditions.checkState((boolean)(defaultValue instanceof Integer));
                sortedArray = new int[]{(Integer)defaultValue};
                break;
            }
            case LONG: {
                Preconditions.checkState((boolean)(defaultValue instanceof Long));
                sortedArray = new long[]{(Long)defaultValue};
                break;
            }
            case FLOAT: {
                Preconditions.checkState((boolean)(defaultValue instanceof Float));
                sortedArray = new float[]{((Float)defaultValue).floatValue()};
                break;
            }
            case DOUBLE: {
                Preconditions.checkState((boolean)(defaultValue instanceof Double));
                sortedArray = new double[]{(Double)defaultValue};
                break;
            }
            case STRING: {
                Preconditions.checkState((boolean)(defaultValue instanceof String));
                String stringDefaultValue = (String)defaultValue;
                dictionaryElementSize = StringUtil.encodeUtf8((String)stringDefaultValue).length;
                sortedArray = new String[]{stringDefaultValue};
                break;
            }
            case BYTES: {
                Preconditions.checkState((boolean)(defaultValue instanceof byte[]));
                dictionaryElementSize = ((byte[])defaultValue).length;
                ByteArray bytesDefaultValue = new ByteArray((byte[])defaultValue);
                defaultValue = bytesDefaultValue;
                sortedArray = new ByteArray[]{bytesDefaultValue};
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for column: " + column);
            }
        }
        DefaultColumnStatistics columnStatistics = new DefaultColumnStatistics(defaultValue, defaultValue, sortedArray, isSingleValue, totalDocs, maxNumberOfMultiValueElements);
        ColumnIndexCreationInfo columnIndexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)columnStatistics, true, false, true, defaultValue);
        try (SegmentDictionaryCreator creator = new SegmentDictionaryCreator(sortedArray, fieldSpec, this._indexDir, false);){
            creator.build();
        }
        if (isSingleValue) {
            try (SingleValueSortedForwardIndexCreator svFwdIndexCreator = new SingleValueSortedForwardIndexCreator(this._indexDir, fieldSpec.getName(), 1);){
                for (int docId = 0; docId < totalDocs; ++docId) {
                    svFwdIndexCreator.putDictId(0);
                }
            }
        }
        try (MultiValueUnsortedForwardIndexCreator mvFwdIndexCreator = new MultiValueUnsortedForwardIndexCreator(this._indexDir, fieldSpec.getName(), 1, totalDocs, totalDocs);){
            int[] dictIds = new int[]{0};
            for (int docId = 0; docId < totalDocs; ++docId) {
                mvFwdIndexCreator.putDictIdMV(dictIds);
            }
        }
        SegmentColumnarIndexCreator.addColumnMetadataInfo(this._segmentProperties, column, columnIndexCreationInfo, totalDocs, fieldSpec, true, dictionaryElementSize, true, TextIndexType.NONE, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDerivedColumnV1Indices(String column, FunctionEvaluator functionEvaluator, List<ColumnMetadata> argumentsMetadata) throws Exception {
        int numArguments = argumentsMetadata.size();
        ArrayList<ValueReader> valueReaders = new ArrayList<ValueReader>(numArguments);
        for (ColumnMetadata argumentMetadata : argumentsMetadata) {
            valueReaders.add(new ValueReader(argumentMetadata));
        }
        try {
            ColumnIndexCreationInfo indexCreationInfo;
            Object[] inputValues = new Object[numArguments];
            int numDocs = this._segmentMetadata.getTotalDocs();
            Object[] outputValues = new Object[numDocs];
            for (int i = 0; i < numDocs; ++i) {
                for (int j = 0; j < numArguments; ++j) {
                    inputValues[j] = ((ValueReader)valueReaders.get(j)).getValue(i);
                }
                outputValues[i] = functionEvaluator.evaluate(inputValues);
            }
            FieldSpec fieldSpec = this._schema.getFieldSpecFor(column);
            StatsCollectorConfig statsCollectorConfig = new StatsCollectorConfig(this._indexLoadingConfig.getTableConfig(), this._schema, null);
            switch (fieldSpec.getDataType().getStoredType()) {
                case INT: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = ((Number)outputValues[i]).intValue();
                    }
                    AbstractColumnStatisticsCollector statsCollector = new IntColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((IntColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((IntColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, true, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case LONG: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = ((Number)outputValues[i]).longValue();
                    }
                    AbstractColumnStatisticsCollector statsCollector = new LongColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((LongColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((LongColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, true, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case FLOAT: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = Float.valueOf(((Number)outputValues[i]).floatValue());
                    }
                    AbstractColumnStatisticsCollector statsCollector = new FloatColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((FloatColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((FloatColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, true, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case DOUBLE: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = ((Number)outputValues[i]).doubleValue();
                    }
                    AbstractColumnStatisticsCollector statsCollector = new DoubleColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((DoubleColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((DoubleColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, true, false, true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case STRING: {
                    for (int i = 0; i < numDocs; ++i) {
                        outputValues[i] = outputValues[i].toString();
                    }
                    AbstractColumnStatisticsCollector statsCollector = new StringColumnPreIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((StringColumnPreIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((StringColumnPreIndexStatsCollector)statsCollector).seal();
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, true, this._indexLoadingConfig.getVarLengthDictionaryColumns().contains(column), true, fieldSpec.getDefaultNullValue());
                    break;
                }
                case BYTES: {
                    AbstractColumnStatisticsCollector statsCollector = new BytesColumnPredIndexStatsCollector(column, statsCollectorConfig);
                    for (Object value : outputValues) {
                        ((BytesColumnPredIndexStatsCollector)statsCollector).collect(value);
                    }
                    ((BytesColumnPredIndexStatsCollector)statsCollector).seal();
                    boolean useVarLengthDictionary = !statsCollector.isFixedLength() ? true : this._indexLoadingConfig.getVarLengthDictionaryColumns().contains(column);
                    indexCreationInfo = new ColumnIndexCreationInfo((ColumnStatistics)statsCollector, true, useVarLengthDictionary, true, (Object)new ByteArray((byte[])fieldSpec.getDefaultNullValue()));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            try (SegmentDictionaryCreator dictionaryCreator = new SegmentDictionaryCreator(indexCreationInfo.getSortedUniqueElementsArray(), fieldSpec, this._indexDir, indexCreationInfo.isUseVarLengthDictionary());){
                dictionaryCreator.build();
                int cardinality = indexCreationInfo.getDistinctValueCount();
                try (Object forwardIndexCreator = indexCreationInfo.isSorted() ? new SingleValueSortedForwardIndexCreator(this._indexDir, column, cardinality) : new SingleValueUnsortedForwardIndexCreator(this._indexDir, column, cardinality, numDocs);){
                    for (int i = 0; i < numDocs; ++i) {
                        forwardIndexCreator.putDictId(dictionaryCreator.indexOfSV(outputValues[i]));
                    }
                }
                SegmentColumnarIndexCreator.addColumnMetadataInfo(this._segmentProperties, column, indexCreationInfo, numDocs, fieldSpec, true, dictionaryCreator.getNumBytesPerEntry(), true, TextIndexType.NONE, false, false);
            }
        }
        finally {
            for (ValueReader valueReader : valueReaders) {
                valueReader.close();
            }
        }
    }

    private class ValueReader
    implements Closeable {
        final ForwardIndexReader _forwardIndexReader;
        final Dictionary _dictionary;
        final PinotSegmentColumnReader _columnReader;

        ValueReader(ColumnMetadata columnMetadata) throws IOException {
            this._forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)BaseDefaultColumnHandler.this._segmentWriter, columnMetadata);
            this._dictionary = columnMetadata.hasDictionary() ? LoaderUtils.getDictionary((SegmentDirectory.Reader)BaseDefaultColumnHandler.this._segmentWriter, columnMetadata) : null;
            this._columnReader = new PinotSegmentColumnReader(this._forwardIndexReader, this._dictionary, null, columnMetadata.getMaxNumberOfMultiValues());
        }

        Object getValue(int docId) {
            return this._columnReader.getValue(docId);
        }

        @Override
        public void close() throws IOException {
            this._columnReader.close();
            if (this._dictionary != null) {
                this._dictionary.close();
            }
            this._forwardIndexReader.close();
        }
    }

    protected static enum DefaultColumnAction {
        ADD_DIMENSION,
        ADD_METRIC,
        ADD_DATE_TIME,
        REMOVE_DIMENSION,
        REMOVE_METRIC,
        REMOVE_DATE_TIME,
        UPDATE_DIMENSION_DATA_TYPE,
        UPDATE_DIMENSION_DEFAULT_VALUE,
        UPDATE_DIMENSION_NUMBER_OF_VALUES,
        UPDATE_METRIC_DATA_TYPE,
        UPDATE_METRIC_DEFAULT_VALUE,
        UPDATE_METRIC_NUMBER_OF_VALUES,
        UPDATE_DATE_TIME_DATA_TYPE,
        UPDATE_DATE_TIME_DEFAULT_VALUE;


        boolean isAddAction() {
            return this == ADD_DIMENSION || this == ADD_METRIC || this == ADD_DATE_TIME;
        }

        boolean isUpdateAction() {
            return !this.isAddAction() && !this.isRemoveAction();
        }

        boolean isRemoveAction() {
            return this == REMOVE_DIMENSION || this == REMOVE_METRIC || this == REMOVE_DATE_TIME;
        }
    }
}

