/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.creator.impl.inv.geospatial.OffHeapH3IndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.local.utils.GeometrySerializer;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H3IndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(H3IndexHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Set<ColumnMetadata> _h3IndexColumns = new HashSet<ColumnMetadata>();
    private final Map<String, H3IndexConfig> _h3IndexConfigs = new HashMap<String, H3IndexConfig>();

    public H3IndexHandler(File indexDir, SegmentMetadataImpl segmentMetadata, IndexLoadingConfig indexLoadingConfig, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = segmentMetadata.getVersion();
        for (Map.Entry<String, H3IndexConfig> entry : indexLoadingConfig.getH3IndexConfigs().entrySet()) {
            String column = entry.getKey();
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null) continue;
            this._h3IndexColumns.add(columnMetadata);
            this._h3IndexConfigs.put(column, entry.getValue());
        }
    }

    public void createH3Indices() throws Exception {
        for (ColumnMetadata columnMetadata : this._h3IndexColumns) {
            this.createH3IndexForColumn(columnMetadata);
        }
    }

    private void createH3IndexForColumn(ColumnMetadata columnMetadata) throws Exception {
        String column = columnMetadata.getColumnName();
        File inProgress = new File(this._indexDir, column + ".h3.idx.inprogress");
        File h3IndexFile = new File(this._indexDir, column + ".h3.idx");
        if (!inProgress.exists()) {
            if (this._segmentWriter.hasIndexFor(column, ColumnIndexType.H3_INDEX)) {
                LOGGER.info("Found H3 index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
                return;
            }
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)h3IndexFile);
        }
        LOGGER.info("Creating new H3 index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
        Preconditions.checkState((columnMetadata.getDataType() == FieldSpec.DataType.BYTES ? 1 : 0) != 0, (Object)"H3 index can only be applied to BYTES columns");
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(columnMetadata);
        } else {
            this.handleNonDictionaryBasedColumn(columnMetadata);
        }
        if (this._segmentVersion == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(this._segmentWriter, column, h3IndexFile, ColumnIndexType.H3_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created H3 index for segment: {}, column: {}", (Object)this._segmentName, (Object)column);
    }

    private void handleDictionaryBasedColumn(ColumnMetadata columnMetadata) throws IOException {
        String columnName = columnMetadata.getColumnName();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             OffHeapH3IndexCreator h3IndexCreator = new OffHeapH3IndexCreator(this._indexDir, columnName, this._h3IndexConfigs.get(columnName).getResolution());){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                int dictId = forwardIndexReader.getDictId(i, readerContext);
                h3IndexCreator.add(GeometrySerializer.deserialize(dictionary.getBytesValue(dictId)));
            }
            h3IndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(ColumnMetadata columnMetadata) throws Exception {
        String columnName = columnMetadata.getColumnName();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             OffHeapH3IndexCreator h3IndexCreator = new OffHeapH3IndexCreator(this._indexDir, columnName, this._h3IndexConfigs.get(columnName).getResolution());){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                h3IndexCreator.add(GeometrySerializer.deserialize(forwardIndexReader.getBytes(i, readerContext)));
            }
            h3IndexCreator.seal();
        }
    }
}

