/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.OffHeapJsonIndexCreator;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonIndexHandler.class);
    private final File _indexDir;
    private final SegmentDirectory.Writer _segmentWriter;
    private final String _segmentName;
    private final SegmentVersion _segmentVersion;
    private final Set<ColumnMetadata> _jsonIndexColumns = new HashSet<ColumnMetadata>();

    public JsonIndexHandler(File indexDir, SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig, SegmentDirectory.Writer segmentWriter) {
        this._indexDir = indexDir;
        this._segmentWriter = segmentWriter;
        this._segmentName = segmentMetadata.getName();
        this._segmentVersion = segmentMetadata.getVersion();
        for (String column : indexLoadingConfig.getJsonIndexColumns()) {
            ColumnMetadata columnMetadata = segmentMetadata.getColumnMetadataFor(column);
            if (columnMetadata == null) continue;
            this._jsonIndexColumns.add(columnMetadata);
        }
    }

    public void createJsonIndices() throws Exception {
        for (ColumnMetadata columnMetadata : this._jsonIndexColumns) {
            this.createJsonIndexForColumn(columnMetadata);
        }
    }

    private void createJsonIndexForColumn(ColumnMetadata columnMetadata) throws Exception {
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(this._indexDir, columnName + ".json.idx.inprogress");
        File jsonIndexFile = new File(this._indexDir, columnName + ".json.idx");
        if (!inProgress.exists()) {
            if (this._segmentWriter.hasIndexFor(columnName, ColumnIndexType.JSON_INDEX)) {
                LOGGER.info("Found json index for segment: {}, column: {}", (Object)this._segmentName, (Object)columnName);
                return;
            }
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)jsonIndexFile);
        }
        LOGGER.info("Creating new json index for segment: {}, column: {}", (Object)this._segmentName, (Object)columnName);
        Preconditions.checkState((columnMetadata.isSingleValue() && columnMetadata.getDataType() == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"Json index can only be applied to single-value STRING columns");
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(columnMetadata);
        } else {
            this.handleNonDictionaryBasedColumn(columnMetadata);
        }
        if (this._segmentVersion == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(this._segmentWriter, columnName, jsonIndexFile, ColumnIndexType.JSON_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created json index for segment: {}, column: {}", (Object)this._segmentName, (Object)columnName);
        PropertiesConfiguration properties = SegmentMetadataImpl.getPropertiesConfiguration((File)this._indexDir);
        properties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)columnName, (String)"hasJsonIndex"), (Object)true);
        properties.save();
    }

    private void handleDictionaryBasedColumn(ColumnMetadata columnMetadata) throws IOException {
        String columnName = columnMetadata.getColumnName();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             OffHeapJsonIndexCreator jsonIndexCreator = new OffHeapJsonIndexCreator(this._indexDir, columnName);){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                int dictId = forwardIndexReader.getDictId(i, readerContext);
                jsonIndexCreator.add(dictionary.getStringValue(dictId));
            }
            jsonIndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(ColumnMetadata columnMetadata) throws IOException {
        String columnName = columnMetadata.getColumnName();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)this._segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             OffHeapJsonIndexCreator jsonIndexCreator = new OffHeapJsonIndexCreator(this._indexDir, columnName);){
            int numDocs = columnMetadata.getTotalDocs();
            for (int i = 0; i < numDocs; ++i) {
                jsonIndexCreator.add(forwardIndexReader.getString(i, readerContext));
            }
            jsonIndexCreator.seal();
        }
    }
}

